/*******************************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * $Id$
 * /
 *******************************************************************************/

package org.eclipse.jet.internal.taglib.workspace;


import java.text.MessageFormat;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jet.JET2Context;
import org.eclipse.jet.JET2Writer;
import org.eclipse.jet.internal.l10n.JET2Messages;
import org.eclipse.jet.internal.runtime.RuntimeLoggerContextExtender;
import org.eclipse.jet.taglib.JET2TagException;
import org.eclipse.jet.taglib.TagInfo;
import org.eclipse.jet.taglib.workspace.AbstractWorkspaceAction;
import org.eclipse.jet.taglib.workspace.ActionsUtil;
import org.eclipse.jet.taglib.workspace.IWorkspaceAction;


/**
 * Create or update a text file with the contents of a writer..
 *
 */
public class WsFileFromWriterAction extends AbstractWorkspaceAction implements IWorkspaceAction
{

  private final IFile file;

  private final JET2Writer writer;

  private String encoding;

  private final boolean replace;

  private final boolean derived;

  private final JET2Context context;

  /**
   * 
   * @param context
   * @param templatePath
   * @param tagInfo
   * @param file
   * @param writer
   * @param replace
   * @param derived
   */
  public WsFileFromWriterAction(
    JET2Context context,
    String templatePath,
    TagInfo tagInfo,
    IFile file,
    JET2Writer writer,
    boolean replace,
    boolean derived)
  {
    super(tagInfo, templatePath);
    this.context = context;
    this.file = file;
    this.writer = writer;
    this.replace = replace;
    this.derived = derived;
  }

  public IResource getResource()
  {
    return file;
  }

  public boolean requiresValidateEdit()
  {
    return replace && file.exists() && file.isReadOnly() /* && content has changed */;
  }

  public void performAction(IProgressMonitor monitor) throws JET2TagException
  {
    final String fileMessage = MessageFormat.format(
      JET2Messages.WsFileFromWriterAction_WritingFile,
      new Object []{ file.getFullPath().toString() });
    ActionsUtil.writeTextFileFromWriter(file, replace, encoding, derived, writer, monitor);
    RuntimeLoggerContextExtender.log(context, fileMessage, getTagInfo(), getTemplatePath(), RuntimeLoggerContextExtender.INFO_LEVEL);
  }

  public void setEncoding(String encoding)
  {
    this.encoding = encoding;
  }

}
