/*******************************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * $Id$
 * /
 *******************************************************************************/

package org.eclipse.jet.internal.taglib.workspace;


import java.text.MessageFormat;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jet.JET2Context;
import org.eclipse.jet.internal.l10n.JET2Messages;
import org.eclipse.jet.internal.runtime.RuntimeLoggerContextExtender;
import org.eclipse.jet.taglib.JET2TagException;
import org.eclipse.jet.taglib.TagInfo;
import org.eclipse.jet.taglib.workspace.AbstractWorkspaceAction;
import org.eclipse.jet.taglib.workspace.ActionsUtil;
import org.eclipse.jet.taglib.workspace.IWorkspaceAction;


/**
 * Represent a Folder action. A folder action will:
 * <bl>
 * <li>create a folder (and any uncreated parent folders), if it does not exist</li>
 * </bl>
 *
 */
public class WsFolderAction extends AbstractWorkspaceAction implements IWorkspaceAction
{

  private final IFolder folder;

  private final JET2Context context;

  /**
   * 
   * @param context
   * @param templatePath
   * @param tagInfo
   * @param folder
   */
  public WsFolderAction(JET2Context context, String templatePath, TagInfo tagInfo, IFolder folder)
  {
    super(tagInfo, templatePath);
    this.context = context;
    this.folder = folder;
  }

  public IResource getResource()
  {
    return folder;
  }

  public boolean requiresValidateEdit()
  {
    return false;
  }

  public void performAction(IProgressMonitor monitor) throws JET2TagException
  {
    ActionsUtil.ensureFolderExists(folder, monitor);
    RuntimeLoggerContextExtender.log(context, MessageFormat.format(
      JET2Messages.WsFolderAction_CreatingFolder,
      new Object []{ folder.getFullPath().toString() }), getTagInfo(), getTemplatePath(), RuntimeLoggerContextExtender.INFO_LEVEL);

  }

}
