/**
 * <copyright>
 *
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * $Id$
 */
package org.eclipse.jet.internal.xpath.functions;

import java.util.List;

import org.eclipse.jet.xpath.Context;
import org.eclipse.jet.xpath.XPathFunction;
import org.eclipse.jet.xpath.XPathFunctionMetaData;
import org.eclipse.jet.xpath.XPathFunctionWithContext;
import org.eclipse.jet.xpath.XPathUtil;

/**
 * Implement the XPath Function 'normalize-space'
 */
public class NormalizeSpaceFunction implements XPathFunction, XPathFunctionWithContext
{

  public static final XPathFunctionMetaData FUNCTION_META_DATA = new XPathFunctionMetaData("normalize-space", null, new NormalizeSpaceFunction(), 0, 1); //$NON-NLS-1$

  private Context context;

  /* (non-Javadoc)
   * @see org.eclipse.jet.xpath.XPathFunction#evaluate(java.util.List)
   */
  public Object evaluate(List args)
  {
    String arg;
    if(args.size() == 0)
    {
      arg = XPathUtil.xpathString(context.getContextNode());
    }
    else 
    {
      arg = XPathUtil.xpathString(args.get(0));
    }
    
    return normalizeSpace(arg);
  }

  /**
   * Normalize a string, accoring to the XPath normalize-space function.
   * @param arg the original string.
   * @return the normalized string
   */
  public static String normalizeSpace(String arg)
  {
    boolean stripNextSpace = true;
    StringBuffer result = new StringBuffer(arg);
    for(int i = 0; i < result.length(); i++)
    {
      if(Character.isWhitespace(result.charAt(i)))
      {
        if(stripNextSpace)
        {
          result.deleteCharAt(i);
          i--;
        }
        else
        {
          stripNextSpace = true;
        }
      }
      else
      {
        stripNextSpace = false;
      }
    }
    
    final int lastCharIndex = result.length() - 1;
    if(lastCharIndex >= 0 && Character.isWhitespace(result.charAt(lastCharIndex)))
    {
      result.deleteCharAt(lastCharIndex);
    }
    return result.toString();
  }

  public void setContext(Context context)
  {
    this.context  = context;
  }

}
