/**
 * <copyright>
 *
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * $Id$
 */
package org.eclipse.jet.xpath;

import org.eclipse.jet.internal.xpath.functions.BooleanFunction;
import org.eclipse.jet.internal.xpath.functions.NumberFunction;
import org.eclipse.jet.internal.xpath.functions.StringFunction;

/**
 * Utility class for common XPath operations.
 */
public class XPathUtil
{

  /**
   * Invoke the <a href="http://www.w3.org/TR/xpath#function-string">XPath 'string' function</a> on the argument.
   * @param object the argument to convert to a string. Cannot be <code>null</code>
   * @return the result of the XPath 'string' function.
   * @throws NullPointerException if <code>object</code> is <code>null</code>.
   */
  public static String xpathString(Object object)
  {
    if(object == null)
    {
      throw new NullPointerException();
    }
    return StringFunction.evaluate(object);
  }

  /**
   * Invoke the <a href="http://www.w3.org/TR/xpath#function-boolean">XPath 'boolean' function</a> on the argument.
   * @param object the argument to convert to a boolean. Cannot be <code>null</code>
   * @return the result of the XPath 'boolean' function.
   * @throws NullPointerException if <code>object</code> is <code>null</code>.
   */
  public static boolean xpathBoolean(Object object)
  {
    if(object == null)
    {
      throw new NullPointerException();
    }
    return BooleanFunction.evaluate(object);
  }
  
  /**
   * Invoke the <a href="http://www.w3.org/TR/xpath#function-number">XPath 'number' function</a> on the argument.
   * @param object the argument to convert to a number (double). Cannot be <code>null</code>
   * @return the result of the XPath 'number' function.
   * @throws NullPointerException if <code>object</code> is <code>null</code>.
   */
  public static double xpathNumber(Object object)
  {
    if(object == null)
    {
      throw new NullPointerException();
    }
    return NumberFunction.evaluate(object);
  }
}
