/*******************************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * $Id$
 * /
 *******************************************************************************/

package org.eclipse.jet.ui.newproject;

import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jet.JET2Platform;
import org.eclipse.jet.internal.InternalJET2Platform;
import org.eclipse.jet.internal.ui.l10n.Messages;
import org.eclipse.jet.ui.Activator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

/**
 * Implement New Project Wizard for JET2 transforms.
 *
 */
public class NewProjectWizard extends Wizard implements INewWizard {

	private static final String NEW_PROJECT_WIZARD_TX_ID = "org.eclipse.jet.transforms.newproject"; //$NON-NLS-1$
	private WizardNewProjectCreationPage projectPage;
	
	protected final NewProjectInfo newProjectInfo = new NewProjectInfo();

	/**
	 * 
	 */
	public NewProjectWizard() {
		super();
		setWindowTitle(Messages.NewProjectWizard_WindowTitle);
		setDefaultPageImageDescriptor(Activator.getImageDescriptor("/icons/JET2ProjectWizardBanner.gif")); //$NON-NLS-1$
		setNeedsProgressMonitor(true);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.wizard.Wizard#performFinish()
	 */
	public boolean performFinish() {
		try {
			getContainer().run(false, false, new IRunnableWithProgress() {

				public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
					IStatus result = JET2Platform.runTransformOnString(NEW_PROJECT_WIZARD_TX_ID, getBuildModel(), "xml", monitor); //$NON-NLS-1$
					if(!result.isOK()) {
						InternalJET2Platform.log(result);
						new ErrorDialog(getShell(), NewProjectWizard.this.getWindowTitle(),
								Messages.NewProjectWizard_ErrorInJETTransform,
								result, IStatus.ERROR | IStatus.WARNING).open();
					}
				}});
		} catch (InvocationTargetException e) {
			InternalJET2Platform.logError(Messages.NewProjectWizard_ErrorCreatingProject, e);
		} catch (InterruptedException e) {
			// cancelled, nothing to do
		}
		return true;
	}

	protected final String getBuildModel() {
		newProjectInfo.setProjectName(projectPage.getProjectName());
		if(!projectPage.useDefaults()) {
			newProjectInfo.setLocation(projectPage.getLocationPath().toString());
		}
		return newProjectInfo.toXmlString();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IWorkbenchWizard#init(org.eclipse.ui.IWorkbench, org.eclipse.jface.viewers.IStructuredSelection)
	 */
	public void init(IWorkbench workbench, IStructuredSelection selection) {
		// nothing to do here
	}

	public void addPages() {
		super.addPages();
		
		projectPage = new WizardNewProjectCreationPage(Messages.NewProjectWizard_MainPageTabText);
		projectPage.setTitle(Messages.NewProjectWizard_MainPageTitle);
		projectPage.setDescription(Messages.NewProjectWizard_MainPageDescription);
		addPage(projectPage);
		
	}
}
