package org.eclipse.jet.internal.compiler.templates;

import org.eclipse.jet.JET2Context;
import org.eclipse.jet.JET2Template;
import org.eclipse.jet.JET2Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jet.internal.compiler.LoaderGenerationParameters;

public class JET2TransformGenerator implements JET2Template {

    public JET2TransformGenerator() {
        super();
    }

    private static final String NL = System.getProperty("line.separator"); //$NON-NLS-1$

    public void generate(final JET2Context context, final JET2Writer __out) {
        JET2Writer out = __out;

LoaderGenerationParameters parms = (LoaderGenerationParameters)context.getVariable("args"); //$NON-NLS-1$
Map templateMap = (Map) parms.getTemplateMap();;
boolean useJava5 = context.hasVariable("useJava5") ? Boolean.valueOf((String)context.getVariable("useJava5")).booleanValue() : false;

        out.write("package ");  //$NON-NLS-1$        
        out.write( parms.getPackageName() );
        out.write(";");  //$NON-NLS-1$        
        out.write(NL);         
        out.write(NL);         
        out.write("import java.util.HashMap;");  //$NON-NLS-1$        
        out.write(NL);         
        out.write("import java.util.Map;");  //$NON-NLS-1$        
        out.write(NL);         
        out.write(NL);         
        out.write("import org.eclipse.jet.JET2TemplateLoader;");  //$NON-NLS-1$        
        out.write(NL);         
        out.write("import org.eclipse.jet.JET2TemplateLoaderExtension;");  //$NON-NLS-1$        
        out.write(NL);         
        out.write("import org.eclipse.jet.JET2Template;");  //$NON-NLS-1$        
        out.write(NL);         
        out.write(NL);         
        out.write("public class ");  //$NON-NLS-1$        
        out.write( parms.getClassName() );
        out.write(" implements JET2TemplateLoader, JET2TemplateLoaderExtension {");  //$NON-NLS-1$        
        out.write(NL);         
        out.write(NL);         
        out.write("    private static final class TemplateFactoryMethod {");  //$NON-NLS-1$        
        out.write(NL);         
        out.write(NL);         
        out.write("        private final String templatePath;");  //$NON-NLS-1$        
        out.write(NL);         
        out.write("        private final String templateClass;");  //$NON-NLS-1$        
        out.write(NL);         
        out.write(NL);         
        out.write("        public TemplateFactoryMethod(String templatePath, String templateClass) {");  //$NON-NLS-1$        
        out.write(NL);         
        out.write("            this.templatePath = templatePath;");  //$NON-NLS-1$        
        out.write(NL);         
        out.write("            this.templateClass = templateClass;");  //$NON-NLS-1$        
        out.write(NL);         
        out.write("            ");  //$NON-NLS-1$        
        out.write(NL);         
        out.write("        }");  //$NON-NLS-1$        
        out.write(NL);         
        out.write("        ");  //$NON-NLS-1$        
        out.write(NL);         
        out.write("        public String getTemplateClass() {");  //$NON-NLS-1$        
        out.write(NL);         
        out.write("            return this.templateClass;");  //$NON-NLS-1$        
        out.write(NL);         
        out.write("        }");  //$NON-NLS-1$        
        out.write(NL);         
        out.write(NL);         
        out.write("        public String getTemplatePath() {");  //$NON-NLS-1$        
        out.write(NL);         
        out.write("            return this.templatePath;");  //$NON-NLS-1$        
        out.write(NL);         
        out.write("        }");  //$NON-NLS-1$        
        out.write(NL);         
        out.write(NL);         
        out.write("        public JET2Template newTemplate() {");  //$NON-NLS-1$        
        out.write(NL);         
        out.write("            JET2Template template = null;");  //$NON-NLS-1$        
        out.write(NL);         
        out.write("            try {");  //$NON-NLS-1$        
        out.write(NL);         
        out.write("                template = (JET2Template) Class.forName(this.templateClass).newInstance();");  //$NON-NLS-1$        
        out.write(NL);         
        out.write("            } catch (InstantiationException e) {");  //$NON-NLS-1$        
        out.write(NL);         
        out.write("                // ignore");  //$NON-NLS-1$        
        out.write(NL);         
        out.write("            } catch (IllegalAccessException e) {");  //$NON-NLS-1$        
        out.write(NL);         
        out.write("                // ignore");  //$NON-NLS-1$        
        out.write(NL);         
        out.write("            } catch (ClassNotFoundException e) {");  //$NON-NLS-1$        
        out.write(NL);         
        out.write("                // ignore");  //$NON-NLS-1$        
        out.write(NL);         
        out.write("            }");  //$NON-NLS-1$        
        out.write(NL);         
        out.write("            return template;");  //$NON-NLS-1$        
        out.write(NL);         
        out.write("        }");  //$NON-NLS-1$        
        out.write(NL);         
        out.write("        ");  //$NON-NLS-1$        
        out.write(NL);         
        out.write("        ");  //$NON-NLS-1$        
        out.write(NL);         
        out.write("    }");  //$NON-NLS-1$        
        out.write(NL);         
        out.write(NL);         
 if(useJava5) { 
        out.write("    private Map<String,TemplateFactoryMethod> pathToFactoryMap = null;");  //$NON-NLS-1$        
        out.write(NL);         
 } else { 
        out.write("    private Map pathToFactoryMap = null;");  //$NON-NLS-1$        
        out.write(NL);         
 } 
        out.write("    ");  //$NON-NLS-1$        
        out.write(NL);         
        out.write("    private JET2TemplateLoader delegate = null;");  //$NON-NLS-1$        
        out.write(NL);         
        out.write(NL);         
        out.write("    public ");  //$NON-NLS-1$        
        out.write( parms.getClassName() );
        out.write("() {");  //$NON-NLS-1$        
        out.write(NL);         
        out.write("        super();");  //$NON-NLS-1$        
        out.write(NL);         
        out.write("    }");  //$NON-NLS-1$        
        out.write(NL);         
        out.write(NL);         
        out.write("    public JET2Template getTemplate(String templatePath) {");  //$NON-NLS-1$        
        out.write(NL);         
        out.write("        if(this.pathToFactoryMap == null) {");  //$NON-NLS-1$        
        out.write(NL);         
        out.write("            initPathToFactoryMap();");  //$NON-NLS-1$        
        out.write(NL);         
        out.write("        }");  //$NON-NLS-1$        
        out.write(NL);         
        out.write("        TemplateFactoryMethod factory = (TemplateFactoryMethod)this.pathToFactoryMap.get(templatePath);");  //$NON-NLS-1$        
        out.write(NL);         
        out.write("        return factory == null ? this.delegate == null ? null : this.delegate.getTemplate(templatePath) : factory.newTemplate();");  //$NON-NLS-1$        
        out.write(NL);         
        out.write("    }");  //$NON-NLS-1$        
        out.write(NL);         
        out.write(NL);         
        out.write("    private void addTemplate(String templatePath, String templateClass) {");  //$NON-NLS-1$        
        out.write(NL);         
        out.write("        this.pathToFactoryMap.put(templatePath,");  //$NON-NLS-1$        
        out.write(NL);         
        out.write("            new TemplateFactoryMethod(templatePath, templateClass));");  //$NON-NLS-1$        
        out.write(NL);         
        out.write("    }");  //$NON-NLS-1$        
        out.write(NL);         
        out.write("    ");  //$NON-NLS-1$        
        out.write(NL);         
        out.write("    private void initPathToFactoryMap() {");  //$NON-NLS-1$        
        out.write(NL);         
if(useJava5) { 
        out.write("        this.pathToFactoryMap = new HashMap<String,TemplateFactoryMethod>(");  //$NON-NLS-1$        
        out.write( templateMap.size() );
        out.write(");");  //$NON-NLS-1$        
        out.write(NL);         
 } else { 
        out.write("        this.pathToFactoryMap = new HashMap(");  //$NON-NLS-1$        
        out.write( templateMap.size() );
        out.write(");");  //$NON-NLS-1$        
        out.write(NL);         
 } 
 
    List templatePaths = new ArrayList(templateMap.keySet());
    Collections.sort(templatePaths);
    for(Iterator i = templatePaths.iterator(); i.hasNext();){ 
        String key = (String)i.next();
        String value = (String)templateMap.get(key);

        out.write("            addTemplate(\"");  //$NON-NLS-1$        
        out.write( key );
        out.write("\", \"");  //$NON-NLS-1$        
        out.write( value );
        out.write("\" ); //$NON-NLS-1$  //$NON-NLS-2$");  //$NON-NLS-1$        
        out.write(NL);         
 } 
        out.write("    }");  //$NON-NLS-1$        
        out.write(NL);         
        out.write(NL);         
        out.write("    public void setDelegateLoader(JET2TemplateLoader loader) {");  //$NON-NLS-1$        
        out.write(NL);         
        out.write("        this.delegate = loader;");  //$NON-NLS-1$        
        out.write(NL);         
        out.write("    }");  //$NON-NLS-1$        
        out.write(NL);         
        out.write("    ");  //$NON-NLS-1$        
        out.write(NL);         
        out.write("    public JET2TemplateLoader getDelegateLoader() {");  //$NON-NLS-1$        
        out.write(NL);         
        out.write("        return this.delegate;");  //$NON-NLS-1$        
        out.write(NL);         
        out.write("    }");  //$NON-NLS-1$        
        out.write(NL);         
        out.write("}");  //$NON-NLS-1$        
        out.write(NL);         
        out.write(NL);         
    }
}
