/**
 * <copyright>
 *
 * Copyright (c) 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * $Id: DocumentHelper.java,v 1.1 2007/04/30 17:33:08 pelder Exp $
 */
package org.eclipse.jet.internal.taglib;

import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.IDocument;

/**
 * Helper class for handling IDocument instances
 */
public class DocumentHelper
{
  
  private DocumentHelper() {
    // prevent instantiation.
  }
  
  /**
   * Install the position category if it is not already installed.
   * @param document the document into which the category should be installed
   * @param category the category.
   */
  public static void installPositionCategory(IDocument document, String category)
  {
    if(!document.containsPositionCategory(category)) {
      document.addPositionCategory(category);
      document.addPositionUpdater(new DefaultPositionUpdater(category));
    }
  }

}
