/**
 *
 * Copyright (c) 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 *   IBM - Initial API and implementation
 *
 */
package org.eclipse.jet.internal.taglib.control;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.jet.taglib.CustomTag;
import org.eclipse.jet.taglib.JET2TagException;
import org.eclipse.jet.taglib.TagInstanceFactory;

/**
 * Tag Factory for controlTags
 */
public class TagFactory implements TagInstanceFactory
{

  private final Map tagOrdinalByName;
  
  /**
   * 
   */
  public TagFactory()
  {
    tagOrdinalByName = new HashMap(27);

    tagOrdinalByName.put("addElement",new Integer(1)); //$NON-NLS-1$
    tagOrdinalByName.put("addTextElement",new Integer(2)); //$NON-NLS-1$
    tagOrdinalByName.put("case",new Integer(3)); //$NON-NLS-1$
    tagOrdinalByName.put("choose",new Integer(4)); //$NON-NLS-1$
    tagOrdinalByName.put("copyElement",new Integer(5)); //$NON-NLS-1$
    tagOrdinalByName.put("dump",new Integer(6)); //$NON-NLS-1$
    tagOrdinalByName.put("get",new Integer(7)); //$NON-NLS-1$
    tagOrdinalByName.put("if",new Integer(8)); //$NON-NLS-1$
    tagOrdinalByName.put("include",new Integer(9)); //$NON-NLS-1$
    tagOrdinalByName.put("initialCode",new Integer(10)); //$NON-NLS-1$
    tagOrdinalByName.put("invokeTransform",new Integer(11)); //$NON-NLS-1$
    tagOrdinalByName.put("iterate",new Integer(12)); //$NON-NLS-1$
    tagOrdinalByName.put("load",new Integer(13)); //$NON-NLS-1$
    tagOrdinalByName.put("loadContent",new Integer(14)); //$NON-NLS-1$
    tagOrdinalByName.put("log",new Integer(15)); //$NON-NLS-1$
    tagOrdinalByName.put("marker",new Integer(16)); //$NON-NLS-1$
    tagOrdinalByName.put("otherwise",new Integer(17)); //$NON-NLS-1$
    tagOrdinalByName.put("override",new Integer(18)); //$NON-NLS-1$
    tagOrdinalByName.put("removeElement",new Integer(19)); //$NON-NLS-1$
    tagOrdinalByName.put("replaceStrings",new Integer(20)); //$NON-NLS-1$
    tagOrdinalByName.put("set",new Integer(21)); //$NON-NLS-1$
    tagOrdinalByName.put("setVariable",new Integer(22)); //$NON-NLS-1$
    tagOrdinalByName.put("stringTokens",new Integer(23)); //$NON-NLS-1$
    tagOrdinalByName.put("userRegion",new Integer(24)); //$NON-NLS-1$
    tagOrdinalByName.put("visit",new Integer(25)); //$NON-NLS-1$
    tagOrdinalByName.put("visitor",new Integer(26)); //$NON-NLS-1$
    tagOrdinalByName.put("when",new Integer(27)); //$NON-NLS-1$
  }

  public CustomTag createCustomTag(String name)
  {
    Integer ordinal = (Integer)tagOrdinalByName.get(name);
    
    switch(ordinal == null ? 0 : ordinal.intValue()) {
      case 1: // addElement
        return new org.eclipse.jet.internal.taglib.control.AddElementTag();
      case 2: // addTextElement
        return new org.eclipse.jet.internal.taglib.control.AddTextElementTag();
      case 3: // case
        return new org.eclipse.jet.internal.taglib.control.WhenTag();
      case 4: // choose
        return new org.eclipse.jet.internal.taglib.control.ChooseTag();
      case 5: // copyElement
        return new org.eclipse.jet.internal.taglib.control.CopyElementTag();
      case 6: // dump
        return new org.eclipse.jet.internal.taglib.control.DumpTag();
      case 7: // get
        return new org.eclipse.jet.internal.taglib.control.GetTag();
      case 8: // if
        return new org.eclipse.jet.internal.taglib.control.IfTag();
      case 9: // include
        return new org.eclipse.jet.internal.taglib.control.IncludeTag();
      case 10: // initialCode
        return new org.eclipse.jet.internal.taglib.control.InitialCodeTag();
      case 11: // invokeTransform
        return new org.eclipse.jet.internal.taglib.control.InvokeTransformTag();
      case 12: // iterate
        return new org.eclipse.jet.internal.taglib.control.IterateTag();
      case 13: // load
        return new org.eclipse.jet.internal.taglib.control.LoadTag();
      case 14: // loadContent
        return new org.eclipse.jet.internal.taglib.control.LoadContentTag();
      case 15: // log
        return new org.eclipse.jet.internal.taglib.control.LogTag();
      case 16: // marker
        return new org.eclipse.jet.internal.taglib.control.MarkerTag();
      case 17: // otherwise
        return new org.eclipse.jet.internal.taglib.control.OtherwiseTag();
      case 18: // override
        return new org.eclipse.jet.internal.taglib.control.OverrideTag();
      case 19: // removeElement
        return new org.eclipse.jet.internal.taglib.control.RemoveElementTag();
      case 20: // replaceStrings
        return new org.eclipse.jet.internal.taglib.control.ReplaceStringsTag();
      case 21: // set
        return new org.eclipse.jet.internal.taglib.control.SetTag();
      case 22: // setVariable
        return new org.eclipse.jet.internal.taglib.control.SetVariableTag();
      case 23: // stringTokens
        return new org.eclipse.jet.internal.taglib.control.StringTokensTag();
      case 24: // userRegion
        return new org.eclipse.jet.internal.taglib.control.UserRegionTag();
      case 25: // visit
        return new org.eclipse.jet.internal.taglib.control.VisitTag();
      case 26: // visitor
        return new org.eclipse.jet.internal.taglib.control.VisitorTag();
      case 27: // when
        return new org.eclipse.jet.internal.taglib.control.WhenTag();
      default:
        throw new JET2TagException("Unknown Tag: " + name); //$NON-NLS-1$
    }
  }

}
