/**
 *
 * Copyright (c) 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 *   IBM - Initial API and implementation
 *
 */
package org.eclipse.jet.internal.taglib.workspace;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.jet.taglib.CustomTag;
import org.eclipse.jet.taglib.JET2TagException;
import org.eclipse.jet.taglib.TagInstanceFactory;

/**
 * Tag Factory for workspaceTags
 */
public class TagFactory implements TagInstanceFactory
{

  private final Map tagOrdinalByName;
  
  /**
   * 
   */
  public TagFactory()
  {
    tagOrdinalByName = new HashMap(5);

    tagOrdinalByName.put("copyFile",new Integer(1)); //$NON-NLS-1$
    tagOrdinalByName.put("file",new Integer(2)); //$NON-NLS-1$
    tagOrdinalByName.put("folder",new Integer(3)); //$NON-NLS-1$
    tagOrdinalByName.put("project",new Integer(4)); //$NON-NLS-1$
    tagOrdinalByName.put("rebuildWorkspace",new Integer(5)); //$NON-NLS-1$
  }

  public CustomTag createCustomTag(String name)
  {
    Integer ordinal = (Integer)tagOrdinalByName.get(name);
    
    switch(ordinal == null ? 0 : ordinal.intValue()) {
      case 1: // copyFile
        return new org.eclipse.jet.internal.taglib.workspace.CopyFileTag();
      case 2: // file
        return new org.eclipse.jet.internal.taglib.workspace.FileTag();
      case 3: // folder
        return new org.eclipse.jet.internal.taglib.workspace.FolderTag();
      case 4: // project
        return new org.eclipse.jet.internal.taglib.workspace.ProjectTag();
      case 5: // rebuildWorkspace
        return new org.eclipse.jet.internal.taglib.workspace.RebuildWorkspaceTag();
      default:
        throw new JET2TagException("Unknown Tag: " + name); //$NON-NLS-1$
    }
  }

}
