/**
 *
 * Copyright (c) 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 *   IBM - Initial API and implementation
 *
 */
package org.eclipse.jet.internal.taglib.format;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.jet.taglib.CustomTag;
import org.eclipse.jet.taglib.JET2TagException;
import org.eclipse.jet.taglib.TagInstanceFactory;

/**
 * Tag Factory for formatTags
 */
public class TagFactory implements TagInstanceFactory
{

  private final Map tagOrdinalByName;
  
  /**
   * 
   */
  public TagFactory()
  {
    tagOrdinalByName = new HashMap(10);

    tagOrdinalByName.put("formatNow",new Integer(1)); //$NON-NLS-1$
    tagOrdinalByName.put("indent",new Integer(2)); //$NON-NLS-1$
    tagOrdinalByName.put("lc",new Integer(3)); //$NON-NLS-1$
    tagOrdinalByName.put("milliseconds",new Integer(4)); //$NON-NLS-1$
    tagOrdinalByName.put("replaceAll",new Integer(5)); //$NON-NLS-1$
    tagOrdinalByName.put("strip",new Integer(6)); //$NON-NLS-1$
    tagOrdinalByName.put("uc",new Integer(7)); //$NON-NLS-1$
    tagOrdinalByName.put("unique",new Integer(8)); //$NON-NLS-1$
    tagOrdinalByName.put("uuid",new Integer(9)); //$NON-NLS-1$
    tagOrdinalByName.put("xpath",new Integer(10)); //$NON-NLS-1$
  }

  public CustomTag createCustomTag(String name)
  {
    Integer ordinal = (Integer)tagOrdinalByName.get(name);
    
    switch(ordinal == null ? 0 : ordinal.intValue()) {
      case 1: // formatNow
        return new org.eclipse.jet.internal.taglib.format.FormatNowTag();
      case 2: // indent
        return new org.eclipse.jet.internal.taglib.format.IndentTag();
      case 3: // lc
        return new org.eclipse.jet.internal.taglib.format.LowerCaseTag();
      case 4: // milliseconds
        return new org.eclipse.jet.internal.taglib.format.MillisecondsTag();
      case 5: // replaceAll
        return new org.eclipse.jet.internal.taglib.format.ReplaceAllTag();
      case 6: // strip
        return new org.eclipse.jet.internal.taglib.format.StripTag();
      case 7: // uc
        return new org.eclipse.jet.internal.taglib.format.UpperCaseTag();
      case 8: // unique
        return new org.eclipse.jet.internal.taglib.format.UniqueTag();
      case 9: // uuid
        return new org.eclipse.jet.internal.taglib.format.UuidTag();
      case 10: // xpath
        return new org.eclipse.jet.internal.taglib.format.XPathTag();
      default:
        throw new JET2TagException("Unknown Tag: " + name); //$NON-NLS-1$
    }
  }

}
