package org.eclipse.jet.internal.compiler.templates;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.jet.JET2TemplateLoader;
import org.eclipse.jet.JET2TemplateLoaderExtension;
import org.eclipse.jet.JET2Template;

public class CodeGenTemplateLoader implements JET2TemplateLoader, JET2TemplateLoaderExtension {

    private static final class TemplateFactoryMethod {

        private final String templatePath;
        private final String templateClass;

        public TemplateFactoryMethod(String templatePath, String templateClass) {
            this.templatePath = templatePath;
            this.templateClass = templateClass;
            
        }
        
        public String getTemplateClass() {
            return this.templateClass;
        }

        public String getTemplatePath() {
            return this.templatePath;
        }

        public JET2Template newTemplate() {
            JET2Template template = null;
            try {
                template = (JET2Template) Class.forName(this.templateClass).newInstance();
            } catch (InstantiationException e) {
                // ignore
            } catch (IllegalAccessException e) {
                // ignore
            } catch (ClassNotFoundException e) {
                // ignore
            }
            return template;
        }
        
        
    }

    private Map pathToFactoryMap = null;
    
    private JET2TemplateLoader delegate = null;

    public CodeGenTemplateLoader() {
        super();
    }

    public JET2Template getTemplate(String templatePath) {
        if(this.pathToFactoryMap == null) {
            initPathToFactoryMap();
        }
        TemplateFactoryMethod factory = (TemplateFactoryMethod)this.pathToFactoryMap.get(templatePath);
        return factory == null ? this.delegate == null ? null : this.delegate.getTemplate(templatePath) : factory.newTemplate();
    }

    private void addTemplate(String templatePath, String templateClass) {
        this.pathToFactoryMap.put(templatePath,
            new TemplateFactoryMethod(templatePath, templateClass));
    }
    
    private void initPathToFactoryMap() {
        this.pathToFactoryMap = new HashMap(11);
            addTemplate("templates/jet2java.jet", "org.eclipse.jet.internal.compiler.templates.JET2JavaGenerator" ); //$NON-NLS-1$  //$NON-NLS-2$
            addTemplate("templates/jet2transform.jet", "org.eclipse.jet.internal.compiler.templates.JET2TransformGenerator" ); //$NON-NLS-1$  //$NON-NLS-2$
            addTemplate("templates/jetTemplateMap.properties.jet", "org.eclipse.jet.internal.compiler.templates.JETTemplateMapGenerator" ); //$NON-NLS-1$  //$NON-NLS-2$
            addTemplate("templates/main.jet", "org.eclipse.jet.internal.compiler.templates.DummyMain" ); //$NON-NLS-1$  //$NON-NLS-2$
            addTemplate("templates/tagDataDeclarations.jet", "org.eclipse.jet.internal.compiler.templates.TagDataDeclGenerator" ); //$NON-NLS-1$  //$NON-NLS-2$
            addTemplate("templates/v1/jet2java.jet", "org.eclipse.jet.internal.compiler.templates.v1.JET1JavaGenerator" ); //$NON-NLS-1$  //$NON-NLS-2$
            addTemplate("templates/v2/jet2java.jet", "org.eclipse.jet.internal.compiler.templates.v2.JET2JavaGeneratorNew" ); //$NON-NLS-1$  //$NON-NLS-2$
            addTemplate("templates/writeJavaExpression.jet", "org.eclipse.jet.internal.compiler.templates.WriteJavaExpressionTemplate" ); //$NON-NLS-1$  //$NON-NLS-2$
            addTemplate("templates/writeTextElement.jet", "org.eclipse.jet.internal.compiler.templates.WriteTextElementTemplate" ); //$NON-NLS-1$  //$NON-NLS-2$
            addTemplate("templates/xmlEnd.jet", "org.eclipse.jet.internal.compiler.templates.XMLEndGenerator" ); //$NON-NLS-1$  //$NON-NLS-2$
            addTemplate("templates/xmlStart.jet", "org.eclipse.jet.internal.compiler.templates.XMLStartGenerator" ); //$NON-NLS-1$  //$NON-NLS-2$
    }

    public void setDelegateLoader(JET2TemplateLoader loader) {
        this.delegate = loader;
    }
    
    public JET2TemplateLoader getDelegateLoader() {
        return this.delegate;
    }
}

