/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.compiler.templates;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jet.JET2Context;
import org.eclipse.jet.JET2Template;
import org.eclipse.jet.JET2Writer;
import org.eclipse.jet.internal.JavaUtil;
import org.eclipse.jet.internal.compiler.LoaderGenerationParameters;

public class JET2TransformGenerator
implements JET2Template {
    private static final String NL = System.getProperty("line.separator");

    public void generate(JET2Context context, JET2Writer __out) {
        JET2Writer out = __out;
        LoaderGenerationParameters parms = (LoaderGenerationParameters)context.getVariable("args");
        TreeMap templateMap = new TreeMap(parms.getTemplateMap());
        boolean useJava5 = context.hasVariable("useJava5") ? Boolean.valueOf((String)context.getVariable("useJava5")) : false;
        out.write("package ");
        out.write(parms.getPackageName());
        out.write(";");
        out.write(NL);
        out.write(NL);
        out.write("import java.util.HashMap;");
        out.write(NL);
        out.write("import java.util.Map;");
        out.write(NL);
        out.write(NL);
        out.write("import org.eclipse.jet.JET2Template;");
        out.write(NL);
        out.write("import org.eclipse.jet.JET2TemplateLoader;");
        out.write(NL);
        out.write("import org.eclipse.jet.JET2TemplateLoaderExtension;");
        out.write(NL);
        out.write(NL);
        out.write("public class ");
        out.write(parms.getClassName());
        out.write(" implements JET2TemplateLoader,");
        out.write(NL);
        out.write("        JET2TemplateLoaderExtension {");
        out.write(NL);
        out.write(NL);
        out.write("    private JET2TemplateLoader delegate = null;");
        out.write(NL);
        out.write(NL);
        if (useJava5) {
            out.write("    private static Map<String, Integer> pathToTemplateOrdinalMap = null;");
            out.write(NL);
        } else {
            out.write("    private static Map pathToTemplateOrdinalMap = null;");
            out.write(NL);
        }
        out.write(NL);
        out.write("    /*");
        out.write(NL);
        out.write("     * (non-Javadoc)");
        out.write(NL);
        out.write("     * ");
        out.write(NL);
        out.write("     * @see org.eclipse.jet.JET2TemplateLoaderExtension#getDelegateLoader()");
        out.write(NL);
        out.write("     */");
        out.write(NL);
        out.write("    public JET2TemplateLoader getDelegateLoader() {");
        out.write(NL);
        out.write("        return delegate;");
        out.write(NL);
        out.write("    }");
        out.write(NL);
        out.write(NL);
        out.write("    /*");
        out.write(NL);
        out.write("     * (non-Javadoc)");
        out.write(NL);
        out.write("     * ");
        out.write(NL);
        out.write("     * @see org.eclipse.jet.JET2TemplateLoader#getTemplate(java.lang.String)");
        out.write(NL);
        out.write("     */");
        out.write(NL);
        out.write("    public JET2Template getTemplate(final String templatePath) {");
        out.write(NL);
        out.write("        if (pathToTemplateOrdinalMap == null) {");
        out.write(NL);
        out.write("            initPathToFactoryMap();");
        out.write(NL);
        out.write("        }");
        out.write(NL);
        if (useJava5) {
            out.write("        final Integer ordinal = pathToTemplateOrdinalMap.get(templatePath);");
            out.write(NL);
        } else {
            out.write("        final Integer ordinal = (Integer)pathToTemplateOrdinalMap.get(templatePath);");
            out.write(NL);
        }
        out.write("        switch (ordinal != null ? ordinal.intValue() : -1) {");
        out.write(NL);
        int ordinal = 0;
        Iterator i = templateMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            out.write("        case ");
            out.write(ordinal);
            out.write(": // ");
            out.write(entry.getKey());
            out.write(NL);
            out.write("            return new ");
            out.write(entry.getValue());
            out.write("();");
            out.write(NL);
            ++ordinal;
        }
        out.write("        default:");
        out.write(NL);
        out.write("            return delegate != null ? delegate.getTemplate(templatePath) : null;");
        out.write(NL);
        out.write("        }");
        out.write(NL);
        out.write("    }");
        out.write(NL);
        out.write(NL);
        out.write("    private static synchronized void initPathToFactoryMap() {");
        out.write(NL);
        out.write("        if (pathToTemplateOrdinalMap == null) {");
        out.write(NL);
        if (useJava5) {
            out.write("            pathToTemplateOrdinalMap = new HashMap<String,Integer>(");
            out.write(templateMap.size());
            out.write(");");
            out.write(NL);
        } else {
            out.write("            pathToTemplateOrdinalMap = new HashMap(");
            out.write(templateMap.size());
            out.write(");");
            out.write(NL);
        }
        ordinal = 0;
        i = templateMap.keySet().iterator();
        while (i.hasNext()) {
            String templatePath = (String)((Object)i.next());
            out.write("            pathToTemplateOrdinalMap.put(");
            out.write(JavaUtil.asJavaQuotedString(templatePath));
            out.write(",");
            out.write(NL);
            out.write("                    new Integer(");
            out.write(ordinal);
            out.write("));");
            out.write(NL);
            ++ordinal;
        }
        out.write("        }");
        out.write(NL);
        out.write("    }");
        out.write(NL);
        out.write(NL);
        out.write("    /*");
        out.write(NL);
        out.write("     * (non-Javadoc)");
        out.write(NL);
        out.write("     * ");
        out.write(NL);
        out.write("     * @see");
        out.write(NL);
        out.write("     * org.eclipse.jet.JET2TemplateLoaderExtension#setDelegateLoader(org.eclipse");
        out.write(NL);
        out.write("     * .jet.JET2TemplateLoader)");
        out.write(NL);
        out.write("     */");
        out.write(NL);
        out.write("    public void setDelegateLoader(final JET2TemplateLoader loader) {");
        out.write(NL);
        out.write("        this.delegate = loader;");
        out.write(NL);
        out.write("    }");
        out.write(NL);
        out.write("}");
        out.write(NL);
    }
}

