/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.taglib.control;

import java.text.MessageFormat;
import org.eclipse.jet.JET2Context;
import org.eclipse.jet.JET2Writer;
import org.eclipse.jet.XPathContextExtender;
import org.eclipse.jet.internal.l10n.JET2Messages;
import org.eclipse.jet.taglib.AbstractIteratingTag;
import org.eclipse.jet.taglib.JET2TagException;
import org.eclipse.jet.taglib.TagInfo;
import org.eclipse.jet.xpath.NodeSet;
import org.eclipse.jet.xpath.XPathUtil;

public class IterateTag
extends AbstractIteratingTag {
    private static final String UPDATE_CONTEXT_VAR = "org.eclipse.jet.taglib.control.iterateSetsContext";
    private Boolean updateContext;
    private Object[] selectedObjects;
    private int currentIndex;
    private String varName;
    private Object savedVarValue = null;
    private boolean nodeSetIteration;
    private long maxIterations = 0L;

    public boolean doEvalLoopCondition(TagInfo tc, JET2Context context) throws JET2TagException {
        boolean doAnotherIteration;
        boolean bl = doAnotherIteration = (long)(++this.currentIndex) < this.maxIterations;
        if (!doAnotherIteration && this.varName != null) {
            if (this.savedVarValue != null) {
                context.setVariable(this.varName, this.savedVarValue);
            } else {
                context.removeVariable(this.varName);
            }
        }
        return doAnotherIteration;
    }

    public void doBeforeBody(TagInfo td, JET2Context context, JET2Writer out) throws JET2TagException {
        super.doBeforeBody(td, context, out);
        if (this.nodeSetIteration) {
            Object currentObject = this.selectedObjects[this.currentIndex];
            if (this.varName != null) {
                context.setVariable(this.varName, currentObject);
            }
            if (this.updateContext(context)) {
                XPathContextExtender.getInstance(context).pushXPathContextObject(currentObject);
            }
        } else if (this.varName != null) {
            context.setVariable(this.varName, (Object)new Long(this.currentIndex + 1));
        }
    }

    public void doAfterBody(TagInfo td, JET2Context context, JET2Writer out) throws JET2TagException {
        if (this.updateContext(context)) {
            XPathContextExtender.getInstance(context).popXPathContextObject();
        }
    }

    public void doInitializeLoop(TagInfo td, JET2Context context) throws JET2TagException {
        Object resultObject;
        String selectXPath = this.getAttribute("select");
        this.varName = this.getAttribute("var");
        this.setDelimiter(this.getAttribute("delimiter"));
        XPathContextExtender xpathContext = XPathContextExtender.getInstance(context);
        if (this.updateContext(context)) {
            context.getSource();
        }
        if (this.varName != null && context.hasVariable(this.varName)) {
            this.savedVarValue = context.getVariable(this.varName);
        }
        if ((resultObject = xpathContext.resolveAsObject(xpathContext.currentXPathContextObject(), selectXPath)) instanceof Number) {
            this.nodeSetIteration = false;
            this.maxIterations = ((Number)resultObject).longValue();
        } else if (resultObject instanceof NodeSet) {
            this.nodeSetIteration = true;
            this.selectedObjects = ((NodeSet)resultObject).toArray();
            this.maxIterations = this.selectedObjects.length;
        } else {
            throw new JET2TagException(MessageFormat.format(JET2Messages.IterateTag_CannotIterateOnResult, selectXPath));
        }
        this.currentIndex = -1;
    }

    private boolean updateContext(JET2Context context) {
        if (this.updateContext == null) {
            this.updateContext = !context.hasVariable(UPDATE_CONTEXT_VAR) ? Boolean.FALSE : Boolean.valueOf(XPathUtil.xpathBoolean(context.getVariable(UPDATE_CONTEXT_VAR)));
        }
        return this.updateContext;
    }
}

