/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.compiler;

import java.util.Map;
import java.util.regex.Matcher;
import org.eclipse.jet.BufferedJET2Writer;
import org.eclipse.jet.IWriterListener;
import org.eclipse.jet.JET2Context;
import org.eclipse.jet.JET2Writer;
import org.eclipse.jet.core.parser.ast.JETASTVisitor;
import org.eclipse.jet.core.parser.ast.JavaElement;
import org.eclipse.jet.internal.core.NewLineUtil;
import org.eclipse.jet.internal.taglib.DocumentHelper;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;

public class SafeJETASTVisitor
extends JETASTVisitor {
    protected final JET2Context context;
    protected final JET2Writer out;
    private String indent;
    private final String stdIndent;
    private final Map positionMap;
    static /* synthetic */ Class class$0;

    public SafeJETASTVisitor(JET2Context context, JET2Writer out) {
        this(context, out, "    ");
    }

    public SafeJETASTVisitor(JET2Context context, JET2Writer out, String stdIndent) {
        this.context = context;
        this.out = new IndentingWriter(out);
        this.stdIndent = stdIndent;
        this.indent = "";
        this.positionMap = (Map)(context.hasVariable("positionMap") ? context.getVariable("positionMap") : null);
    }

    public SafeJETASTVisitor in() {
        this.indent = String.valueOf(this.indent) + this.stdIndent;
        return this;
    }

    public SafeJETASTVisitor out() {
        this.indent = this.indent.substring(0, this.indent.length() - this.stdIndent.length());
        return this;
    }

    public String ident() {
        return this.indent;
    }

    protected void writeAndRecord(JavaElement element) {
        String javaContent = element.getJavaContent();
        this.out.write(javaContent);
        if (this.positionMap != null) {
            int len = javaContent.length();
            Position position = new Position(((BufferedJET2Writer)this.out).getContentLength() - len, len);
            this.positionMap.put(element, position);
            BufferedJET2Writer bufferedJET2Writer = (BufferedJET2Writer)this.out;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jface.text.IDocument");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            IDocument document = (IDocument)bufferedJET2Writer.getAdapter((Class)clazz);
            DocumentHelper.installPositionCategory(document, ((Object)((Object)this)).getClass().getName());
        }
    }

    private final class IndentingWriter
    implements JET2Writer,
    BufferedJET2Writer {
        private final JET2Writer delegate;
        private boolean atLineStart;

        public IndentingWriter(JET2Writer delegate) {
            this.delegate = delegate;
            this.atLineStart = true;
        }

        public void addEventListener(String category, IWriterListener listener) {
            this.delegate.addEventListener(category, listener);
        }

        public void addPosition(String category, Position position) {
            IDocument document = this.getDocument();
            if (document != null) {
                try {
                    document.addPosition(category, position);
                }
                catch (BadLocationException e) {
                    throw new RuntimeException(e);
                }
                catch (BadPositionCategoryException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        public void addPositionCategory(String category) {
            IDocument document = this.getDocument();
            DocumentHelper.installPositionCategory(document, category);
        }

        public IDocument getDocument() {
            IDocument iDocument;
            if (this.delegate instanceof BufferedJET2Writer) {
                BufferedJET2Writer bufferedJET2Writer = (BufferedJET2Writer)this.delegate;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.jface.text.IDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                iDocument = (IDocument)bufferedJET2Writer.getAdapter((Class)clazz);
            } else {
                iDocument = null;
            }
            return iDocument;
        }

        public int getLength() {
            return this.getContentLength();
        }

        public JET2Writer getParentWriter() {
            return this.delegate.getParentWriter();
        }

        public Position[] getPositions(String category) {
            IDocument document = this.getDocument();
            if (document != null) {
                try {
                    return document.getPositions(category);
                }
                catch (BadPositionCategoryException e) {
                    throw new RuntimeException(e);
                }
            }
            return new Position[0];
        }

        public JET2Writer newNestedContentWriter() {
            return this.delegate.newNestedContentWriter();
        }

        public void replace(int offset, int length, String text) {
            this.replaceContent(offset, length, text);
        }

        public void write(boolean b) {
            this.write((Object)b);
        }

        public void write(char c) {
            this.write(Character.toString(c));
        }

        public void write(char[] data) {
            this.write(data == null ? "" : new String(data));
        }

        public void write(double d) {
            this.write(Double.toString(d));
        }

        public void write(float f) {
            this.write(Float.toString(f));
        }

        public void write(int i) {
            this.write(Integer.toString(i));
        }

        public void write(JET2Writer bodyContent) {
            throw new UnsupportedOperationException();
        }

        public void write(long l) {
            this.write(Long.toString(l));
        }

        public void write(Object obj) {
            this.write(String.valueOf(obj));
        }

        public void write(String string) {
            if (string == null) {
                string = "";
            }
            if (this.atLineStart && string.length() > 0) {
                this.delegate.write(SafeJETASTVisitor.this.indent);
                this.atLineStart = false;
            }
            int nextToWrite = 0;
            Matcher nlMatcher = NewLineUtil.NEW_LINE_PATTERN.matcher(string);
            while (nlMatcher.find()) {
                this.writeLineText(string, nextToWrite, nlMatcher.start());
                this.delegate.write(string.substring(nlMatcher.start(), nlMatcher.end()));
                nextToWrite = nlMatcher.end();
                this.atLineStart = true;
            }
            this.writeLineText(string, nextToWrite, string.length());
            this.atLineStart = nextToWrite > 0 && nextToWrite == string.length();
        }

        private void writeLineText(String string, int start, int end) {
            if (start < end) {
                if (this.atLineStart) {
                    this.delegate.write(SafeJETASTVisitor.this.indent);
                }
                this.delegate.write(string.substring(start, end));
            }
        }

        public IWriterListener[] getEventListeners() {
            return this.delegate.getEventListeners();
        }

        public Object getAdapter(Class adapterClass) {
            if (this.delegate instanceof BufferedJET2Writer) {
                return ((BufferedJET2Writer)this.delegate).getAdapter(adapterClass);
            }
            throw new IllegalStateException();
        }

        public String getContent() {
            if (this.delegate instanceof BufferedJET2Writer) {
                return ((BufferedJET2Writer)this.delegate).getContent();
            }
            throw new IllegalStateException();
        }

        public String getContent(int offset, int length) {
            if (this.delegate instanceof BufferedJET2Writer) {
                return ((BufferedJET2Writer)this.delegate).getContent(offset, length);
            }
            throw new IllegalStateException();
        }

        public int getContentLength() {
            if (this.delegate instanceof BufferedJET2Writer) {
                return ((BufferedJET2Writer)this.delegate).getContentLength();
            }
            throw new IllegalStateException();
        }

        public void replaceContent(int offset, int length, String text) {
            if (!(this.delegate instanceof BufferedJET2Writer)) {
                throw new IllegalStateException();
            }
            ((BufferedJET2Writer)this.delegate).replaceContent(offset, length, text);
        }

        public void setContent(String content) {
            if (!(this.delegate instanceof BufferedJET2Writer)) {
                throw new IllegalStateException();
            }
            ((BufferedJET2Writer)this.delegate).setContent(content);
        }
    }
}

