/**
 * Copyright (c) 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 *   IBM - Initial API and implementation
 *
 */

package org.eclipse.jet.internal.uml2.functions;

import java.util.Collection;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jet.xpath.Context;
import org.eclipse.jet.xpath.XPathFunction;
import org.eclipse.jet.xpath.XPathFunctionWithContext;
import org.eclipse.jet.xpath.XPathUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;

/**
 * Implement the XPath function uml2.stereotype([element, ] qualified-name).
 *
 */
public class StereotypeFunction implements XPathFunction,
		XPathFunctionWithContext {

	private Context context;

	/* (non-Javadoc)
	 * @see org.eclipse.jet.xpath.XPathFunction#evaluate(java.util.List)
	 */
	public Object evaluate(List args) {
		Object target = args.size() == 1 ? context.getContextNode() : getFirstObject(args.get(0));
		String qualifiedName = XPathUtil.xpathString(args.get(args.size() - 1));
		
		if(target instanceof Element) {
			final Element e = (Element)target;
			final Stereotype st = e.getAppliedStereotype(qualifiedName);
			final EObject stInstance = st != null ? e.getStereotypeApplication(st) : null;
			return stInstance != null ? Collections.singletonList(stInstance) : Collections.EMPTY_LIST;
		} else {
			return Collections.EMPTY_LIST;
		}
	}

	private Object getFirstObject(Object object) {
		if(object instanceof Collection) {
			final Collection c = (Collection)object;
			return c.size() > 0 ? c.iterator().next() : null;
		} else {
			return object;
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jet.xpath.XPathFunctionWithContext#setContext(org.eclipse.jet.xpath.Context)
	 */
	public void setContext(Context context) {
		this.context = context;
		// TODO Auto-generated method stub

	}

}
