/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.taglib.format;

import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.jet.BufferedJET2Writer;
import org.eclipse.jet.JET2Context;
import org.eclipse.jet.JET2Writer;
import org.eclipse.jet.internal.taglib.format.Messages;
import org.eclipse.jet.internal.taglib.format.ResourceBundleUtil;
import org.eclipse.jet.taglib.AbstractContainerTag;
import org.eclipse.jet.taglib.JET2TagException;
import org.eclipse.jet.taglib.TagInfo;
import org.eclipse.osgi.util.NLS;

public class MessageTag
extends AbstractContainerTag {
    private String key = null;
    private String var = null;
    private ResourceBundle bundle = null;
    private List parameters = new ArrayList(5);

    public void addParam(String value) {
        this.parameters.add(value);
    }

    private Object[] getBindings() {
        return this.parameters.toArray();
    }

    public void doBeforeBody(TagInfo td, JET2Context context, JET2Writer out) throws JET2TagException {
        this.key = this.getAttribute("key");
        this.var = this.getAttribute("var");
        this.bundle = ResourceBundleUtil.findBundle(context, this);
    }

    public void setBodyContent(JET2Writer bodyContent) {
        if (this.key == null && bodyContent instanceof BufferedJET2Writer) {
            this.key = ((BufferedJET2Writer)bodyContent).getContent().trim();
        }
    }

    public void doAfterBody(TagInfo td, JET2Context context, JET2Writer out) throws JET2TagException {
        String message;
        if (this.key == null) {
            throw new JET2TagException(Messages.MessageTag_NoKey);
        }
        try {
            message = this.bundle.getString(this.key);
        }
        catch (MissingResourceException missingResourceException) {
            throw new JET2TagException(NLS.bind((String)Messages.MessageTag_NoMessageForKey, (Object)this.key));
        }
        String formattedMessage = NLS.bind((String)message, (Object[])this.getBindings());
        if (this.var != null) {
            context.setVariable(this.var, (Object)formattedMessage);
        } else {
            out.write(formattedMessage);
        }
    }
}

