/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.taglib;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jet.taglib.CustomTagKind;
import org.eclipse.jet.taglib.TagAttributeDefinition;
import org.eclipse.jet.taglib.TagDefinition;
import org.eclipse.jet.taglib.TagLibrary;

public class TagDefinitionImpl
implements TagDefinition {
    private final String name;
    private final CustomTagKind kind;
    private final Map attributeDefinitions;
    private final boolean deprecated;
    private final boolean customContentProcessing;
    private final boolean allowAsEmpty;
    private final TagLibrary tagLibrary;
    private final String description;
    private final boolean removeWhenContainingLineIsEmpty;

    public TagDefinitionImpl(TagLibrary tagLibrary, String tagName, CustomTagKind kind, String description, boolean customContentProcessing, boolean allowAsEmpty, boolean deprecated, boolean removeWhenContainingLineIsEmpty) {
        this.tagLibrary = tagLibrary;
        this.name = tagName;
        this.kind = kind;
        this.description = description;
        this.customContentProcessing = customContentProcessing;
        this.allowAsEmpty = allowAsEmpty;
        this.deprecated = deprecated;
        this.removeWhenContainingLineIsEmpty = removeWhenContainingLineIsEmpty;
        this.attributeDefinitions = new HashMap();
    }

    public void addTagAttribute(TagAttributeDefinition tagAttributeDefinition) {
        this.attributeDefinitions.put(tagAttributeDefinition.getName(), tagAttributeDefinition);
    }

    public final String getName() {
        return this.name;
    }

    public CustomTagKind getKind() {
        return this.kind;
    }

    public TagAttributeDefinition getAttributeDefinition(String attrName) {
        return (TagAttributeDefinition)this.attributeDefinitions.get(attrName);
    }

    public List getAttributeDefinitions() {
        ArrayList list = new ArrayList(this.attributeDefinitions.values());
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                TagAttributeDefinition ad1 = (TagAttributeDefinition)o1;
                TagAttributeDefinition ad2 = (TagAttributeDefinition)o2;
                return ad1.getName().compareTo(ad2.getName());
            }
        });
        return list;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public boolean requiresNewWriter() {
        boolean required = false;
        if (this.kind == CustomTagKind.FUNCTION) {
            required = true;
        } else if (this.customContentProcessing && (this.kind == CustomTagKind.CONTAINER || this.kind == CustomTagKind.CONDITIONAL || this.kind == CustomTagKind.ITERATING)) {
            required = true;
        }
        return required;
    }

    public boolean isEmptyTagAllowed() {
        boolean allowed = false;
        if (this.kind == CustomTagKind.EMPTY || this.kind == CustomTagKind.OTHER) {
            allowed = true;
        } else if (this.allowAsEmpty && (this.kind == CustomTagKind.CONTAINER || this.kind == CustomTagKind.CONDITIONAL || this.kind == CustomTagKind.ITERATING)) {
            allowed = true;
        }
        return allowed;
    }

    public boolean isContentAllowed() {
        boolean allowed = false;
        if (this.kind == CustomTagKind.FUNCTION || this.kind == CustomTagKind.CONTAINER || this.kind == CustomTagKind.CONDITIONAL || this.kind == CustomTagKind.ITERATING || this.kind == CustomTagKind.OTHER) {
            allowed = true;
        }
        return allowed;
    }

    public TagLibrary getTagLibrary() {
        return this.tagLibrary;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean removeWhenContainingLineIsEmpty() {
        return this.removeWhenContainingLineIsEmpty;
    }
}

