/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.taglib.format;

import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.jet.JET2Context;
import org.eclipse.jet.internal.taglib.format.BundleTag;
import org.eclipse.jet.internal.taglib.format.Messages;
import org.eclipse.jet.taglib.CustomTag;
import org.eclipse.jet.taglib.JET2TagException;
import org.eclipse.jet.transform.TransformContextExtender;
import org.eclipse.osgi.util.NLS;

public class ResourceBundleUtil {
    private static final String DEFAULT_BUNDLE_VAR = "org.eclipse.jet.taglib.format.resourceBundle";
    private static final String DEFAULT_LOCALE_VAR = "org.eclipse.jet.taglib.format.locale";
    private static ResourceBundle EMPTY_BUNDLE = new ResourceBundle(){

        protected Object handleGetObject(String key) {
            return null;
        }

        public Enumeration getKeys() {
            return null;
        }
    };

    public static ResourceBundle loadBundle(JET2Context context, String baseName) {
        ClassLoader classLoader = TransformContextExtender.getInstance(context).getLoader().getClass().getClassLoader();
        try {
            return ResourceBundle.getBundle(baseName, ResourceBundleUtil.getLocale(context), classLoader);
        }
        catch (MissingResourceException e) {
            throw new JET2TagException(NLS.bind((String)Messages.ResourceBundleUtil_UnableToLoadBundle, (Object)baseName), (Throwable)e);
        }
    }

    public static ResourceBundle findBundle(JET2Context context, CustomTag currentTag) {
        CustomTag parent = currentTag.getParent();
        while (parent != null) {
            if (parent instanceof BundleTag) {
                return ((BundleTag)parent).getBundle();
            }
            parent = parent.getParent();
        }
        Object defaultBundle = context.hasVariable(DEFAULT_BUNDLE_VAR) ? context.getVariable(DEFAULT_BUNDLE_VAR) : null;
        return defaultBundle instanceof ResourceBundle ? (ResourceBundle)defaultBundle : EMPTY_BUNDLE;
    }

    public static void setDefaultBundle(JET2Context context, ResourceBundle bundle) {
        context.setVariable(DEFAULT_BUNDLE_VAR, (Object)bundle);
    }

    public static void setLocale(JET2Context context, String value, String variant) {
        value = value.trim();
        variant = variant.trim();
        String[] parts = value.split("[_\\-]");
        String language = parts.length > 0 ? parts[0] : "";
        String country = parts.length > 1 ? parts[1] : "";
        Locale locale = new Locale(language, country, variant);
        context.setVariable(DEFAULT_LOCALE_VAR, (Object)locale);
    }

    private static Locale getLocale(JET2Context context) {
        Object locale = context.hasVariable(DEFAULT_LOCALE_VAR) ? context.getVariable(DEFAULT_LOCALE_VAR) : null;
        return locale instanceof Locale ? (Locale)locale : Locale.getDefault();
    }
}

