/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.extensionpoints;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jet.internal.JETActivatorWrapper;
import org.eclipse.jet.internal.extensionpoints.TagLibraryImpl;
import org.eclipse.jet.internal.taglib.ExtensionTagLibraryImpl;
import org.eclipse.jet.internal.taglib.TagAttributeDefinitionImpl;
import org.eclipse.jet.internal.taglib.TagDefinitionImpl;
import org.eclipse.jet.taglib.CustomTagKind;
import org.eclipse.jet.taglib.TagAttributeDefinition;
import org.eclipse.jet.taglib.TagDefinition;
import org.eclipse.jet.taglib.TagLibrary;
import org.eclipse.jet.xpath.NodeSet;
import org.eclipse.jet.xpath.XPath;
import org.eclipse.jet.xpath.XPathException;
import org.eclipse.jet.xpath.XPathExpression;
import org.eclipse.jet.xpath.XPathFactory;
import org.eclipse.jet.xpath.XPathRuntimeException;

public final class TagLibraryDataFactory {
    public static final String A_ALLOW_AS_EMPTY = "allowAsEmpty";
    public static final String A_CLASS = "class";
    public static final String A_DEPRECATED = "deprecated";
    public static final String A_ID = "id";
    public static final String A_NAME = "name";
    public static final String A_PROCESS_CONTENTS = "processContents";
    public static final String A_STANDARD_PREFIX = "standardPrefix";
    public static final String A_TYPE = "type";
    public static final String A_USE = "use";
    public static final String A_WHEN_CONTAINING_LINE_IS_EMPTY = "whenContainingLineIsEmpty";
    public static final String E_ATTRIBUTE = "attribute";
    public static final String E_CONDITIONALTAG = "conditionalTag";
    public static final String E_CONTAINERTAG = "containerTag";
    public static final String E_DESCRIPTION = "description";
    public static final String E_EMPTYTAG = "emptyTag";
    public static final String E_FUNCTIONTAG = "functionTag";
    public static final String E_ITERATINGTAG = "iteratingTag";
    public static final String E_OTHERTAG = "otherTag";
    public static final String E_TAGLIBRARY = "tagLibrary";
    public static final TagLibraryDataFactory INSTANCE = new TagLibraryDataFactory();
    public static final String PROCESS_CONTENTS_CUSTOM = "custom";
    public static final String PROCESS_CONTENTS_STANDARD = "standard";
    public static final String TYPE_BOOLEAN = "boolean";
    public static final String TYPE_STRING = "string";
    public static final String TYPE_XPATH = "xpath";
    public static final String USE_OPTIONAL = "optional";
    public static final String USE_REQUIRED = "required";
    public static final String WHEN_CONTAINING_LINE_IS_EMPTY_PRESERVE = "preserve";
    public static final String WHEN_CONTAINING_LINE_IS_EMPTY_REMOVE = "remove";
    private static final Map tagToKindMap = new HashMap(5);
    private boolean expresionsInitialized = false;
    private XPathExpression xIsDeprecated;
    private XPathExpression xId;
    private XPathExpression xName;
    private XPathExpression xStdPrefix;
    private XPathExpression xDescription;
    private XPathExpression xEAttributes;
    private XPathExpression xETagLibraries;
    private XPathExpression xETags;
    private XPathExpression xIsRemoveWhenContainingLineIsEmpty;
    private XPathExpression xIsAllowAsEmpty;
    private XPathExpression xIsOptionalUse;
    private XPathExpression xType;
    private XPathExpression xIsPreserveWhenContainingLineIsEmpty;
    private XPathExpression xElementName;
    private XPathExpression xIsCustomProcessContents;

    static {
        tagToKindMap.put(E_OTHERTAG, CustomTagKind.OTHER);
        tagToKindMap.put(E_FUNCTIONTAG, CustomTagKind.FUNCTION);
        tagToKindMap.put(E_ITERATINGTAG, CustomTagKind.ITERATING);
        tagToKindMap.put(E_CONDITIONALTAG, CustomTagKind.CONDITIONAL);
        tagToKindMap.put(E_EMPTYTAG, CustomTagKind.EMPTY);
        tagToKindMap.put(E_CONTAINERTAG, CustomTagKind.CONTAINER);
    }

    private TagLibraryDataFactory() {
    }

    public TagLibrary createTagLibrary(String namespace, IConfigurationElement element) {
        String id = element.getAttribute(A_ID);
        String libraryId = String.valueOf(namespace) + "." + id;
        return new ExtensionTagLibraryImpl(libraryId, element);
    }

    public TagLibrary[] createTagLibraries(String namespace, Object pluginDocumentRoot) {
        ArrayList<TagLibrary> libraries = new ArrayList<TagLibrary>();
        try {
            this.initXPathExpressions();
            NodeSet nodeSet = this.xETagLibraries.evaluateAsNodeSet(pluginDocumentRoot);
            Iterator i = nodeSet.iterator();
            while (i.hasNext()) {
                Object tagLibraryElement = i.next();
                TagLibrary tagLibrary = this.createTagLibrary(namespace, tagLibraryElement);
                if (tagLibraryElement == null) continue;
                libraries.add(tagLibrary);
            }
        }
        catch (XPathException e) {
            JETActivatorWrapper.INSTANCE.log(e);
        }
        catch (XPathRuntimeException e) {
            JETActivatorWrapper.INSTANCE.log(e);
        }
        return libraries.toArray(new TagLibrary[libraries.size()]);
    }

    public TagLibrary createTagLibrary(String namespace, Object tagLibraryElement) {
        TagLibraryImpl result = null;
        try {
            this.initXPathExpressions();
            String id = this.xId.evaluateAsString(tagLibraryElement);
            String tagLibraryId = String.valueOf(namespace) + "." + id;
            String name = this.xName.evaluateAsString(tagLibraryElement);
            String stdPrefix = this.xStdPrefix.evaluateAsString(tagLibraryElement);
            boolean deprecated = this.xIsDeprecated.evaluateAsBoolean(tagLibraryElement);
            String description = this.xDescription.evaluateAsString(tagLibraryElement).trim();
            TagLibraryImpl tagLibrary = new TagLibraryImpl(tagLibraryId, name, description, stdPrefix, deprecated);
            NodeSet tags = this.xETags.evaluateAsNodeSet(tagLibraryElement);
            Iterator i = tags.iterator();
            while (i.hasNext()) {
                Object tagElement = i.next();
                TagDefinition tagDefinition = this.createTagDefinition(tagLibrary, tagElement);
                if (tagDefinition == null) continue;
                tagLibrary.addTag(tagDefinition);
            }
            result = tagLibrary;
        }
        catch (XPathException e) {
            JETActivatorWrapper.INSTANCE.log(e);
        }
        return result;
    }

    private TagDefinition createTagDefinition(TagLibrary tagLibrary, Object tagElement) {
        TagDefinitionImpl tagDefinition = null;
        try {
            TagDefinitionImpl tagDefinitionImpl;
            String name = this.xName.evaluateAsString(tagElement);
            String description = this.xDescription.evaluateAsString(tagElement).trim();
            String elementName = this.xElementName.evaluateAsString(tagElement);
            CustomTagKind kind = this.getCustomKind(elementName);
            boolean deprecated = this.xIsDeprecated.evaluateAsBoolean(tagElement);
            boolean removeWhenContainingLineIsEmpty = kind == CustomTagKind.EMPTY || kind == CustomTagKind.FUNCTION ? this.xIsRemoveWhenContainingLineIsEmpty.evaluateAsBoolean(tagElement) : !this.xIsPreserveWhenContainingLineIsEmpty.evaluateAsBoolean(tagElement);
            boolean allowAsEmpty = this.xIsAllowAsEmpty.evaluateAsBoolean(tagElement);
            boolean customContentProcessing = this.xIsCustomProcessContents.evaluateAsBoolean(tagElement);
            tagDefinition = tagDefinitionImpl = new TagDefinitionImpl(tagLibrary, name, kind, description, customContentProcessing, allowAsEmpty, deprecated, removeWhenContainingLineIsEmpty);
            NodeSet attributes = this.xEAttributes.evaluateAsNodeSet(tagElement);
            Iterator i = attributes.iterator();
            while (i.hasNext()) {
                Object attributeElement = i.next();
                TagAttributeDefinition tagAttrDefn = this.createTagAttributeDefinition(attributeElement);
                if (tagAttrDefn == null) continue;
                tagDefinitionImpl.addTagAttribute(tagAttrDefn);
            }
        }
        catch (XPathRuntimeException e) {
            JETActivatorWrapper.INSTANCE.log(e);
        }
        return tagDefinition;
    }

    private TagAttributeDefinition createTagAttributeDefinition(Object attributeElement) {
        TagAttributeDefinitionImpl tagAttributeDefinition = null;
        try {
            String name = this.xName.evaluateAsString(attributeElement);
            String description = this.xDescription.evaluateAsString(attributeElement).trim();
            boolean required = !this.xIsOptionalUse.evaluateAsBoolean(attributeElement);
            boolean deprecated = this.xIsDeprecated.evaluateAsBoolean(attributeElement);
            String type = this.xType.evaluateAsString(attributeElement);
            if (type.length() == 0) {
                type = TYPE_STRING;
            }
            tagAttributeDefinition = new TagAttributeDefinitionImpl(name, required, deprecated, description, type);
        }
        catch (XPathRuntimeException e) {
            JETActivatorWrapper.INSTANCE.log(e);
        }
        return tagAttributeDefinition;
    }

    private CustomTagKind getCustomKind(String elementName) {
        return (CustomTagKind)tagToKindMap.get(elementName);
    }

    private void initXPathExpressions() throws XPathException {
        if (!this.expresionsInitialized) {
            XPath xpath = XPathFactory.newInstance().newXPath(null);
            this.xETagLibraries = xpath.compile("/plugin/extension[@point = 'org.eclipse.jet.tagLibraries']/tagLibrary");
            this.xETags = xpath.compile("conditionalTag|containerTag|emptyTag|functionTag|iteratingTag|otherTag");
            this.xEAttributes = xpath.compile(E_ATTRIBUTE);
            this.xDescription = xpath.compile(E_DESCRIPTION);
            this.xElementName = xpath.compile("local-name()");
            this.xId = xpath.compile("@id");
            this.xName = xpath.compile("@name");
            this.xStdPrefix = xpath.compile("@standardPrefix");
            this.xIsDeprecated = xpath.compile("@deprecated= 'true'");
            this.xIsRemoveWhenContainingLineIsEmpty = xpath.compile("@whenContainingLineIsEmpty = 'remove'");
            this.xIsPreserveWhenContainingLineIsEmpty = xpath.compile("@whenContainingLineIsEmpty = 'preserve'");
            this.xIsAllowAsEmpty = xpath.compile("@allowAsEmpty = 'true'");
            this.xIsCustomProcessContents = xpath.compile("@processContents = 'custom'");
            this.xIsOptionalUse = xpath.compile("@use = 'optional'");
            this.xType = xpath.compile("@type");
            this.expresionsInitialized = true;
        }
    }
}

