/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.compiler.templates.v2;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.jet.JET2Context;
import org.eclipse.jet.JET2Template;
import org.eclipse.jet.JET2Writer;
import org.eclipse.jet.core.parser.ast.Comment;
import org.eclipse.jet.core.parser.ast.EmbeddedExpression;
import org.eclipse.jet.core.parser.ast.JETASTElement;
import org.eclipse.jet.core.parser.ast.JETASTVisitor;
import org.eclipse.jet.core.parser.ast.JETCompilationUnit;
import org.eclipse.jet.core.parser.ast.JavaDeclaration;
import org.eclipse.jet.core.parser.ast.JavaElement;
import org.eclipse.jet.core.parser.ast.JavaExpression;
import org.eclipse.jet.core.parser.ast.JavaScriptlet;
import org.eclipse.jet.core.parser.ast.TextElement;
import org.eclipse.jet.core.parser.ast.XMLBodyElement;
import org.eclipse.jet.core.parser.ast.XMLElement;
import org.eclipse.jet.core.parser.ast.XMLEmptyElement;
import org.eclipse.jet.internal.JavaUtil;
import org.eclipse.jet.internal.compiler.HasNewlinesUtil;
import org.eclipse.jet.internal.compiler.TagUsageVisitor;
import org.eclipse.jet.internal.compiler.V2CodeGenVisitor;
import org.eclipse.jet.taglib.TagLibraryReference;

public class JET2JavaGeneratorNew
implements JET2Template {
    private static final String NL = System.getProperty("line.separator");

    public void generate(JET2Context context, JET2Writer __out) {
        JET2Writer out = __out;
        final boolean hcrFriendly = context.hasVariable("hcrFriendly") ? (Boolean)context.getVariable("hcrFriendly") : false;
        JETCompilationUnit cu = (JETCompilationUnit)context.getVariable("cu");
        final TagUsageVisitor tuv = new TagUsageVisitor();
        cu.accept((JETASTVisitor)tuv);
        TagLibraryReference[] tlrefs = tuv.getUsedTagLibraryReferences(cu);
        Arrays.sort(tlrefs, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((TagLibraryReference)o1).getTagLibraryId().compareTo(((TagLibraryReference)o2).getTagLibraryId());
            }
        });
        cu.accept((JETASTVisitor)new V2CodeGenVisitor(context, out, ""){

            public boolean visit(Comment comment) {
                String text = comment.getCommentText();
                if (this.isHeaderComment(text)) {
                    this.out.write("/*");
                    this.out.write(NL);
                    this.out.write(this.formatComment(text, " * "));
                    this.out.write(" */");
                    this.out.write(NL);
                }
                return true;
            }
        });
        out.write("package ");
        out.write(cu.getOutputJavaPackage());
        out.write(";");
        out.write(NL);
        out.write(NL);
        out.write("import org.eclipse.jet.JET2Context;");
        out.write(NL);
        out.write("import org.eclipse.jet.JET2Template;");
        out.write(NL);
        out.write("import org.eclipse.jet.JET2Writer;");
        out.write(NL);
        if (tuv.hasTags()) {
            out.write("import org.eclipse.jet.taglib.RuntimeTagElement;");
            out.write(NL);
            out.write("import org.eclipse.jet.taglib.TagInfo;");
            out.write(NL);
        }
        Iterator i = cu.getImports().iterator();
        while (i.hasNext()) {
            out.write("import ");
            out.write((String)i.next());
            out.write(";");
            out.write(NL);
        }
        out.write(NL);
        cu.accept((JETASTVisitor)new V2CodeGenVisitor(context, out, ""){

            public boolean visit(Comment comment) {
                String text = comment.getCommentText();
                if (this.isClassComment(text)) {
                    this.out.write("/**");
                    this.out.write(NL);
                    this.out.write(this.formatComment(text, " * "));
                    this.out.write(" */");
                    this.out.write(NL);
                }
                return true;
            }
        });
        out.write("public class ");
        out.write(cu.getOutputJavaClassName());
        out.write(" implements JET2Template {");
        out.write(NL);
        if (!hcrFriendly) {
            int i2 = 0;
            while (i2 < tlrefs.length) {
                out.write("    private static final String _jetns_");
                out.write(tlrefs[i2].getPrefix());
                out.write(" = \"");
                out.write(tlrefs[i2].getTagLibraryId());
                out.write("\"; //$NON-NLS-1$");
                out.write(NL);
                ++i2;
            }
        }
        out.write(NL);
        cu.accept((JETASTVisitor)new V2CodeGenVisitor(context, out){

            public boolean visit(JavaDeclaration decl) {
                this.writeAndRecord((JavaElement)decl);
                this.out.write(NL);
                return true;
            }
        });
        out.write("    public ");
        out.write(cu.getOutputJavaClassName());
        out.write("() {");
        out.write(NL);
        out.write("        super();");
        out.write(NL);
        out.write("    }");
        out.write(NL);
        if (HasNewlinesUtil.test((JETASTElement)cu)) {
            out.write(NL);
            out.write("    private static final String ");
            out.write("NL");
            out.write(" = System.getProperty(\"line.separator\"); //$NON-NLS-1$");
            out.write(NL);
        }
        if (tuv.hasTags() && !hcrFriendly) {
            out.write("    ");
            out.write(NL);
            cu.accept((JETASTVisitor)new V2CodeGenVisitor(context, out, "    "){

                public boolean visit(XMLBodyElement e) {
                    this.doElementVisit((XMLElement)e);
                    return true;
                }

                public boolean visit(XMLEmptyElement e) {
                    this.doElementVisit((XMLElement)e);
                    return true;
                }

                public void doElementVisit(XMLElement e) {
                    this.out.write("    private static final TagInfo _td_");
                    this.out.write(this.tagInfoVar(e));
                    this.out.write(" = new TagInfo(\"");
                    this.out.write(e.getName());
                    this.out.write("\", //$NON-NLS-1$");
                    this.out.write(NL);
                    this.out.write("            ");
                    this.out.write(e.getLine());
                    this.out.write(", ");
                    this.out.write(e.getColumn());
                    this.out.write(",");
                    this.out.write(NL);
                    this.out.write("            new String[] {");
                    this.out.write(NL);
                    Iterator<Object> i = e.getAttributes().keySet().iterator();
                    while (i.hasNext()) {
                        this.out.write("                \"");
                        this.out.write((String)i.next());
                        this.out.write("\", //$NON-NLS-1$");
                        this.out.write(NL);
                    }
                    this.out.write("            },");
                    this.out.write(NL);
                    this.out.write("            new String[] {");
                    this.out.write(NL);
                    i = e.getAttributes().values().iterator();
                    while (i.hasNext()) {
                        String attrValue = (String)i.next();
                        this.out.write("                \"");
                        this.out.write(JavaUtil.escapeJavaString(attrValue.toCharArray()));
                        this.out.write("\", //$NON-NLS-1$");
                        this.out.write(NL);
                    }
                    this.out.write("            } );");
                    this.out.write(NL);
                }
            });
        }
        if (tuv.hasTags() && hcrFriendly) {
            out.write(NL);
            out.write("    private TagInfo[] _init_tagInfo() { ");
            out.write(NL);
            if (tuv.hasAttributelessTags()) {
                out.write("        final String[] EMPTY_STRING_ARRAY = new String[0];");
                out.write(NL);
            }
            out.write("        return new TagInfo[] {");
            out.write(NL);
            cu.accept((JETASTVisitor)new V2CodeGenVisitor(context, out, "    "){

                public boolean visit(XMLBodyElement e) {
                    this.doElementVisit((XMLElement)e);
                    return true;
                }

                public boolean visit(XMLEmptyElement e) {
                    this.doElementVisit((XMLElement)e);
                    return true;
                }

                public void doElementVisit(XMLElement e) {
                    this.out.write("        new TagInfo(\"");
                    this.out.write(e.getName());
                    this.out.write("\", //$NON-NLS-1$");
                    this.out.write(NL);
                    this.out.write("            ");
                    this.out.write(e.getLine());
                    this.out.write(", ");
                    this.out.write(e.getColumn());
                    this.out.write(",");
                    this.out.write(NL);
                    if (e.getAttributes().size() > 0) {
                        this.out.write("            new String[] {");
                        this.out.write(NL);
                        Iterator<Object> i = e.getAttributes().keySet().iterator();
                        while (i.hasNext()) {
                            this.out.write("                \"");
                            this.out.write((String)i.next());
                            this.out.write("\", //$NON-NLS-1$");
                            this.out.write(NL);
                        }
                        this.out.write("            },");
                        this.out.write(NL);
                        this.out.write("            new String[] {");
                        this.out.write(NL);
                        i = e.getAttributes().values().iterator();
                        while (i.hasNext()) {
                            String attrValue = (String)i.next();
                            this.out.write("                \"");
                            this.out.write(JavaUtil.escapeJavaString(attrValue.toCharArray()));
                            this.out.write("\", //$NON-NLS-1$");
                            this.out.write(NL);
                        }
                        this.out.write("            } ),");
                        this.out.write(NL);
                    } else {
                        this.out.write("            EMPTY_STRING_ARRAY, EMPTY_STRING_ARRAY ),");
                        this.out.write(NL);
                    }
                }
            });
            out.write("        };   ");
            out.write(NL);
            out.write("    }");
            out.write(NL);
        }
        out.write(NL);
        out.write("    public void generate(final JET2Context context, final JET2Writer __out) {");
        out.write(NL);
        if (hcrFriendly) {
            int i3 = 0;
            while (i3 < tlrefs.length) {
                out.write("        final String _jetns_");
                out.write(tlrefs[i3].getPrefix());
                out.write(" = \"");
                out.write(tlrefs[i3].getTagLibraryId());
                out.write("\"; //$NON-NLS-1$");
                out.write(NL);
                ++i3;
            }
            if (tuv.hasTags()) {
                out.write("        final TagInfo[] _td_ = _init_tagInfo();");
                out.write(NL);
            }
        }
        out.write("        JET2Writer out = __out;");
        out.write(NL);
        cu.accept((JETASTVisitor)new V2CodeGenVisitor(context, out, "    "){

            public boolean visit(TextElement text) {
                if (text.getText().length > 0) {
                    String[] strings = this.textConstants(text, "NL");
                    int i = 0;
                    while (i < strings.length) {
                        this.out.write("        out.write(");
                        this.out.write(strings[i]);
                        this.out.write("); ");
                        if (strings[i].startsWith("\"")) {
                            this.out.write(" //$NON-NLS-1$");
                        }
                        this.out.write("        ");
                        this.out.write(NL);
                        ++i;
                    }
                }
                return true;
            }

            public boolean visit(JavaScriptlet scriptlet) {
                this.writeAndRecord((JavaElement)scriptlet);
                this.out.write(NL);
                return true;
            }

            public boolean visit(JavaExpression expr) {
                this.out.write("        out.write(");
                this.writeAndRecord((JavaElement)expr);
                this.out.write(");");
                this.out.write(NL);
                return true;
            }

            public boolean visit(EmbeddedExpression expr) {
                this.out.write("        out.write(context.embeddedExpressionAsString(");
                this.out.write(JavaUtil.asJavaQuotedString(expr.getExpression().toCharArray()));
                this.out.write(", ");
                this.out.write(expr.getLine());
                this.out.write(", ");
                this.out.write(expr.getColumn());
                this.out.write(")); //$NON-NLS-1$ //$NON-NLS-2$");
                this.out.write(NL);
                return true;
            }

            public boolean visit(XMLBodyElement e) {
                this.out.write("        RuntimeTagElement ");
                this.out.write(this.tagVar((XMLElement)e));
                this.out.write(" = context.getTagFactory().createRuntimeTag(_jetns_");
                this.out.write(e.getNSPrefix());
                this.out.write(", \"");
                this.out.write(e.getTagNCName());
                this.out.write("\", \"");
                this.out.write(e.getName());
                this.out.write("\", _td_");
                this.out.write(hcrFriendly ? tuv.ordinalExpr((XMLElement)e) : this.tagInfoVar((XMLElement)e));
                this.out.write("); //$NON-NLS-1$ //$NON-NLS-2$");
                this.out.write(NL);
                this.out.write("        ");
                this.out.write(this.tagVar((XMLElement)e));
                this.out.write(".setRuntimeParent(");
                this.out.write(this.parentTagVar((XMLElement)e));
                this.out.write(");");
                this.out.write(NL);
                this.out.write("        ");
                this.out.write(this.tagVar((XMLElement)e));
                this.out.write(".setTagInfo(_td_");
                this.out.write(hcrFriendly ? tuv.ordinalExpr((XMLElement)e) : this.tagInfoVar((XMLElement)e));
                this.out.write(");");
                this.out.write(NL);
                this.out.write("        ");
                this.out.write(this.tagVar((XMLElement)e));
                this.out.write(".doStart(context, out);");
                this.out.write(NL);
                if (this.requiresOwnWriter((XMLElement)e)) {
                    this.out.write("        JET2Writer ");
                    this.out.write(this.tagVar((XMLElement)e));
                    this.out.write("_saved_out = out;");
                    this.out.write(NL);
                }
                this.out.write("        while (");
                this.out.write(this.tagVar((XMLElement)e));
                this.out.write(".okToProcessBody()) {");
                this.out.write(NL);
                if (this.requiresOwnWriter((XMLElement)e)) {
                    this.out.write("            out = out.newNestedContentWriter();");
                    this.out.write(NL);
                }
                this.in();
                return true;
            }

            public void endVisit(XMLBodyElement e) {
                this.out();
                this.out.write("            ");
                this.out.write(this.tagVar((XMLElement)e));
                this.out.write(".handleBodyContent(out);");
                this.out.write(NL);
                this.out.write("        }");
                this.out.write(NL);
                if (this.requiresOwnWriter((XMLElement)e)) {
                    this.out.write("        out = ");
                    this.out.write(this.tagVar((XMLElement)e));
                    this.out.write("_saved_out;");
                    this.out.write(NL);
                }
                this.out.write("        ");
                this.out.write(this.tagVar((XMLElement)e));
                this.out.write(".doEnd();");
                this.out.write(NL);
            }

            public boolean visit(XMLEmptyElement e) {
                this.out.write("        RuntimeTagElement ");
                this.out.write(this.tagVar((XMLElement)e));
                this.out.write(" = context.getTagFactory().createRuntimeTag(_jetns_");
                this.out.write(e.getNSPrefix());
                this.out.write(", \"");
                this.out.write(e.getTagNCName());
                this.out.write("\", \"");
                this.out.write(e.getName());
                this.out.write("\", _td_");
                this.out.write(hcrFriendly ? tuv.ordinalExpr((XMLElement)e) : this.tagInfoVar((XMLElement)e));
                this.out.write("); //$NON-NLS-1$ //$NON-NLS-2$");
                this.out.write(NL);
                this.out.write("        ");
                this.out.write(this.tagVar((XMLElement)e));
                this.out.write(".setRuntimeParent(");
                this.out.write(this.parentTagVar((XMLElement)e));
                this.out.write(");");
                this.out.write(NL);
                this.out.write("        ");
                this.out.write(this.tagVar((XMLElement)e));
                this.out.write(".setTagInfo(_td_");
                this.out.write(hcrFriendly ? tuv.ordinalExpr((XMLElement)e) : this.tagInfoVar((XMLElement)e));
                this.out.write(");");
                this.out.write(NL);
                this.out.write("        ");
                this.out.write(this.tagVar((XMLElement)e));
                this.out.write(".doStart(context, out);");
                this.out.write(NL);
                this.out.write("        ");
                this.out.write(this.tagVar((XMLElement)e));
                this.out.write(".doEnd();");
                this.out.write(NL);
                return true;
            }

            public boolean visit(Comment comment) {
                String text = comment.getCommentText();
                if (this.isNormalComment(text)) {
                    this.out.write(this.formatComment(text, "        //"));
                }
                return true;
            }
        });
        out.write("    }");
        out.write(NL);
        out.write("}");
        out.write(NL);
    }
}

