/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.editor.actions;

import org.eclipse.jet.internal.editor.JETTextEditor;
import org.eclipse.jet.internal.editor.configuration.delegates.IJETDefaultTextColorerDelegate;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.dialogs.ListDialog;

public class SetContentColorerAction
implements IEditorActionDelegate {
    private JETTextEditor editor;

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.editor = (JETTextEditor)targetEditor;
        action.setText("Set default content colorer ...");
    }

    public void run(IAction action) {
        ListDialog dialog = new ListDialog(this.editor.getSite().getShell());
        dialog.setLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IJETDefaultTextColorerDelegate) {
                    return ((IJETDefaultTextColorerDelegate)element).getName();
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                if (element instanceof IJETDefaultTextColorerDelegate) {
                    return ((IJETDefaultTextColorerDelegate)element).getImage();
                }
                return super.getImage(element);
            }
        });
        dialog.setContentProvider(new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return SetContentColorerAction.this.editor.getColorerDelegates();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        dialog.setTitle("JET default text content colorer");
        dialog.setMessage("Select the content colorer to the default text embeded in the JET template");
        dialog.setInitialSelections((Object[])this.editor.getColorerDelegates());
        dialog.setInput((Object)this.editor);
        int result = dialog.open();
        if (result == 0) {
            IJETDefaultTextColorerDelegate delegate = (IJETDefaultTextColorerDelegate)dialog.getResult()[0];
            this.editor.setCurrentColorerDelegate(delegate);
        }
    }

    public void selectionChanged(IAction iaction, ISelection iselection) {
    }
}

