/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security.authentication;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.CrossContextPsuedoSession;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.authentication.DelegateAuthenticator;
import org.eclipse.jetty.server.Authentication;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XCPSCachingAuthenticator
extends DelegateAuthenticator {
    public static final String __J_AUTHENTICATED = "org.eclipse.jetty.server.Auth";
    private final CrossContextPsuedoSession<Authentication> _xcps;

    public XCPSCachingAuthenticator(Authenticator delegate, CrossContextPsuedoSession<Authentication> xcps) {
        super(delegate);
        this._xcps = xcps;
    }

    @Override
    public Authentication validateRequest(ServletRequest request, ServletResponse response, boolean manditory) throws ServerAuthException {
        Authentication serverAuthResult = this._xcps.fetch((HttpServletRequest)request);
        if (serverAuthResult != null) {
            return serverAuthResult;
        }
        serverAuthResult = this._delegate.validateRequest(request, response, manditory);
        if (serverAuthResult != null) {
            this._xcps.store(serverAuthResult, (HttpServletResponse)response);
        }
        return serverAuthResult;
    }
}

