/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.annotations;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jetty.annotations.AnnotationParser;
import org.eclipse.jetty.annotations.ClassNameResolver;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebXmlProcessor;

public abstract class AbstractConfiguration
implements Configuration {
    public static final String CONTAINER_JAR_RESOURCES = "org.eclipse.jetty.containerJars";
    public static final String WEB_INF_JAR_RESOURCES = "org.eclipse.jetty.webInfJars";
    public static final String WEBXML_VERSION = "org.eclipse.jetty.webXmlVersion";
    public static final String METADATA_COMPLETE = "org.eclipse.jetty.metadataComplete";
    public static final String WEBXML_CLASSNAMES = "org.eclipse.jetty.webXmlClassNames";

    public void parseContainerPath(final WebAppContext context, AnnotationParser parser) throws Exception {
        Log.debug((String)"Scanning container jars");
        ArrayList<URI> containerUris = new ArrayList<URI>();
        List jarResources = (List)context.getAttribute(CONTAINER_JAR_RESOURCES);
        for (Resource r : jarResources) {
            URI uri = r.getURI();
            containerUris.add(uri);
        }
        parser.parse(containerUris.toArray(new URI[containerUris.size()]), new ClassNameResolver(){

            public boolean isExcluded(String name) {
                if (context.isSystemClass(name)) {
                    return false;
                }
                return context.isServerClass(name);
            }

            public boolean shouldOverride(String name) {
                return context.isParentLoaderPriority();
            }
        });
    }

    public void parseWebInfLib(final WebAppContext context, AnnotationParser parser) throws Exception {
        WebXmlProcessor webXmlProcessor = (WebXmlProcessor)context.getAttribute("org.eclipse.jetty.webProcessor");
        if (webXmlProcessor == null) {
            throw new IllegalStateException("No processor for web xml");
        }
        List frags = webXmlProcessor.getFragments();
        ArrayList<URI> webInfUris = new ArrayList<URI>();
        List jarResources = (List)context.getAttribute(WEB_INF_JAR_RESOURCES);
        for (Resource r : jarResources) {
            URI uri = r.getURI();
            WebXmlProcessor.Descriptor d = null;
            for (WebXmlProcessor.Descriptor frag : frags) {
                Resource fragResource = frag.getResource();
                if (!Resource.isContainedIn((Resource)fragResource, (Resource)r)) continue;
                d = frag;
                break;
            }
            if (d != null && (d == null || d.isMetaDataComplete())) continue;
            webInfUris.add(uri);
        }
        parser.parse(webInfUris.toArray(new URI[webInfUris.size()]), new ClassNameResolver(){

            public boolean isExcluded(String name) {
                if (context.isSystemClass(name)) {
                    return true;
                }
                if (context.isServerClass(name)) {
                    return false;
                }
                return false;
            }

            public boolean shouldOverride(String name) {
                return !context.isParentLoaderPriority();
            }
        });
    }

    public void parseWebInfClasses(final WebAppContext context, AnnotationParser parser) throws Exception {
        Resource classesDir;
        Log.debug((String)"Scanning classes in WEB-INF/classes");
        if (context.getWebInf() != null && (classesDir = context.getWebInf().addPath("classes/")).exists()) {
            parser.parse(classesDir, new ClassNameResolver(){

                public boolean isExcluded(String name) {
                    if (context.isSystemClass(name)) {
                        return true;
                    }
                    if (context.isServerClass(name)) {
                        return false;
                    }
                    return false;
                }

                public boolean shouldOverride(String name) {
                    return !context.isParentLoaderPriority();
                }
            });
        }
    }

    public void parse25Classes(final WebAppContext context, AnnotationParser parser) throws Exception {
        if (Log.isDebugEnabled()) {
            Log.debug((String)"Scanning only classes from web.xml");
        }
        ArrayList classNames = (ArrayList)context.getAttribute(WEBXML_CLASSNAMES);
        for (String s : classNames) {
            Class clazz = Loader.loadClass(null, (String)s);
            parser.parse(clazz, new ClassNameResolver(){

                public boolean isExcluded(String name) {
                    if (context.isSystemClass(name)) {
                        return true;
                    }
                    if (context.isServerClass(name)) {
                        return false;
                    }
                    return false;
                }

                public boolean shouldOverride(String name) {
                    return !context.isParentLoaderPriority();
                }
            }, true);
        }
    }
}

