/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.pde.launch;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jetty.osgi.pde.launch.internal.NaiveJavaProjectToWebappIdentifier;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class JettyOSGiPDEPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.jetty.osgi.pde.launch";
    public static final String NATURE_PLUGIN = "org.eclipse.pde.PluginNature";
    public static final String NATURE_JAVA = "org.eclipse.jdt.core.javanature";
    public static final String HEADER_DEPLOY_AS_JAVA_PROJECT = "JettySDK-DontDeployAsOSGi";
    private static JettyOSGiPDEPlugin plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static JettyOSGiPDEPlugin getDefault() {
        return plugin;
    }

    public static boolean atLeastOneJavaProjectThatIsNotAPlugin() {
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject proj = iProjectArray[n2];
            if (JettyOSGiPDEPlugin.isJavaProjectButNotAPlugin(proj) || JettyOSGiPDEPlugin.isProcessedAsOSGiProject(proj)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isJavaProjectButNotAPlugin(IProject proj) {
        try {
            return proj.isAccessible() && proj.hasNature(NATURE_JAVA) && !JettyOSGiPDEPlugin.isProcessedAsOSGiProject(proj);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return JettyOSGiPDEPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static boolean isProcessedAsOSGiProject(IProject proj) {
        Map<String, String> headers;
        block6: {
            block5: {
                if (proj.isAccessible() && proj.hasNature(NATURE_PLUGIN)) break block5;
                return false;
            }
            IFile man = proj.getFile((IPath)new Path("META-INF/MANIFEST.MF"));
            headers = NaiveJavaProjectToWebappIdentifier.parseManifest(man);
            if (headers != null) break block6;
            return false;
        }
        try {
            String forceToJavaProj = headers.get(HEADER_DEPLOY_AS_JAVA_PROJECT);
            return forceToJavaProj == null || !"true".equals(forceToJavaProj.trim());
        }
        catch (CoreException coreException) {
        }
        catch (Throwable throwable) {}
        return false;
    }
}

