/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.pde.launch.ui;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jetty.osgi.pde.launch.internal.JettyHomeHelper;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.pde.launching.EquinoxLaunchConfiguration;

public class JettyEquinoxLaunchConfiguration
extends EquinoxLaunchConfiguration {
    public static final String ID = "org.eclipse.jetty.osgi.pde.launch.ui.jettyosgilaunch";

    protected void preLaunchCheck(ILaunchConfiguration configuration, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (!configuration.getAttribute("clearws", false)) {
            super.preLaunchCheck(configuration, launch, monitor);
            File jettyHome = this.resolveJettyHome(configuration);
            if (!(jettyHome == null || jettyHome.exists() && new File(jettyHome, "etc").exists())) {
                try {
                    JettyHomeHelper.setupJettyHomeAndJettyXML(null, jettyHome, true);
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.jetty.osgi.pde.launch", "Unable to setup jettyhome", (Throwable)e));
                }
            }
            return;
        }
        String jettyHomePath = this.resolveJettyHome(configuration).getAbsolutePath();
        String jettyXml = JettyHomeHelper.getCurrentJettyXml(jettyHomePath, true);
        super.preLaunchCheck(configuration, launch, monitor);
        try {
            JettyHomeHelper.setupJettyHomeAndJettyXML(jettyXml, jettyHomePath, true);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jetty.osgi.pde.launch", "Unable to setup jettyhome", (Throwable)e));
        }
    }

    public String[] getVMArguments(ILaunchConfiguration configuration) throws CoreException {
        String[] args = super.getVMArguments(configuration);
        String javaProjectsAsWebapps = configuration.getAttribute("javaProjectsToRunAsWebapps", "");
        if (javaProjectsAsWebapps.length() != 0) {
            String[] newArgs = new String[args.length + 1];
            System.arraycopy(args, 0, newArgs, 0, args.length);
            newArgs[args.length] = "-Djetty.jdtwebapps=\"" + javaProjectsAsWebapps + "\"";
            args = newArgs;
            boolean foundOsgiInstanceArea = false;
            String[] stringArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                if (arg.equals("osgi.instance.area")) {
                    foundOsgiInstanceArea = true;
                    break;
                }
                ++n2;
            }
            if (!foundOsgiInstanceArea) {
                Location loc = Platform.getInstanceLocation();
                URL wkLoc = loc.getURL();
                String workspace = wkLoc.getPath();
                if (workspace.startsWith("file:/")) {
                    workspace = workspace.substring("file:".length());
                }
                if (workspace.startsWith("///")) {
                    workspace = workspace.substring(2);
                }
                newArgs = new String[args.length + 1];
                System.arraycopy(args, 0, newArgs, 0, args.length);
                newArgs[args.length] = "-Dosgi.instance.area=" + URIUtil.encodePath((String)workspace);
                args = newArgs;
            }
        }
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (arg.startsWith("-Djetty.home=")) {
                return args;
            }
            ++i;
        }
        String jettyHomePath = configuration.getAttribute("org.eclipse.jetty.osgi.pde.launch.jettyhome", "");
        File jettyHome = this.resolveJettyHome(configuration);
        if (jettyHome == null || !jettyHome.exists()) {
            System.err.println("could not resolve jettyhome; " + jettyHomePath + " -> " + jettyHome);
            return args;
        }
        String[] newArgs = new String[args.length + 1];
        System.arraycopy(args, 0, newArgs, 0, args.length);
        newArgs[args.length] = "-Djetty.home=\"" + jettyHome.getAbsolutePath() + "\"";
        return newArgs;
    }

    public String[] getProgramArguments(ILaunchConfiguration configuration) throws CoreException {
        return super.getProgramArguments(configuration);
    }

    private File resolveJettyHome(ILaunchConfiguration configuration) throws CoreException {
        String jettyHomePath = configuration.getAttribute("org.eclipse.jetty.osgi.pde.launch.jettyhome", "");
        if (jettyHomePath == null || jettyHomePath.length() == 0) {
            File configArea = super.getConfigDir(configuration);
            return new File(configArea, "jettyhome");
        }
        return JettyHomeHelper.resolveJettyHome(jettyHomePath);
    }
}

