/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.pde.launch.ui;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.launching.launcher.BundleLauncherHelper;
import org.eclipse.pde.internal.launching.launcher.EquinoxInitializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JettyOSGiLaunchConfigurationInitializer
extends EquinoxInitializer {
    private static final Set<String> BUNDLE_DEPENDENCIES = new HashSet<String>();
    private static final Set<String> BLACKLISTED = new HashSet<String>();
    private static final Set<String> JDT_HEADLESS_DEPENDENCIES = new HashSet<String>();
    private static final Set<String> ALL_BUNDLE_DEPS = new HashSet<String>();
    private static final Set<String> LOGBACK_PACKAGE = new HashSet<String>();
    private static final Set<String> LOG_IMPL_PACKAGES_ON_SLF4J = new HashSet<String>();
    private static final Set<String> PACKAGES_DEPENDENCIES = new HashSet<String>();
    private static final String JETTY_BUNDLES_PREFIX = "org.eclipse.jetty.";

    static {
        BUNDLE_DEPENDENCIES.add("javax.servlet");
        BUNDLE_DEPENDENCIES.add("org.eclipse.osgi");
        BUNDLE_DEPENDENCIES.add("org.eclipse.osgi.services");
        BUNDLE_DEPENDENCIES.add("org.objectweb.asm");
        BUNDLE_DEPENDENCIES.add("javax.el");
        BUNDLE_DEPENDENCIES.add("javax.servlet.jsp");
        BUNDLE_DEPENDENCIES.add("javax.servlet.jsp.jstl");
        BUNDLE_DEPENDENCIES.add("javax.mail.glassfish");
        BUNDLE_DEPENDENCIES.add("javax.activation");
        BUNDLE_DEPENDENCIES.add("javax.transaction");
        BUNDLE_DEPENDENCIES.add("com.sun.el");
        BUNDLE_DEPENDENCIES.add("org.apache.jasper.glassfish");
        BUNDLE_DEPENDENCIES.add("org.apache.taglibs.standard.glassfish");
        BLACKLISTED.add("org.eclipse.emf.teneo.hibernate.libraries");
        BUNDLE_DEPENDENCIES.add("org.eclipse.equinox.http.servlet");
        PACKAGES_DEPENDENCIES.add("org.slf4j");
        PACKAGES_DEPENDENCIES.add("javax.mail");
        PACKAGES_DEPENDENCIES.add("javax.transaction");
        PACKAGES_DEPENDENCIES.add("javax.activation");
        JDT_HEADLESS_DEPENDENCIES.add("org.eclipse.core.commands");
        JDT_HEADLESS_DEPENDENCIES.add("org.eclipse.core.contenttype");
        JDT_HEADLESS_DEPENDENCIES.add("org.eclipse.core.expressions");
        JDT_HEADLESS_DEPENDENCIES.add("org.eclipse.core.filesystem");
        JDT_HEADLESS_DEPENDENCIES.add("org.eclipse.core.jobs");
        JDT_HEADLESS_DEPENDENCIES.add("org.eclipse.core.resources");
        JDT_HEADLESS_DEPENDENCIES.add("org.eclipse.core.runtime");
        JDT_HEADLESS_DEPENDENCIES.add("org.eclipse.core.variables");
        JDT_HEADLESS_DEPENDENCIES.add("org.eclipse.debug.core");
        JDT_HEADLESS_DEPENDENCIES.add("org.eclipse.equinox.app");
        JDT_HEADLESS_DEPENDENCIES.add("org.eclipse.equinox.common");
        JDT_HEADLESS_DEPENDENCIES.add("org.eclipse.equinox.preferences");
        JDT_HEADLESS_DEPENDENCIES.add("org.eclipse.equinox.registry");
        JDT_HEADLESS_DEPENDENCIES.add("org.eclipse.equinox.app");
        JDT_HEADLESS_DEPENDENCIES.add("org.eclipse.jdt.core");
        JDT_HEADLESS_DEPENDENCIES.add("org.eclipse.jdt.debug");
        JDT_HEADLESS_DEPENDENCIES.add("org.eclipse.jdt.launching");
        JDT_HEADLESS_DEPENDENCIES.add("org.eclipse.text");
        JDT_HEADLESS_DEPENDENCIES.add("com.ibm.icu");
        LOGBACK_PACKAGE.add("ch.qos.logback.core");
        LOGBACK_PACKAGE.add("ch.qos.logback.classic");
        LOG_IMPL_PACKAGES_ON_SLF4J.add("org.apache.commons.logging");
        LOG_IMPL_PACKAGES_ON_SLF4J.add("org.apache.log4j");
        LOG_IMPL_PACKAGES_ON_SLF4J.add("java.util.logging");
        PACKAGES_DEPENDENCIES.addAll(LOGBACK_PACKAGE);
        ALL_BUNDLE_DEPS.addAll(JDT_HEADLESS_DEPENDENCIES);
        ALL_BUNDLE_DEPS.addAll(BUNDLE_DEPENDENCIES);
    }

    public void initialize(ILaunchConfigurationWorkingCopy configuration) {
        super.initialize(configuration);
        try {
            StringBuffer buffer = new StringBuffer(configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, ""));
            boolean bufferWasChanged = false;
            if (buffer.length() > 0) {
                if (buffer.indexOf("-console ") == -1 && !buffer.toString().endsWith("-console")) {
                    buffer.append(" -console");
                    bufferWasChanged = true;
                }
            } else {
                buffer.append("-console");
                bufferWasChanged = true;
            }
            if (buffer.indexOf("-clean") == -1) {
                buffer.append(" -clean");
                bufferWasChanged = true;
            }
            if (bufferWasChanged) {
                configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, buffer.toString());
            }
        }
        catch (CoreException coreException) {}
    }

    protected void initializeBundleState(ILaunchConfigurationWorkingCopy configuration) {
        super.initializeBundleState(configuration);
        ArrayList<IPluginModelBase> bundlesInPlatform = new ArrayList<IPluginModelBase>();
        ArrayList<IPluginModelBase> bundlesInWorkspace = new ArrayList<IPluginModelBase>();
        this.selectBundles(bundlesInPlatform, bundlesInWorkspace);
        configuration.setAttribute("workspace_bundles", this.createBundleList(bundlesInWorkspace));
        configuration.setAttribute("target_bundles", this.createBundleList(bundlesInPlatform));
        configuration.setAttribute("automaticValidate", true);
        configuration.setAttribute("automaticAdd", true);
    }

    private String createBundleList(List<IPluginModelBase> bundlesInPlatform) {
        StringBuilder bundlesInPlatformString = new StringBuilder();
        String sep = "";
        for (IPluginModelBase bundleModel : bundlesInPlatform) {
            String id = bundleModel.getPluginBase().getId();
            bundlesInPlatformString.append(String.valueOf(sep) + BundleLauncherHelper.writeBundleEntry((IPluginModelBase)bundleModel, (String)this.getStartLevel(id), (String)this.getAutoStart(id)));
            sep = ",";
        }
        return bundlesInPlatformString.toString();
    }

    private void selectBundles(List<IPluginModelBase> bundlesInPlatformCollector, List<IPluginModelBase> bundlesInWorkspaceCollector) {
        IPluginModelBase[] iPluginModelBaseArray = PluginRegistry.getActiveModels();
        int n = iPluginModelBaseArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginModelBase pluginModel = iPluginModelBaseArray[n2];
            String symbName = pluginModel.getBundleDescription().getSymbolicName();
            if (!BLACKLISTED.contains(symbName)) {
                if (pluginModel.getUnderlyingResource() != null) {
                    try {
                        if (pluginModel.getUnderlyingResource().getProject().hasNature("org.eclipse.pde.PluginNature")) {
                            bundlesInWorkspaceCollector.add(pluginModel);
                        }
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                } else if (symbName.startsWith(JETTY_BUNDLES_PREFIX)) {
                    if (!symbName.startsWith("org.eclipse.jetty.osgi.pde")) {
                        bundlesInPlatformCollector.add(pluginModel);
                    }
                } else if (ALL_BUNDLE_DEPS.contains(symbName)) {
                    if (!symbName.equals("javax.servlet.jsp") || !pluginModel.getBundleDescription().getVersion().toString().startsWith("2.0")) {
                        bundlesInPlatformCollector.add(pluginModel);
                    }
                } else {
                    ExportPackageDescription[] exPacks = pluginModel.getBundleDescription().getExportPackages();
                    int j = 0;
                    while (j < exPacks.length) {
                        ExportPackageDescription xp = exPacks[j];
                        if (PACKAGES_DEPENDENCIES.contains(xp.getName())) {
                            bundlesInPlatformCollector.add(pluginModel);
                            xp.getName().equals("org.slf4j");
                            break;
                        }
                        if (LOG_IMPL_PACKAGES_ON_SLF4J.contains(xp.getName())) {
                            String prov;
                            if (pluginModel.getBundleDescription().getSymbolicName().toLowerCase().indexOf("slf4j") != -1 || pluginModel.getBundleDescription().getName().toLowerCase().indexOf("slf4j") != -1) {
                                bundlesInPlatformCollector.add(pluginModel);
                                break;
                            }
                            Map attrs = xp.getAttributes();
                            if (attrs != null && (prov = (String)attrs.get("provider")) != null && prov.indexOf("slf4j") != -1) {
                                bundlesInPlatformCollector.add(pluginModel);
                                break;
                            }
                        }
                        ++j;
                    }
                }
            }
            ++n2;
        }
    }

    protected String getAutoStart(String bundleID) {
        if (bundleID.equals("org.eclipse.jetty.osgi.boot") || bundleID.equals("org.eclipse.jetty.osgi.boot.warurl") || bundleID.equals("org.eclipse.jetty.osgi.boot.jdt")) {
            return Boolean.TRUE.toString();
        }
        return super.getAutoStart(bundleID);
    }
}

