/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.pde.launch.ui.tabs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jetty.osgi.pde.launch.JettyLauncherMessages;
import org.eclipse.jetty.osgi.pde.launch.JettyOSGiPDEPlugin;
import org.eclipse.jetty.osgi.pde.launch.internal.NaiveJavaProjectToWebappIdentifier;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class JavaProjectsAsWebappsBlock
extends AbstractLaunchConfigurationTab {
    private CheckboxTableViewer _javaProjectsViewer;
    private Map<IProject, NaiveJavaProjectToWebappIdentifier> _webappsInJavaProjects;
    private static final int COL_JAVA_PROJ_NAME = 0;
    private static final int COL_CONTEXT_PATH = 1;
    private static final int COL_WEBAPP_BASE_FOLDER = 2;

    public void createControl(Composite parent) {
        parent = SWTFactory.createComposite((Composite)parent, (int)1, (int)2, (int)1808);
        super.setControl((Control)parent);
        GridData gridData = new GridData(4, 4, true, true);
        parent.setLayoutData((Object)gridData);
        this._webappsInJavaProjects = new HashMap<IProject, NaiveJavaProjectToWebappIdentifier>();
        Group grp = SWTFactory.createGroup((Composite)parent, (String)JettyLauncherMessages.JavaProjectsAsWebappsBlock_Select_java_projects_to_run_as_webapps, (int)1, (int)1, (int)1808);
        gridData = new GridData(4, 4, true, true);
        grp.setLayoutData((Object)gridData);
        this._javaProjectsViewer = CheckboxTableViewer.newCheckList((Composite)grp, (int)2048);
        Table table = this._javaProjectsViewer.getTable();
        TableLayout layout = new TableLayout();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn tc0 = new TableColumn(table, 0, 0);
        TableColumn tc1 = new TableColumn(table, 0, 1);
        TableColumn tc2 = new TableColumn(table, 0, 2);
        tc0.setText(JettyLauncherMessages.JavaProjectsAsWebappsBlock_Column_JavaProject);
        tc1.setText(JettyLauncherMessages.JavaProjectsAsWebappsBlock_Column_ContextPath);
        tc2.setText(JettyLauncherMessages.JavaProjectsAsWebappsBlock_Column_WebappBaseFolder);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(28));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(12));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(60));
        table.setLayout((Layout)layout);
        this._javaProjectsViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this._javaProjectsViewer.setContentProvider((IContentProvider)new JavaProjectsOrWebBundlesContentProvider(true));
        this._javaProjectsViewer.setLabelProvider((IBaseLabelProvider)new JavaProjectsOrWebBundleLabelProvider());
        this._javaProjectsViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                JavaProjectsAsWebappsBlock.this.setDirty(true);
                JavaProjectsAsWebappsBlock.this.updateLaunchConfigurationDialog();
            }
        });
        this._javaProjectsViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        grp = SWTFactory.createGroup((Composite)parent, (String)JettyLauncherMessages.JavaProjectsAsWebappsBlock_List_webbundles, (int)1, (int)1, (int)1808);
        gridData = new GridData(4, 4, true, true);
        grp.setLayoutData((Object)gridData);
        TableViewer webBundles = new TableViewer((Composite)grp, 2048);
        table = webBundles.getTable();
        layout = new TableLayout();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        tc0 = new TableColumn(table, 0, 0);
        tc1 = new TableColumn(table, 0, 1);
        tc2 = new TableColumn(table, 0, 2);
        tc0.setText(JettyLauncherMessages.JavaProjectsAsWebappsBlock_Column_WebBundleProject);
        tc1.setText(JettyLauncherMessages.JavaProjectsAsWebappsBlock_Column_ContextPath);
        tc2.setText(JettyLauncherMessages.JavaProjectsAsWebappsBlock_Column_WebappBaseFolder);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(28));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(12));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(60));
        table.setLayout((Layout)layout);
        webBundles.setContentProvider((IContentProvider)new JavaProjectsOrWebBundlesContentProvider(false));
        webBundles.setLabelProvider((IBaseLabelProvider)new JavaProjectsOrWebBundleLabelProvider());
        webBundles.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        webBundles.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
    }

    public String getName() {
        return JettyLauncherMessages.JavaProjectsAsWebappsBlock_Section_title;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String selectedJavaProjects = configuration.getAttribute("javaProjectsToRunAsWebapps", "");
            if (selectedJavaProjects.length() == 0) {
                return;
            }
            String[] stringArray = selectedJavaProjects.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String javaProj = stringArray[n2];
                IProject proj = ResourcesPlugin.getWorkspace().getRoot().getProject(javaProj);
                if (JettyOSGiPDEPlugin.isJavaProjectButNotAPlugin(proj)) {
                    this._javaProjectsViewer.setChecked((Object)proj, true);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        StringBuilder sb = new StringBuilder();
        Object[] objectArray = this._javaProjectsViewer.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object p = objectArray[n2];
            if (sb.length() != 0) {
                sb.append(",");
            }
            sb.append(((IProject)p).getName());
            ++n2;
        }
        configuration.setAttribute("javaProjectsToRunAsWebapps", sb.toString());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    class JavaProjectsOrWebBundleLabelProvider
    implements ITableLabelProvider {
        JavaProjectsOrWebBundleLabelProvider() {
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void dispose() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public String getColumnText(Object element, int columnIndex) {
            switch (columnIndex) {
                case 1: {
                    NaiveJavaProjectToWebappIdentifier p = (NaiveJavaProjectToWebappIdentifier)JavaProjectsAsWebappsBlock.this._webappsInJavaProjects.get((IProject)element);
                    if (p == null || p.getContextPath() == null) {
                        return "none";
                    }
                    return p.getContextPath();
                }
                case 2: {
                    IProject proj = (IProject)element;
                    NaiveJavaProjectToWebappIdentifier p = (NaiveJavaProjectToWebappIdentifier)JavaProjectsAsWebappsBlock.this._webappsInJavaProjects.get(proj);
                    if (p == null || p.getWebappBaseFolderPath() == null) {
                        List<String> contexts = p.getJettyContextFiles();
                        if (contexts != null) {
                            StringBuilder sb = new StringBuilder();
                            for (String c : contexts) {
                                if (sb.length() != 0) {
                                    sb.append(", ");
                                }
                                sb.append(c);
                            }
                            return "Jetty-Context-Files: " + sb.toString();
                        }
                        return "none";
                    }
                    if (p.getWebappBaseFolderPathRelativeToFolder() != null) {
                        String relPath = p.getWebappBaseFolderPathRelativeToFolder();
                        if (relPath.startsWith("/")) {
                            relPath = relPath.substring(1);
                        }
                        return "${workspace_loc:" + proj.getName() + "}/" + relPath;
                    }
                    return p.getWebappBaseFolderPath();
                }
            }
            return ((IProject)element).getName();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }

    class JavaProjectsOrWebBundlesContentProvider
    implements IStructuredContentProvider {
        private final boolean _lookJavaProj;

        JavaProjectsOrWebBundlesContentProvider(boolean lookJavaProj) {
            this._lookJavaProj = lookJavaProj;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (!(inputElement instanceof IWorkspaceRoot)) {
                throw new IllegalArgumentException("Expecting an IWorkspaceRoot. This is not expected " + inputElement);
            }
            ArrayList<IProject> children = new ArrayList<IProject>();
            IWorkspaceRoot root = (IWorkspaceRoot)inputElement;
            IProject[] iProjectArray = root.getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                NaiveJavaProjectToWebappIdentifier app;
                IJavaProject javaProj;
                IProject proj = iProjectArray[n2];
                if (this._lookJavaProj) {
                    if (JettyOSGiPDEPlugin.isJavaProjectButNotAPlugin(proj)) {
                        try {
                            javaProj = JavaCore.create((IProject)proj);
                            app = new NaiveJavaProjectToWebappIdentifier(javaProj, false);
                            JavaProjectsAsWebappsBlock.this._webappsInJavaProjects.put(proj, app);
                            if (app.hasWebapp()) {
                                children.add(proj);
                            }
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                    }
                } else {
                    try {
                        if (JettyOSGiPDEPlugin.isProcessedAsOSGiProject(proj) && (app = new NaiveJavaProjectToWebappIdentifier(javaProj = JavaCore.create((IProject)proj), true)).hasOSGiWebBundleData()) {
                            JavaProjectsAsWebappsBlock.this._webappsInJavaProjects.put(proj, app);
                            children.add(proj);
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
                ++n2;
            }
            return children.toArray();
        }
    }
}

