/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.pde.launch.ui.tabs;

import java.io.File;
import org.eclipse.jetty.osgi.pde.launch.JettyLauncherMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class JettyXmlEditDialog
extends Dialog {
    protected Text _textField;
    private Button _okButton;
    private Label _statusLabel;
    private boolean _isDirty = false;
    private String _lastValidatedString;
    private String _jettyHome;

    public JettyXmlEditDialog(Shell parentShell, String currentJettyXml) {
        super(parentShell);
        this.setShellStyle(0x4F0 | JettyXmlEditDialog.getDefaultOrientation() | 0x10);
        this.setBlockOnOpen(true);
        this._lastValidatedString = currentJettyXml;
    }

    public Button getGoForItButton() {
        return this._okButton;
    }

    protected String getNewJettyXml() {
        return this._isDirty ? this._lastValidatedString : null;
    }

    protected void validateInput() {
        String text = this._textField.getText();
        if (text.equals(this._lastValidatedString)) {
            return;
        }
        this._isDirty = true;
        this._lastValidatedString = text;
        Button ok = this.getGoForItButton();
        ok.setEnabled(true);
    }

    protected void configureShell(Shell newShell, String jettyHome) {
        super.configureShell(newShell);
        this._jettyHome = jettyHome;
        newShell.setText(JettyLauncherMessages.JettyXmlEditDialog_Edit_jetty_xml_title);
        newShell.setSize(600, 400);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 0);
        String msg = JettyLauncherMessages.bind((String)JettyLauncherMessages.JettyXmlEditDialog_Edit_jetty_xml, (Object)(String.valueOf(this._jettyHome) + File.separatorChar + "etc" + File.separatorChar + "jetty.xml"));
        label.setText(msg);
        this._textField = new Text(composite, 2818);
        this._textField.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                JettyXmlEditDialog.this.validateInput();
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        if (this._lastValidatedString != null) {
            this._textField.setText(this._lastValidatedString);
        }
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this._textField.setLayoutData((Object)gridData);
        this._statusLabel = new Label(composite, 0);
        this._statusLabel.setText(" ");
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this._statusLabel.setLayoutData((Object)gridData);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, JettyLauncherMessages.JettyXmlEditDialog_Cancel, false);
        this._okButton = this.createButton(parent, 0, JettyLauncherMessages.JettyXmlEditDialog_OK, true);
        this._okButton.setEnabled(false);
        this.validateInput();
    }
}

