/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.boot.internal.webapp;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jetty.osgi.boot.JettyBootstrapActivator;
import org.eclipse.jetty.osgi.boot.internal.webapp.WebappRegistrationHelper;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.Scanner;
import org.eclipse.jetty.webapp.WebAppContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class JettyContextHandlerServiceTracker
implements ServiceListener {
    private final WebappRegistrationHelper _helper;
    private Map<ServiceReference, ContextHandler> _indexByServiceReference = new HashMap<ServiceReference, ContextHandler>();
    private Map<String, ServiceReference> _indexByContextFile = new HashMap<String, ServiceReference>();
    private String _osgiContextHomeFolderCanonicalPath;
    private Scanner _scanner;

    public JettyContextHandlerServiceTracker(BundleContext context, Server server) throws Exception {
        this._helper = new WebappRegistrationHelper(server);
        this._helper.setup(context, new HashMap<String, String>());
        File contextHome = this._helper.getOSGiContextsHome();
        if (contextHome != null) {
            this._osgiContextHomeFolderCanonicalPath = contextHome.getCanonicalPath();
            this._scanner = new Scanner();
            this._scanner.setRecursive(true);
            this._scanner.setReportExistingFilesOnStartup(false);
            this._scanner.addListener((Scanner.Listener)new Scanner.DiscreteListener(){

                public void fileAdded(String filename) throws Exception {
                    JettyContextHandlerServiceTracker.this.reloadJettyContextHandler(filename);
                }

                public void fileChanged(String filename) throws Exception {
                    JettyContextHandlerServiceTracker.this.reloadJettyContextHandler(filename);
                }

                public void fileRemoved(String filename) throws Exception {
                    JettyContextHandlerServiceTracker.this.reloadJettyContextHandler(filename);
                }
            });
        }
    }

    public void stop() {
        if (this._scanner != null) {
            this._scanner.stop();
        }
    }

    public void serviceChanged(ServiceEvent ev) {
        ServiceReference sr = ev.getServiceReference();
        switch (ev.getType()) {
            case 2: 
            case 4: {
                ContextHandler ctxtHandler = this.unregisterInIndex(ev.getServiceReference());
                if (ctxtHandler != null && !ctxtHandler.isStopped()) {
                    try {
                        this._helper.unregister(ctxtHandler);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (ev.getType() == 4) break;
            }
            case 1: {
                Bundle contributor = sr.getBundle();
                BundleContext context = FrameworkUtil.getBundle(JettyBootstrapActivator.class).getBundleContext();
                ContextHandler contextHandler = (ContextHandler)context.getService(sr);
                if (contextHandler.getServer() != null) {
                    return;
                }
                if (contextHandler instanceof WebAppContext) {
                    String defaultWebXmlPath;
                    String webXmlPath;
                    WebAppContext webapp = (WebAppContext)contextHandler;
                    String contextPath = (String)sr.getProperty("contextPath");
                    if (contextPath == null) {
                        contextPath = webapp.getContextPath();
                    }
                    if ((webXmlPath = (String)sr.getProperty("webXmlFilePath")) == null) {
                        webXmlPath = webapp.getDescriptor();
                    }
                    if ((defaultWebXmlPath = (String)sr.getProperty("defaultWebXmlFilePath")) == null) {
                        defaultWebXmlPath = webapp.getDefaultsDescriptor();
                    }
                    String war = (String)sr.getProperty("war");
                    try {
                        ContextHandler handler = this._helper.registerWebapplication(contributor, war, contextPath, (String)sr.getProperty("extraClasspath"), (String)sr.getProperty("thisBundleInstall"), webXmlPath, defaultWebXmlPath);
                        if (handler == null) break;
                        this.registerInIndex(handler, sr);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    break;
                }
                String contextFilePath = (String)sr.getProperty("contextFilePath");
                if (contextFilePath == null) {
                    throw new IllegalArgumentException("the property contextFilePath is required");
                }
                try {
                    ContextHandler handler = this._helper.registerContext(contributor, contextFilePath, (String)sr.getProperty("extraClasspath"), (String)sr.getProperty("thisBundleInstall"));
                    if (handler == null) break;
                    this.registerInIndex(handler, sr);
                    break;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void registerInIndex(ContextHandler handler, ServiceReference sr) {
        this._indexByServiceReference.put(sr, handler);
        String key = this.getSymbolicNameAndContextFileKey(sr);
        if (key != null) {
            this._indexByContextFile.put(key, sr);
        }
    }

    private ContextHandler unregisterInIndex(ServiceReference sr) {
        ContextHandler handler = this._indexByServiceReference.remove(sr);
        String key = this.getSymbolicNameAndContextFileKey(sr);
        if (key != null) {
            this._indexByContextFile.remove(key);
        }
        if (handler == null) {
            return null;
        }
        return handler;
    }

    private String getSymbolicNameAndContextFileKey(ServiceReference sr) {
        String contextFilePath = (String)sr.getProperty("contextFilePath");
        if (contextFilePath != null) {
            return sr.getBundle().getSymbolicName() + "/" + contextFilePath;
        }
        return null;
    }

    void reloadJettyContextHandler(String canonicalNameOfFileChanged) {
        String key = this.getNormalizedRelativePath(canonicalNameOfFileChanged);
        if (key == null) {
            return;
        }
        ServiceReference sr = this._indexByContextFile.get(key);
        if (sr == null) {
            return;
        }
        this.serviceChanged(new ServiceEvent(2, sr));
    }

    private String getNormalizedRelativePath(String canFilename) {
        if (!canFilename.startsWith(this._osgiContextHomeFolderCanonicalPath)) {
            return null;
        }
        return canFilename.substring(this._osgiContextHomeFolderCanonicalPath.length()).replace('\\', '/');
    }
}

