/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.pde.launch.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.osgi.framework.Bundle;

public class JettyHomeHelper {
    private static Bundle getJettyOSGiBootBundle() {
        return Platform.getBundle((String)"org.eclipse.jetty.osgi.boot");
    }

    private static String resolveVariables(String target) {
        IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
        try {
            return manager.performStringSubstitution(target, false);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public static IContainer getContainerFromWorkspace(String path) {
        IResource res;
        if (path == null || path.trim().length() == 0) {
            return null;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        if (path.startsWith("${workspace_loc:")) {
            path = JettyHomeHelper.resolveVariables(path);
            return root.getContainerForLocation(new Path(path).makeAbsolute());
        }
        if (path.startsWith("${workspace_loc}")) {
            path = path.substring("${workspace_loc}".length());
            IFolder f = root.getFolder(new Path(path = JettyHomeHelper.resolveVariables(path)).makeAbsolute());
            if (f.getRawLocation() == null) {
                IContainer c = root.getContainerForLocation(new Path(path).makeAbsolute());
                if (c != null) {
                    return c;
                }
                return null;
            }
        }
        if ((res = root.findMember(path)) instanceof IContainer) {
            return (IContainer)res;
        }
        return null;
    }

    public static File getFileOutsideOfWorkspace(String path) {
        if (path == null || path.trim().length() == 0) {
            return null;
        }
        return new File(JettyHomeHelper.resolveVariables(path));
    }

    public static String getCurrentJettyXml(String jettyHomePath, boolean returnNullIfJettyXmlIsNull) {
        IContainer container = JettyHomeHelper.getContainerFromWorkspace(jettyHomePath);
        if (container != null) {
            IFile jettyXml = container.getFile((IPath)new Path("jettyhome/etc/jetty.xml"));
            if (!jettyXml.exists()) {
                return returnNullIfJettyXmlIsNull ? null : JettyHomeHelper.getJettyXmlInsideBootBundle();
            }
            return JettyHomeHelper.loadIFileAsString(jettyXml);
        }
        File configArea = JettyHomeHelper.getFileOutsideOfWorkspace(jettyHomePath);
        File jettyXml = new File(configArea, "jettyhome/etc/jetty.xml");
        if (jettyXml.exists()) {
            return JettyHomeHelper.loadFileAsString(jettyXml);
        }
        return returnNullIfJettyXmlIsNull ? null : JettyHomeHelper.getJettyXmlInsideBootBundle();
    }

    public static String getJettyXmlInsideBootBundle() {
        Bundle b = JettyHomeHelper.getJettyOSGiBootBundle();
        try {
            InputStream is = b.getEntry("/jettyhome/etc/jetty.xml").openStream();
            return JettyHomeHelper.loadInputAsString(is);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String loadFileAsString(File jettyXml) {
        try {
            return JettyHomeHelper.loadInputAsString(new FileInputStream(jettyXml));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String loadIFileAsString(IFile jettyXml) {
        try {
            return JettyHomeHelper.loadInputAsString(jettyXml.getContents());
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String loadInputAsString(InputStream is) {
        StringBuilder sb;
        block12: {
            sb = new StringBuilder();
            try {
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                    String newline = System.getProperty("line.separator");
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        sb.append(String.valueOf(line) + newline);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        is.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return sb.toString();
    }

    public static File resolveJettyHome(String jettyHomeInConfig) {
        URI rawURI;
        IContainer container = JettyHomeHelper.getContainerFromWorkspace(jettyHomeInConfig);
        if (container != null && (rawURI = container.getRawLocationURI()) != null) {
            return new File(rawURI);
        }
        return JettyHomeHelper.getFileOutsideOfWorkspace(jettyHomeInConfig);
    }

    public static void setupJettyHomeAndJettyXML(String jettyXml, String jettyHomePath, boolean doNothingIfJettyHomeExists) throws IOException {
        File jettyhome = JettyHomeHelper.resolveJettyHome(jettyHomePath);
        if (jettyhome == null) {
            throw new IllegalArgumentException("Unable to resolve jettyhome " + jettyHomePath);
        }
        JettyHomeHelper.setupJettyHomeAndJettyXML(jettyXml, jettyhome, doNothingIfJettyHomeExists);
    }

    public static void setupJettyHomeAndJettyXML(String jettyXml, File jettyhome, boolean doNothingIfJettyHomeExists) throws IOException {
        if (!jettyhome.exists() || !new File(jettyhome, "etc").exists()) {
            JettyHomeHelper.installDefaultJettyHome(jettyhome);
        } else if (doNothingIfJettyHomeExists) {
            return;
        }
        File jettyXmlFile = new File(jettyhome, "etc/jetty.xml");
        if (!jettyXmlFile.exists()) {
            throw new IllegalArgumentException("The jetty configuration file must exist: '" + jettyXmlFile.getAbsolutePath());
        }
        if (jettyXml != null) {
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(jettyXmlFile);
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, "UTF-8");
                writer.append(jettyXml);
            }
            catch (Throwable throwable) {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void installDefaultJettyHome(File jettyhomeFolder) throws IOException {
        jettyhomeFolder.mkdirs();
        Bundle bootBundle = JettyHomeHelper.getJettyOSGiBootBundle();
        File bootBundleFile = FileLocator.getBundleFile((Bundle)bootBundle);
        if (bootBundleFile.getName().endsWith(".jar")) {
            JettyHomeHelper.unzipJettyHomeIntoDirectory(bootBundleFile, jettyhomeFolder.getParentFile());
        } else {
            JettyHomeHelper.copyDirectory(new File(bootBundleFile, "jettyhome"), jettyhomeFolder);
        }
    }

    private static void unzipJettyHomeIntoDirectory(File thisbundlejar, File parentOfMagicJettyHome) throws IOException {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(thisbundlejar);
            Enumeration<? extends ZipEntry> files = zipFile.entries();
            File f = null;
            FileOutputStream fos = null;
            while (files.hasMoreElements()) {
                ZipEntry entry;
                block26: {
                    entry = files.nextElement();
                    String entryName = entry.getName();
                    if (entryName.startsWith("jettyhome")) break block26;
                    if (fos == null) continue;
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                    fos = null;
                    continue;
                }
                try {
                    try {
                        InputStream eis = zipFile.getInputStream(entry);
                        byte[] buffer = new byte[1024];
                        int bytesRead = 0;
                        f = new File(parentOfMagicJettyHome, entry.getName());
                        if (entry.isDirectory()) {
                            f.mkdirs();
                        } else {
                            f.getParentFile().mkdirs();
                            f.createNewFile();
                            fos = new FileOutputStream(f);
                            while ((bytesRead = eis.read(buffer)) != -1) {
                                fos.write(buffer, 0, bytesRead);
                            }
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        if (fos == null) continue;
                        try {
                            fos.close();
                        }
                        catch (IOException iOException) {}
                        fos = null;
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException iOException) {}
                        fos = null;
                    }
                    throw throwable;
                }
                if (fos == null) continue;
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
                fos = null;
            }
        }
        catch (Throwable throwable) {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (Throwable throwable2) {}
            }
            throw throwable;
        }
        if (zipFile != null) {
            try {
                zipFile.close();
            }
            catch (Throwable throwable) {}
        }
    }

    private static void copyDirectory(File sourceFile, File destFile) throws IOException {
        if (sourceFile.isDirectory()) {
            if (!destFile.exists()) {
                destFile.mkdir();
            }
            String[] files = sourceFile.list();
            int i = 0;
            while (i < files.length) {
                JettyHomeHelper.copyDirectory(new File(sourceFile, files[i]), new File(destFile, files[i]));
                ++i;
            }
        } else if (sourceFile.exists()) {
            JettyHomeHelper.copyFile(sourceFile, destFile);
        }
    }

    private static void copyFile(File sourceFile, File destFile) throws IOException {
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }
}

