/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.pde.launch.ui;

import java.lang.reflect.Field;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTabGroup;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jetty.osgi.pde.launch.ui.IConfigurationAreaSettingHolder;
import org.eclipse.jetty.osgi.pde.launch.ui.JettyOSGiLaunchConfigurationInitializer;
import org.eclipse.jetty.osgi.pde.launch.ui.tabs.JettyBundlesTab;
import org.eclipse.jetty.osgi.pde.launch.ui.tabs.JettyConfigurationLaunchTab;
import org.eclipse.pde.ui.launcher.BundlesTab;
import org.eclipse.pde.ui.launcher.OSGiLauncherTabGroup;
import org.eclipse.pde.ui.launcher.OSGiSettingsTab;

public class JettyOSGiLauncherTabGroup
extends AbstractLaunchConfigurationTabGroup
implements IConfigurationAreaSettingHolder {
    private static Field fConfigurationBlock;
    private static Field fLastEnteredConfigArea;

    public void createTabs(ILaunchConfigurationDialog dialog, String mode) {
        ILaunchConfigurationTab[] tabs = this.createOSGiLaunchTabs(dialog, mode);
        ILaunchConfigurationTab[] newtabs = new ILaunchConfigurationTab[tabs.length + 1];
        newtabs[0] = new JettyConfigurationLaunchTab(this);
        System.arraycopy(tabs, 0, newtabs, 1, tabs.length);
        super.setTabs(newtabs);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        super.setDefaults(configuration);
        JettyOSGiLaunchConfigurationInitializer confInitializer = new JettyOSGiLaunchConfigurationInitializer();
        confInitializer.initialize(configuration);
    }

    private ILaunchConfigurationTab[] createOSGiLaunchTabs(ILaunchConfigurationDialog dialog, String mode) {
        OSGiLauncherTabGroup osgiTabsFactory = new OSGiLauncherTabGroup();
        osgiTabsFactory.createTabs(dialog, mode);
        ILaunchConfigurationTab[] tabs = osgiTabsFactory.getTabs();
        int i = 0;
        while (i < tabs.length) {
            if (tabs[i] instanceof BundlesTab) {
                tabs[i] = new JettyBundlesTab();
            }
            ++i;
        }
        return tabs;
    }

    public String getConfigurationAreaLocation() {
        OSGiSettingsTab settingsTab = null;
        ILaunchConfigurationTab[] iLaunchConfigurationTabArray = this.getTabs();
        int n = iLaunchConfigurationTabArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfigurationTab t = iLaunchConfigurationTabArray[n2];
            if (t instanceof OSGiSettingsTab) {
                settingsTab = (OSGiSettingsTab)t;
                break;
            }
            ++n2;
        }
        if (settingsTab == null) {
            return null;
        }
        return JettyOSGiLauncherTabGroup.getfLastEnteredConfigArea(JettyOSGiLauncherTabGroup.getfConfigurationBlock(settingsTab));
    }

    private static synchronized Object getfConfigurationBlock(OSGiSettingsTab settingsTab) {
        try {
            if (fConfigurationBlock == null) {
                fConfigurationBlock = OSGiSettingsTab.class.getDeclaredField("fConfigurationBlock");
                fConfigurationBlock.setAccessible(true);
            }
            return fConfigurationBlock.get(settingsTab);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    private static synchronized String getfLastEnteredConfigArea(Object configurationBlock) {
        try {
            if (fLastEnteredConfigArea == null) {
                fLastEnteredConfigArea = configurationBlock.getClass().getDeclaredField("fLastEnteredConfigArea");
                fLastEnteredConfigArea.setAccessible(true);
            }
            return (String)fLastEnteredConfigArea.get(configurationBlock);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }
}

