/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.annotations;

import java.util.List;
import org.eclipse.jetty.annotations.AnnotationParser;
import org.eclipse.jetty.plus.annotation.RunAs;
import org.eclipse.jetty.plus.annotation.RunAsCollection;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.webapp.WebAppContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunAsAnnotationHandler
implements AnnotationParser.AnnotationHandler {
    protected WebAppContext _wac;

    public RunAsAnnotationHandler(WebAppContext wac) {
        this._wac = wac;
    }

    @Override
    public void handleClass(String className, int version, int access, String signature, String superName, String[] interfaces, String annotation, List<AnnotationParser.Value> values) {
        RunAsCollection runAsCollection = (RunAsCollection)this._wac.getAttribute("org.eclipse.jetty.runAsCollection");
        try {
            if (values != null && values.size() == 1) {
                String role = (String)values.get(0).getValue();
                if (role != null) {
                    RunAs ra = new RunAs();
                    ra.setTargetClassName(className);
                    ra.setRoleName(role);
                    runAsCollection.add(ra);
                }
            } else {
                Log.warn((String)("Bad value for @RunAs annotation on class " + className));
            }
        }
        catch (Exception e) {
            Log.warn((Throwable)e);
        }
    }

    @Override
    public void handleField(String className, String fieldName, int access, String fieldType, String signature, Object value, String annotation, List<AnnotationParser.Value> values) {
        Log.warn((String)("@RunAs annotation not applicable for fields: " + className + "." + fieldName));
    }

    @Override
    public void handleMethod(String className, String methodName, int access, String params, String signature, String[] exceptions, String annotation, List<AnnotationParser.Value> values) {
        Log.warn((String)("@RunAs annotation ignored on method: " + className + "." + methodName + " " + signature));
    }
}

