/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.security.Authentication;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpHeaderValues;
import org.eclipse.jetty.http.HttpHeaders;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.http.HttpVersions;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.AsyncEndPoint;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.Buffers;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.View;
import org.eclipse.jetty.io.nio.SslSelectChannelEndPoint;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.thread.Timeout;

public class HttpConnection
extends AbstractConnection {
    private HttpDestination _destination;
    private HttpGenerator _generator;
    private HttpParser _parser;
    private boolean _http11 = true;
    private int _status;
    private Buffer _connectionHeader;
    private Buffer _requestContentChunk;
    private boolean _requestComplete;
    private boolean _reserved;
    private volatile HttpExchange _exchange;
    private HttpExchange _pipeline;
    private final Timeout.Task _timeout = new TimeoutTask();
    private AtomicBoolean _idle = new AtomicBoolean(false);

    public void dump() throws IOException {
        Log.info((String)("endp=" + this._endp + " " + this._endp.isBufferingInput() + " " + this._endp.isBufferingOutput()));
        Log.info((String)("generator=" + this._generator));
        Log.info((String)("parser=" + this._parser.getState() + " " + this._parser.isMoreInBuffer()));
        Log.info((String)("exchange=" + this._exchange));
        if (this._endp instanceof SslSelectChannelEndPoint) {
            ((SslSelectChannelEndPoint)this._endp).dump();
        }
    }

    HttpConnection(Buffers requestBuffers, Buffers responseBuffers, EndPoint endp) {
        super(endp);
        this._generator = new HttpGenerator(requestBuffers, endp);
        this._parser = new HttpParser(responseBuffers, endp, (HttpParser.EventHandler)new Handler());
    }

    public void setReserved(boolean reserved) {
        this._reserved = reserved;
    }

    public boolean isReserved() {
        return this._reserved;
    }

    public HttpDestination getDestination() {
        return this._destination;
    }

    public void setDestination(HttpDestination destination) {
        this._destination = destination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean send(HttpExchange ex) throws IOException {
        HttpConnection httpConnection = this;
        synchronized (httpConnection) {
            if (this._exchange != null) {
                if (this._pipeline != null) {
                    throw new IllegalStateException((Object)((Object)this) + " PIPELINED!!!  _exchange=" + this._exchange);
                }
                this._pipeline = ex;
                return true;
            }
            if (!this._endp.isOpen()) {
                return false;
            }
            this._exchange = ex;
            this._exchange.setStatus(2);
            if (this._endp.isBlocking()) {
                ((Object)((Object)this)).notify();
            } else {
                AsyncEndPoint scep = (AsyncEndPoint)this._endp;
                scep.scheduleWrite();
            }
            long exchTimeout = this._exchange.getTimeout();
            if (exchTimeout > 0L) {
                if (exchTimeout != this._destination.getHttpClient().getTimeout()) {
                    this._endp.setMaxIdleTime((int)exchTimeout);
                }
                this._destination.getHttpClient().schedule(this._timeout, exchTimeout);
            } else {
                this._destination.getHttpClient().schedule(this._timeout);
            }
            return true;
        }
    }

    /*
     * Exception decompiling
     */
    public Connection handle() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Missing node tying up JSR block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.tieUpRelations(Op02WithProcessedDataAndRefs.java:2900)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.copyBlock(Op02WithProcessedDataAndRefs.java:2889)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.inlineJSR(Op02WithProcessedDataAndRefs.java:2845)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSRs(Op02WithProcessedDataAndRefs.java:2591)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSR(Op02WithProcessedDataAndRefs.java:2481)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:444)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isIdle() {
        HttpConnection httpConnection = this;
        synchronized (httpConnection) {
            return this._exchange == null;
        }
    }

    public boolean isSuspended() {
        return false;
    }

    public void closed() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitRequest() throws IOException {
        HttpConnection httpConnection = this;
        synchronized (httpConnection) {
            Buffer requestContent;
            this._status = 0;
            if (this._exchange.getStatus() != 2) {
                throw new IllegalStateException();
            }
            this._exchange.setStatus(3);
            this._generator.setVersion(this._exchange.getVersion());
            String method = this._exchange.getMethod();
            String uri = this._exchange.getURI();
            if (this._destination.isProxied() && !"CONNECT".equals(method) && uri.startsWith("/")) {
                boolean secure = this._destination.isSecure();
                String host = this._destination.getAddress().getHost();
                int port = this._destination.getAddress().getPort();
                StringBuilder absoluteURI = new StringBuilder();
                absoluteURI.append(secure ? "https" : "http");
                absoluteURI.append("://");
                absoluteURI.append(host);
                if (!(secure && port == 443 || !secure && port == 80)) {
                    absoluteURI.append(":").append(port);
                }
                absoluteURI.append(uri);
                uri = absoluteURI.toString();
                Authentication auth = this._destination.getProxyAuthentication();
                if (auth != null) {
                    auth.setCredentials(this._exchange);
                }
            }
            this._generator.setRequest(method, uri);
            this._parser.setHeadResponse("HEAD".equalsIgnoreCase(method));
            HttpFields requestHeaders = this._exchange.getRequestFields();
            if (this._exchange.getVersion() >= 11 && !requestHeaders.containsKey(HttpHeaders.HOST_BUFFER)) {
                requestHeaders.add(HttpHeaders.HOST_BUFFER, this._destination.getHostHeader());
            }
            if ((requestContent = this._exchange.getRequestContent()) != null) {
                requestHeaders.putLongField("Content-Length", (long)requestContent.length());
                this._generator.completeHeader(requestHeaders, false);
                this._generator.addContent((Buffer)new View(requestContent), true);
            } else {
                InputStream requestContentStream = this._exchange.getRequestContentSource();
                if (requestContentStream != null) {
                    this._generator.completeHeader(requestHeaders, false);
                    int available = requestContentStream.available();
                    if (available > 0) {
                        byte[] buf = new byte[available];
                        int length = requestContentStream.read(buf);
                        this._generator.addContent((Buffer)new ByteArrayBuffer(buf, 0, length), false);
                    }
                } else {
                    requestHeaders.remove("Content-Length");
                    this._generator.completeHeader(requestHeaders, true);
                }
            }
            this._exchange.setStatus(4);
        }
    }

    protected void reset(boolean returnBuffers) throws IOException {
        this._requestComplete = false;
        this._connectionHeader = null;
        this._parser.reset(returnBuffers);
        this._generator.reset(returnBuffers);
        this._http11 = true;
    }

    private boolean shouldClose() {
        if (this._connectionHeader != null) {
            if (HttpHeaderValues.CLOSE_BUFFER.equals(this._connectionHeader)) {
                return true;
            }
            if (HttpHeaderValues.KEEP_ALIVE_BUFFER.equals(this._connectionHeader)) {
                return false;
            }
        }
        return !this._http11;
    }

    public String toString() {
        return "HttpConnection@" + ((Object)((Object)this)).hashCode() + "//" + this._destination.getAddress().getHost() + ":" + this._destination.getAddress().getPort();
    }

    public String toDetailString() {
        return this.toString() + " ex=" + this._exchange + " " + this._timeout.getAge();
    }

    public void close() throws IOException {
        if (this._exchange != null && !this._exchange.isDone()) {
            switch (this._exchange.getStatus()) {
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    break;
                }
                default: {
                    this._exchange.setStatus(9);
                    this._exchange.getEventListener().onException(new EOFException("local close"));
                }
            }
        }
        this._endp.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIdleTimeout() {
        HttpConnection httpConnection = this;
        synchronized (httpConnection) {
            if (!this._idle.compareAndSet(false, true)) {
                throw new IllegalStateException();
            }
            this._destination.getHttpClient().scheduleIdle(this._timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelIdleTimeout() {
        HttpConnection httpConnection = this;
        synchronized (httpConnection) {
            if (this._idle.compareAndSet(true, false)) {
                this._destination.getHttpClient().cancel(this._timeout);
                return true;
            }
        }
        return false;
    }

    private class Handler
    extends HttpParser.EventHandler {
        private Handler() {
        }

        public void startRequest(Buffer method, Buffer url, Buffer version) throws IOException {
        }

        public void startResponse(Buffer version, int status, Buffer reason) throws IOException {
            HttpExchange exchange = HttpConnection.this._exchange;
            if (exchange != null) {
                HttpConnection.this._http11 = HttpVersions.HTTP_1_1_BUFFER.equals(version);
                HttpConnection.this._status = status;
                exchange.getEventListener().onResponseStatus(version, status, reason);
                exchange.setStatus(5);
            }
        }

        public void parsedHeader(Buffer name, Buffer value) throws IOException {
            HttpExchange exchange = HttpConnection.this._exchange;
            if (exchange != null) {
                if (HttpHeaders.CACHE.getOrdinal(name) == 1) {
                    HttpConnection.this._connectionHeader = HttpHeaderValues.CACHE.lookup(value);
                }
                exchange.getEventListener().onResponseHeader(name, value);
            }
        }

        public void headerComplete() throws IOException {
            HttpExchange exchange;
            if (HttpConnection.this._endp instanceof AsyncEndPoint) {
                ((AsyncEndPoint)HttpConnection.this._endp).scheduleIdle();
            }
            if ((exchange = HttpConnection.this._exchange) != null) {
                exchange.setStatus(6);
            }
        }

        public void content(Buffer ref) throws IOException {
            HttpExchange exchange;
            if (HttpConnection.this._endp instanceof AsyncEndPoint) {
                ((AsyncEndPoint)HttpConnection.this._endp).scheduleIdle();
            }
            if ((exchange = HttpConnection.this._exchange) != null) {
                exchange.getEventListener().onResponseContent(ref);
            }
        }

        public void messageComplete(long contextLength) throws IOException {
            HttpExchange exchange = HttpConnection.this._exchange;
            if (exchange != null) {
                exchange.setStatus(7);
            }
        }
    }

    private class TimeoutTask
    extends Timeout.Task {
        private TimeoutTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void expired() {
            HttpExchange ex = null;
            try {
                HttpConnection httpConnection = HttpConnection.this;
                synchronized (httpConnection) {
                    ex = HttpConnection.this._exchange;
                    HttpConnection.this._exchange = null;
                    if (ex != null) {
                        ex.disassociate();
                        HttpConnection.this._destination.returnConnection(HttpConnection.this, true);
                    } else if (HttpConnection.this._idle.compareAndSet(true, false)) {
                        HttpConnection.this._destination.returnIdleConnection(HttpConnection.this);
                    }
                }
            }
            catch (Exception e) {
                Log.debug((Throwable)e);
            }
            finally {
                if (ex != null && ex.getStatus() < 7) {
                    ex.setStatus(8);
                }
                try {
                    HttpConnection.this.close();
                }
                catch (IOException e) {
                    Log.ignore((Throwable)e);
                }
            }
        }
    }
}

