/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.boot.internal.serverfactory;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.eclipse.jetty.osgi.boot.utils.BundleFileLocatorHelper;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.log.Log;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class DefaultJettyAtJettyHomeHelper {
    public static final String SYS_PROP_JETTY_ETC_FILES = "jetty.etc.config.urls";
    public static final String SYS_PROP_JETTY_HOME = "jetty.home";
    public static final String SYS_PROP_JETTY_HOME_BUNDLE = "jetty.home.bundle";
    public static final String SYS_PROP_JETTY_HOST = "jetty.host";
    public static final String SYS_PROP_JETTY_PORT = "jetty.port";
    public static final String SYS_PROP_JETTY_PORT_SSL = "jetty.port.ssl";

    public static void startJettyAtJettyHome(BundleContext bundleContext) {
        String jettyHomeSysProp = System.getProperty(SYS_PROP_JETTY_HOME);
        String jettyHomeBundleSysProp = System.getProperty(SYS_PROP_JETTY_HOME_BUNDLE);
        File jettyHome = null;
        Bundle jettyHomeBundle = null;
        if (jettyHomeSysProp != null) {
            if (jettyHomeSysProp.startsWith("\"") && jettyHomeSysProp.endsWith("\"")) {
                jettyHomeSysProp = jettyHomeSysProp.substring(1, jettyHomeSysProp.length() - 1);
            }
            if (jettyHomeBundleSysProp != null) {
                Log.warn((String)"Both the jetty.home property and the jetty.home.bundle property are defined. jetty.home.bundle is not taken into account.");
            }
            if (!(jettyHome = new File(jettyHomeSysProp)).exists() || !jettyHome.isDirectory()) {
                Log.warn((String)("Unable to locate the jetty.home folder " + jettyHomeSysProp));
                return;
            }
        } else if (jettyHomeBundleSysProp != null) {
            for (Bundle b : bundleContext.getBundles()) {
                if (!b.getSymbolicName().equals(jettyHomeBundleSysProp)) continue;
                jettyHomeBundle = b;
                break;
            }
            if (jettyHomeBundle == null) {
                Log.warn((String)("Unable to find the jetty.home.bundle named " + jettyHomeSysProp));
                return;
            }
        }
        if (jettyHome == null && jettyHomeBundle == null) {
            Log.warn((String)"No default jetty started.");
            return;
        }
        try {
            Server server = new Server();
            Hashtable<String, String> properties = new Hashtable<String, String>();
            ((Dictionary)properties).put("managedServerName", "defaultJettyServer");
            String configURLs = jettyHome != null ? DefaultJettyAtJettyHomeHelper.getJettyConfigurationURLs(jettyHome) : DefaultJettyAtJettyHomeHelper.getJettyConfigurationURLs(jettyHomeBundle);
            ((Dictionary)properties).put(SYS_PROP_JETTY_ETC_FILES, configURLs);
            Log.info((String)("Configuring the default jetty server with " + configURLs));
            DefaultJettyAtJettyHomeHelper.setProperty(properties, SYS_PROP_JETTY_HOME, System.getProperty(SYS_PROP_JETTY_HOME));
            DefaultJettyAtJettyHomeHelper.setProperty(properties, SYS_PROP_JETTY_HOST, System.getProperty(SYS_PROP_JETTY_HOST));
            DefaultJettyAtJettyHomeHelper.setProperty(properties, SYS_PROP_JETTY_PORT, System.getProperty(SYS_PROP_JETTY_PORT));
            DefaultJettyAtJettyHomeHelper.setProperty(properties, SYS_PROP_JETTY_PORT_SSL, System.getProperty(SYS_PROP_JETTY_PORT_SSL));
            bundleContext.registerService(Server.class.getName(), (Object)server, properties);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static String getJettyConfigurationURLs(File jettyhome) {
        String jettyetc = System.getProperty(SYS_PROP_JETTY_ETC_FILES, "etc/jetty.xml");
        StringTokenizer tokenizer = new StringTokenizer(jettyetc, ";,", false);
        StringBuilder res = new StringBuilder();
        while (tokenizer.hasMoreTokens()) {
            String next = tokenizer.nextToken().trim();
            if (!next.startsWith("/") && next.indexOf(58) == -1) {
                try {
                    next = new File(jettyhome, next).toURI().toURL().toString();
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                    continue;
                }
            }
            DefaultJettyAtJettyHomeHelper.appendToCommaSeparatedList(res, next);
        }
        return res.toString();
    }

    private static String getJettyConfigurationURLs(Bundle configurationBundle) {
        String jettyetc = System.getProperty(SYS_PROP_JETTY_ETC_FILES, "etc/jetty.xml");
        System.err.println("jettyetc=" + jettyetc);
        StringTokenizer tokenizer = new StringTokenizer(jettyetc, ";,", false);
        StringBuilder res = new StringBuilder();
        while (tokenizer.hasMoreTokens()) {
            String etcFile = tokenizer.nextToken().trim();
            if (etcFile.startsWith("/") || etcFile.indexOf(":") != -1) {
                DefaultJettyAtJettyHomeHelper.appendToCommaSeparatedList(res, etcFile);
                continue;
            }
            Enumeration<URL> enUrls = BundleFileLocatorHelper.DEFAULT.findEntries(configurationBundle, etcFile);
            if ((enUrls == null || !enUrls.hasMoreElements()) && etcFile.endsWith("etc/jetty.xml")) {
                enUrls = BundleFileLocatorHelper.DEFAULT.findEntries(configurationBundle, "/jettyhome/etc/jetty-osgi-default.xml");
                System.err.println("Configuring jetty with the default embedded configuration:bundle: " + configurationBundle.getSymbolicName() + " config: /jettyhome/etc/jetty-osgi-default.xml");
            }
            if (enUrls == null || !enUrls.hasMoreElements()) {
                System.err.println("Unable to locate a jetty configuration file for " + etcFile);
            }
            if (enUrls == null) continue;
            while (enUrls.hasMoreElements()) {
                DefaultJettyAtJettyHomeHelper.appendToCommaSeparatedList(res, enUrls.nextElement().toString());
            }
        }
        return res.toString();
    }

    private static void appendToCommaSeparatedList(StringBuilder buffer, String value) {
        if (buffer.length() != 0) {
            buffer.append(",");
        }
        buffer.append(value);
    }

    private static void setProperty(Dictionary properties, String key, String value) {
        if (value != null) {
            properties.put(key, value);
        }
    }
}

