/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.equinoxtools.console;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.util.List;
import org.eclipse.jetty.osgi.equinoxtools.console.WebConsoleWriterOutputStream;
import org.eclipse.osgi.framework.console.ConsoleSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebConsoleSession
extends ConsoleSession {
    private OutputStream _out;
    private StringWriter _outWriter = new StringWriter();
    private PrintStream _source;
    private InputStream _in;

    public WebConsoleSession() {
        this._out = new WebConsoleWriterOutputStream(this._outWriter, "UTF-8");
        try {
            PipedOutputStream source = new PipedOutputStream();
            PipedInputStream sink = new PipedInputStream(source);
            this._in = sink;
            this._source = new PrintStream(source);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void doClose() {
        if (this._out != null) {
            try {
                this._out.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (this._in != null) {
            try {
                this._in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public InputStream getInput() {
        return this._in;
    }

    public OutputStream getOutput() {
        return this._out;
    }

    public StringWriter getOutputAsWriter() {
        return this._outWriter;
    }

    public PrintStream getSource() {
        return this._source;
    }

    public void issueCommand(String cmd) {
        if (cmd != null) {
            this.getSource().println(cmd);
        }
    }

    public void addOnFlushListener(WebConsoleWriterOutputStream.OnFlushListener flushListener) {
        ((WebConsoleWriterOutputStream)((Object)this._out)).addOnFlushListener(flushListener);
    }

    public boolean removeOnFlushListener(WebConsoleWriterOutputStream.OnFlushListener flushListener) {
        return ((WebConsoleWriterOutputStream)((Object)this._out)).removeOnFlushListener(flushListener);
    }

    public void processCommand(String cmd, boolean wait) {
        cmd = cmd.trim();
        while (cmd.startsWith("osgi>")) {
            cmd = cmd.substring("osgi>".length()).trim();
        }
        if (cmd.equals("clear")) {
            this.clearOutput();
        } else {
            this.getOutputAsWriter().append(cmd + "\n");
            int originalOutputLength = this.getOutputAsWriter().getBuffer().length();
            this.issueCommand(cmd);
            if (wait) {
                int lastWaitOutputLength = -1;
                for (int waitLoopNumber = 0; waitLoopNumber < 10; ++waitLoopNumber) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                    int newOutputLength = this.getOutputAsWriter().getBuffer().length();
                    if (newOutputLength > originalOutputLength && newOutputLength == lastWaitOutputLength) break;
                    lastWaitOutputLength = newOutputLength;
                }
            }
        }
    }

    public void clearOutput() {
        StringBuffer buf = this.getOutputAsWriter().getBuffer();
        if (buf.length() > 0) {
            buf.delete(0, buf.length() - 1);
        }
    }

    public List<WebConsoleWriterOutputStream.OnFlushListener> getOnFlushListeners() {
        return ((WebConsoleWriterOutputStream)((Object)this._out)).getOnFlushListeners();
    }
}

