/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.equinoxtools.console;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jetty.io.WriterOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebConsoleWriterOutputStream
extends WriterOutputStream {
    private List<OnFlushListener> _callBacks;

    public WebConsoleWriterOutputStream(Writer writer, String encoding) {
        super(writer, encoding);
    }

    public synchronized void flush() throws IOException {
        super.flush();
        if (this._callBacks != null) {
            for (OnFlushListener listener : this._callBacks) {
                listener.onFlush();
            }
        }
    }

    public synchronized void addOnFlushListener(OnFlushListener callback) {
        if (this._callBacks == null) {
            this._callBacks = new ArrayList<OnFlushListener>();
        }
        if (!this._callBacks.contains(callback)) {
            this._callBacks.add(callback);
        }
    }

    public synchronized boolean removeOnFlushListener(OnFlushListener callback) {
        if (this._callBacks != null) {
            return this._callBacks.remove(callback);
        }
        return false;
    }

    public synchronized List<OnFlushListener> getOnFlushListeners() {
        return this._callBacks;
    }

    public static interface MessageBroadcaster {
        public void broadcast();
    }

    public static interface OnFlushListener {
        public void onFlush();
    }
}

