/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import org.eclipse.jetty.security.ConstraintAware;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.Dispatcher;
import org.eclipse.jetty.server.DispatcherType;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.Holder;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.api.FilterRegistration;
import org.eclipse.jetty.servlet.api.ServletRegistration;
import org.eclipse.jetty.util.Loader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletContextHandler
extends ContextHandler {
    public static final int SESSIONS = 1;
    public static final int SECURITY = 2;
    public static final int NO_SESSIONS = 0;
    public static final int NO_SECURITY = 0;
    protected final List<Decorator> _decorators = new ArrayList<Decorator>();
    protected Class<? extends SecurityHandler> _defaultSecurityHandlerClass = ConstraintSecurityHandler.class;
    protected SessionHandler _sessionHandler;
    protected SecurityHandler _securityHandler;
    protected ServletHandler _servletHandler;
    protected HandlerWrapper _wrapper;
    protected int _options;
    protected Object _restrictedContextListeners;

    public ServletContextHandler() {
        this(null, null, null, null, null);
    }

    public ServletContextHandler(int options) {
        this(null, null, options);
    }

    public ServletContextHandler(HandlerContainer parent, String contextPath) {
        this(parent, contextPath, null, null, null, null);
    }

    public ServletContextHandler(HandlerContainer parent, String contextPath, int options) {
        this(parent, contextPath, null, null, null, null);
        this._options = options;
    }

    public ServletContextHandler(HandlerContainer parent, String contextPath, boolean sessions, boolean security) {
        this(parent, contextPath, (sessions ? 1 : 0) | (security ? 2 : 0));
    }

    public ServletContextHandler(HandlerContainer parent, SessionHandler sessionHandler, SecurityHandler securityHandler, ServletHandler servletHandler, ErrorHandler errorHandler) {
        this(parent, null, sessionHandler, securityHandler, servletHandler, errorHandler);
    }

    public ServletContextHandler(HandlerContainer parent, String contextPath, SessionHandler sessionHandler, SecurityHandler securityHandler, ServletHandler servletHandler, ErrorHandler errorHandler) {
        super((ContextHandler.Context)null);
        this._scontext = new Context();
        this._sessionHandler = sessionHandler;
        this._securityHandler = securityHandler;
        this._servletHandler = servletHandler;
        if (errorHandler != null) {
            this.setErrorHandler(errorHandler);
        }
        if (contextPath != null) {
            this.setContextPath(contextPath);
        }
        if (parent instanceof HandlerWrapper) {
            ((HandlerWrapper)parent).setHandler((Handler)this);
        } else if (parent instanceof HandlerCollection) {
            ((HandlerCollection)parent).addHandler((Handler)this);
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        this._decorators.clear();
        this._wrapper.setHandler(null);
    }

    public Class<? extends SecurityHandler> getDefaultSecurityHandlerClass() {
        return this._defaultSecurityHandlerClass;
    }

    public void setDefaultSecurityHandlerClass(Class<? extends SecurityHandler> defaultSecurityHandlerClass) {
        this._defaultSecurityHandlerClass = defaultSecurityHandlerClass;
    }

    protected SessionHandler newSessionHandler() {
        return new SessionHandler();
    }

    protected SecurityHandler newSecurityHandler() {
        try {
            return this._defaultSecurityHandlerClass.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    protected ServletHandler newServletHandler() {
        return new ServletHandler();
    }

    protected void startContext() throws Exception {
        this.getSessionHandler();
        this.getSecurityHandler();
        this.getServletHandler();
        ServletHandler handler = this._servletHandler;
        if (this._securityHandler != null) {
            this._securityHandler.setHandler((Handler)handler);
            handler = this._securityHandler;
        }
        if (this._sessionHandler != null) {
            this._sessionHandler.setHandler((Handler)handler);
            handler = this._sessionHandler;
        }
        this._wrapper = this;
        while (this._wrapper != handler && this._wrapper.getHandler() instanceof HandlerWrapper) {
            this._wrapper = (HandlerWrapper)this._wrapper.getHandler();
        }
        if (this._wrapper != handler) {
            if (this._wrapper.getHandler() != null) {
                throw new IllegalStateException("!ScopedHandler");
            }
            this._wrapper.setHandler((Handler)handler);
        }
        super.startContext();
        if (this._servletHandler != null && this._servletHandler.isStarted()) {
            for (int i = this._decorators.size() - 1; i >= 0; --i) {
                Decorator decorator = this._decorators.get(i);
                if (this._servletHandler.getFilters() != null) {
                    for (Holder holder : this._servletHandler.getFilters()) {
                        decorator.decorateFilterHolder((FilterHolder)holder);
                    }
                }
                if (this._servletHandler.getServlets() == null) continue;
                for (Holder holder : this._servletHandler.getServlets()) {
                    decorator.decorateServletHolder((ServletHolder)holder);
                }
            }
            this._servletHandler.initialize();
        }
    }

    public SecurityHandler getSecurityHandler() {
        if (this._securityHandler == null && (this._options & 2) != 0 && !this.isStarted()) {
            this._securityHandler = this.newSecurityHandler();
        }
        return this._securityHandler;
    }

    public ServletHandler getServletHandler() {
        if (this._servletHandler == null && !this.isStarted()) {
            this._servletHandler = this.newServletHandler();
        }
        return this._servletHandler;
    }

    public SessionHandler getSessionHandler() {
        if (this._sessionHandler == null && (this._options & 1) != 0 && !this.isStarted()) {
            this._sessionHandler = this.newSessionHandler();
        }
        return this._sessionHandler;
    }

    public ServletHolder addServlet(String className, String pathSpec) {
        return this.getServletHandler().addServletWithMapping(className, pathSpec);
    }

    public ServletHolder addServlet(Class<? extends Servlet> servlet, String pathSpec) {
        return this.getServletHandler().addServletWithMapping(servlet.getName(), pathSpec);
    }

    public void addServlet(ServletHolder servlet, String pathSpec) {
        this.getServletHandler().addServletWithMapping(servlet, pathSpec);
    }

    public void addFilter(FilterHolder holder, String pathSpec, EnumSet<DispatcherType> dispatches) {
        this.getServletHandler().addFilterWithMapping(holder, pathSpec, dispatches);
    }

    public FilterHolder addFilter(Class<? extends Filter> filterClass, String pathSpec, EnumSet<DispatcherType> dispatches) {
        return this.getServletHandler().addFilterWithMapping(filterClass, pathSpec, dispatches);
    }

    public FilterHolder addFilter(String filterClass, String pathSpec, EnumSet<DispatcherType> dispatches) {
        return this.getServletHandler().addFilterWithMapping(filterClass, pathSpec, dispatches);
    }

    public void addFilter(FilterHolder holder, String pathSpec, int dispatches) {
        this.getServletHandler().addFilterWithMapping(holder, pathSpec, dispatches);
    }

    public FilterHolder addFilter(Class<? extends Filter> filterClass, String pathSpec, int dispatches) {
        return this.getServletHandler().addFilterWithMapping(filterClass, pathSpec, dispatches);
    }

    public FilterHolder addFilter(String filterClass, String pathSpec, int dispatches) {
        return this.getServletHandler().addFilterWithMapping(filterClass, pathSpec, dispatches);
    }

    public void callContextInitialized(ServletContextListener l, ServletContextEvent e) {
        l.contextInitialized(e);
    }

    public void callContextDestroyed(ServletContextListener l, ServletContextEvent e) {
        l.contextDestroyed(e);
    }

    public void setSessionHandler(SessionHandler sessionHandler) {
        if (this.isStarted()) {
            throw new IllegalStateException("STARTED");
        }
        this._sessionHandler = sessionHandler;
    }

    public void setSecurityHandler(SecurityHandler securityHandler) {
        if (this.isStarted()) {
            throw new IllegalStateException("STARTED");
        }
        this._securityHandler = securityHandler;
    }

    public void setServletHandler(ServletHandler servletHandler) {
        if (this.isStarted()) {
            throw new IllegalStateException("STARTED");
        }
        this._servletHandler = servletHandler;
    }

    public List<Decorator> getDecorators() {
        return Collections.unmodifiableList(this._decorators);
    }

    public void setDecorators(List<Decorator> decorators) {
        this._decorators.clear();
        this._decorators.addAll(decorators);
    }

    public void addDecorator(Decorator decorator) {
        this._decorators.add(decorator);
    }

    void destroyServlet(Servlet servlet) {
        for (Decorator decorator : this._decorators) {
            decorator.destroyServletInstance(servlet);
        }
    }

    void destroyFilter(Filter filter) {
        for (Decorator decorator : this._decorators) {
            decorator.destroyFilterInstance(filter);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Context
    extends ContextHandler.Context {
        public Context() {
            super((ContextHandler)ServletContextHandler.this);
        }

        public RequestDispatcher getNamedDispatcher(String name) {
            ServletContextHandler context = ServletContextHandler.this;
            if (ServletContextHandler.this._servletHandler == null || ServletContextHandler.this._servletHandler.getServlet(name) == null) {
                return null;
            }
            return new Dispatcher((ContextHandler)context, name);
        }

        public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
            if (ServletContextHandler.this.isStarted()) {
                throw new IllegalStateException();
            }
            ServletHandler handler = ServletContextHandler.this.getServletHandler();
            FilterHolder holder = handler.newFilterHolder();
            holder.setName(filterName);
            holder.setHeldClass(filterClass);
            handler.addFilter(holder);
            return holder.getRegistration();
        }

        public FilterRegistration.Dynamic addFilter(String filterName, String className) {
            if (ServletContextHandler.this.isStarted()) {
                throw new IllegalStateException();
            }
            ServletHandler handler = ServletContextHandler.this.getServletHandler();
            FilterHolder holder = handler.newFilterHolder();
            holder.setName(filterName);
            holder.setClassName(className);
            handler.addFilter(holder);
            return holder.getRegistration();
        }

        public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
            if (ServletContextHandler.this.isStarted()) {
                throw new IllegalStateException();
            }
            ServletHandler handler = ServletContextHandler.this.getServletHandler();
            FilterHolder holder = handler.newFilterHolder();
            holder.setName(filterName);
            holder.setFilter(filter);
            handler.addFilter(holder);
            return holder.getRegistration();
        }

        public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
            if (!ServletContextHandler.this.isStarting()) {
                throw new IllegalStateException();
            }
            ServletHandler handler = ServletContextHandler.this.getServletHandler();
            ServletHolder holder = handler.newServletHolder();
            holder.setName(servletName);
            holder.setHeldClass(servletClass);
            handler.addServlet(holder);
            return holder.getRegistration();
        }

        public ServletRegistration.Dynamic addServlet(String servletName, String className) {
            if (!ServletContextHandler.this.isStarting()) {
                throw new IllegalStateException();
            }
            ServletHandler handler = ServletContextHandler.this.getServletHandler();
            ServletHolder holder = handler.newServletHolder();
            holder.setName(servletName);
            holder.setClassName(className);
            handler.addServlet(holder);
            return holder.getRegistration();
        }

        public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
            if (!ServletContextHandler.this.isStarting()) {
                throw new IllegalStateException();
            }
            ServletHandler handler = ServletContextHandler.this.getServletHandler();
            ServletHolder holder = handler.newServletHolder();
            holder.setName(servletName);
            holder.setServlet(servlet);
            handler.addServlet(holder);
            return holder.getRegistration();
        }

        public boolean setInitParameter(String name, String value) {
            if (!ServletContextHandler.this.isStarting()) {
                throw new IllegalStateException();
            }
            return super.setInitParameter(name, value);
        }

        public <T extends Filter> T createFilter(Class<T> c) throws ServletException {
            try {
                Filter f = (Filter)c.newInstance();
                for (int i = ServletContextHandler.this._decorators.size() - 1; i >= 0; --i) {
                    Decorator decorator = ServletContextHandler.this._decorators.get(i);
                    f = decorator.decorateFilterInstance(f);
                }
                return (T)f;
            }
            catch (InstantiationException e) {
                throw new ServletException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new ServletException((Throwable)e);
            }
        }

        public <T extends Servlet> T createServlet(Class<T> c) throws ServletException {
            try {
                Servlet s = (Servlet)c.newInstance();
                for (int i = ServletContextHandler.this._decorators.size() - 1; i >= 0; --i) {
                    Decorator decorator = ServletContextHandler.this._decorators.get(i);
                    s = decorator.decorateServletInstance(s);
                }
                return (T)s;
            }
            catch (InstantiationException e) {
                throw new ServletException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new ServletException((Throwable)e);
            }
        }

        public FilterRegistration getFilterRegistration(String filterName) {
            FilterHolder holder = ServletContextHandler.this.getServletHandler().getFilter(filterName);
            return holder == null ? null : holder.getRegistration();
        }

        public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
            HashMap<String, FilterRegistration.Dynamic> registrations = new HashMap<String, FilterRegistration.Dynamic>();
            ServletHandler handler = ServletContextHandler.this.getServletHandler();
            FilterHolder[] holders = handler.getFilters();
            if (holders != null) {
                for (FilterHolder holder : holders) {
                    registrations.put(holder.getName(), holder.getRegistration());
                }
            }
            return registrations;
        }

        public ServletRegistration getServletRegistration(String servletName) {
            ServletHolder holder = ServletContextHandler.this.getServletHandler().getServlet(servletName);
            return holder == null ? null : holder.getRegistration();
        }

        public Map<String, ? extends ServletRegistration> getServletRegistrations() {
            HashMap<String, ServletRegistration.Dynamic> registrations = new HashMap<String, ServletRegistration.Dynamic>();
            ServletHandler handler = ServletContextHandler.this.getServletHandler();
            ServletHolder[] holders = handler.getServlets();
            if (holders != null) {
                for (ServletHolder holder : holders) {
                    registrations.put(holder.getName(), holder.getRegistration());
                }
            }
            return registrations;
        }

        public void addListener(String className) {
            if (!ServletContextHandler.this.isStarting()) {
                throw new IllegalStateException();
            }
            try {
                Class<?> clazz = ServletContextHandler.this.getClassLoader() == null ? Loader.loadClass(ContextHandler.class, (String)className) : ServletContextHandler.this.getClassLoader().loadClass(className);
                this.addListener(clazz);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
        }

        public <T extends EventListener> void addListener(T t) {
            if (!ServletContextHandler.this.isStarting()) {
                throw new IllegalStateException();
            }
            ServletContextHandler.this.addEventListener(t);
        }

        public void addListener(Class<? extends EventListener> listenerClass) {
            if (!ServletContextHandler.this.isStarting()) {
                throw new IllegalStateException();
            }
            try {
                EventListener l = this.createListener(listenerClass);
                ServletContextHandler.this.addEventListener(l);
            }
            catch (ServletException e) {
                throw new IllegalStateException(e);
            }
        }

        public <T extends EventListener> T createListener(Class<T> clazz) throws ServletException {
            try {
                EventListener l = null;
                try {
                    l = (EventListener)clazz.newInstance();
                }
                catch (InstantiationException e) {
                    throw new ServletException((Throwable)e);
                }
                catch (IllegalAccessException e) {
                    throw new ServletException((Throwable)e);
                }
                for (int i = ServletContextHandler.this._decorators.size() - 1; i >= 0; --i) {
                    Decorator decorator = ServletContextHandler.this._decorators.get(i);
                    l = decorator.decorateListenerInstance(l);
                }
                return (T)l;
            }
            catch (ServletException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }

        public void declareRoles(String ... roleNames) {
            if (!ServletContextHandler.this.isStarting()) {
                throw new IllegalStateException();
            }
            if (ServletContextHandler.this._securityHandler != null && ServletContextHandler.this._securityHandler instanceof ConstraintAware) {
                HashSet<String> union = new HashSet<String>();
                Set existing = ((ConstraintAware)ServletContextHandler.this._securityHandler).getRoles();
                if (existing != null) {
                    union.addAll(existing);
                }
                union.addAll(Arrays.asList(roleNames));
                ((ConstraintSecurityHandler)ServletContextHandler.this._securityHandler).setRoles(union);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Decorator {
        public <T extends Filter> T decorateFilterInstance(T var1) throws ServletException;

        public <T extends Servlet> T decorateServletInstance(T var1) throws ServletException;

        public <T extends EventListener> T decorateListenerInstance(T var1) throws ServletException;

        public void decorateFilterHolder(FilterHolder var1) throws ServletException;

        public void decorateServletHolder(ServletHolder var1) throws ServletException;

        public void destroyServletInstance(Servlet var1);

        public void destroyFilterInstance(Filter var1);

        public void destroyListenerInstance(EventListener var1);
    }
}

