/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket;

import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketHandler;

public class TestServer
extends Server {
    private static final Logger LOG = Log.getLogger(TestServer.class);
    boolean _verbose;
    WebSocket _websocket;
    SelectChannelConnector _connector;
    WebSocketHandler _wsHandler;
    ResourceHandler _rHandler;
    ConcurrentLinkedQueue<TestWebSocket> _broadcast = new ConcurrentLinkedQueue();

    public TestServer(int port) {
        this._connector = new SelectChannelConnector();
        this._connector.setPort(port);
        this.addConnector((Connector)this._connector);
        this._wsHandler = new WebSocketHandler(){

            public WebSocket doWebSocketConnect(HttpServletRequest request, String protocol) {
                if ("org.ietf.websocket.test-echo".equals(protocol) || "echo".equals(protocol) || "lws-mirror-protocol".equals(protocol)) {
                    TestServer.this._websocket = new TestEchoWebSocket();
                } else if ("org.ietf.websocket.test-echo-broadcast".equals(protocol) || "echo-broadcast".equals(protocol)) {
                    TestServer.this._websocket = new TestEchoBroadcastWebSocket();
                } else if ("org.ietf.websocket.test-echo-assemble".equals(protocol) || "echo-assemble".equals(protocol)) {
                    TestServer.this._websocket = new TestEchoAssembleWebSocket();
                } else if ("org.ietf.websocket.test-echo-fragment".equals(protocol) || "echo-fragment".equals(protocol)) {
                    TestServer.this._websocket = new TestEchoFragmentWebSocket();
                } else if (protocol == null) {
                    TestServer.this._websocket = new TestWebSocket();
                }
                return TestServer.this._websocket;
            }
        };
        this.setHandler((Handler)this._wsHandler);
        this._rHandler = new ResourceHandler();
        this._rHandler.setDirectoriesListed(true);
        this._rHandler.setResourceBase("src/test/webapp");
        this._wsHandler.setHandler((Handler)this._rHandler);
    }

    public boolean isVerbose() {
        return this._verbose;
    }

    public void setVerbose(boolean verbose) {
        this._verbose = verbose;
    }

    public void setResourceBase(String dir) {
        this._rHandler.setResourceBase(dir);
    }

    public String getResourceBase() {
        return this._rHandler.getResourceBase();
    }

    private static void usage() {
        System.err.println("java -cp CLASSPATH " + TestServer.class + " [ OPTIONS ]");
        System.err.println("  -p|--port PORT    (default 8080)");
        System.err.println("  -v|--verbose ");
        System.err.println("  -d|--docroot file (default 'src/test/webapp')");
        System.exit(1);
    }

    public static void main(String ... args) {
        try {
            int port = 8080;
            boolean verbose = false;
            String docroot = "src/test/webapp";
            for (int i = 0; i < args.length; ++i) {
                String a = args[i];
                if ("-p".equals(a) || "--port".equals(a)) {
                    port = Integer.parseInt(args[++i]);
                    continue;
                }
                if ("-v".equals(a) || "--verbose".equals(a)) {
                    verbose = true;
                    continue;
                }
                if ("-d".equals(a) || "--docroot".equals(a)) {
                    docroot = args[++i];
                    continue;
                }
                if (!a.startsWith("-")) continue;
                TestServer.usage();
            }
            TestServer server = new TestServer(port);
            server.setVerbose(verbose);
            server.setResourceBase(docroot);
            server.start();
            server.join();
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
    }

    class TestEchoAssembleWebSocket
    extends TestWebSocket {
        TestEchoAssembleWebSocket() {
        }

        public void onOpen(WebSocket.Connection connection) {
            super.onOpen(connection);
            connection.setMaxTextMessageSize(65536);
            connection.setMaxBinaryMessageSize(65536);
        }

        public void onMessage(byte[] data, int offset, int length) {
            super.onMessage(data, offset, length);
            try {
                this.getConnection().sendMessage(data, offset, length);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void onMessage(String data) {
            super.onMessage(data);
            try {
                this.getConnection().sendMessage(data);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    class TestEchoBroadcastWebSocket
    extends TestWebSocket {
        TestEchoBroadcastWebSocket() {
        }

        public void onOpen(WebSocket.Connection connection) {
            super.onOpen(connection);
            TestServer.this._broadcast.add(this);
        }

        public void onClose(int code, String message) {
            super.onClose(code, message);
            TestServer.this._broadcast.remove(this);
        }

        public void onMessage(byte[] data, int offset, int length) {
            super.onMessage(data, offset, length);
            for (TestWebSocket ws : TestServer.this._broadcast) {
                try {
                    ws.getConnection().sendMessage(data, offset, length);
                }
                catch (IOException e) {
                    TestServer.this._broadcast.remove(ws);
                    e.printStackTrace();
                }
            }
        }

        public void onMessage(String data) {
            super.onMessage(data);
            for (TestWebSocket ws : TestServer.this._broadcast) {
                try {
                    ws.getConnection().sendMessage(data);
                }
                catch (IOException e) {
                    TestServer.this._broadcast.remove(ws);
                    e.printStackTrace();
                }
            }
        }
    }

    class TestEchoFragmentWebSocket
    extends TestWebSocket {
        TestEchoFragmentWebSocket() {
        }

        public void onOpen(WebSocket.Connection connection) {
            super.onOpen(connection);
            connection.setMaxTextMessageSize(65536);
            connection.setMaxBinaryMessageSize(65536);
        }

        public void onMessage(byte[] data, int offset, int length) {
            super.onMessage(data, offset, length);
            try {
                this.getConnection().sendFrame((byte)0, this.getConnection().binaryOpcode(), data, offset, length / 2);
                this.getConnection().sendFrame((byte)8, this.getConnection().binaryOpcode(), data, offset + length / 2, length - length / 2);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void onMessage(String message) {
            super.onMessage(message);
            try {
                byte[] data = message.getBytes("UTF-8");
                int offset = 0;
                int length = data.length;
                this.getConnection().sendFrame((byte)0, this.getConnection().textOpcode(), data, offset, length / 2);
                this.getConnection().sendFrame((byte)8, this.getConnection().textOpcode(), data, offset + length / 2, length - length / 2);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    class TestEchoWebSocket
    extends TestWebSocket {
        TestEchoWebSocket() {
        }

        public void onOpen(WebSocket.Connection connection) {
            super.onOpen(connection);
            connection.setMaxTextMessageSize(-1);
            connection.setMaxBinaryMessageSize(-1);
        }

        public boolean onFrame(byte flags, byte opcode, byte[] data, int offset, int length) {
            super.onFrame(flags, opcode, data, offset, length);
            try {
                if (!this.getConnection().isControl(opcode)) {
                    this.getConnection().sendFrame(flags, opcode, data, offset, length);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return false;
        }
    }

    class TestWebSocket
    implements WebSocket,
    WebSocket.OnFrame,
    WebSocket.OnBinaryMessage,
    WebSocket.OnTextMessage,
    WebSocket.OnControl {
        protected WebSocket.FrameConnection _connection;

        TestWebSocket() {
        }

        public WebSocket.FrameConnection getConnection() {
            return this._connection;
        }

        public void onOpen(WebSocket.Connection connection) {
            if (TestServer.this._verbose) {
                System.err.printf("%s#onOpen %s\n", this.getClass().getSimpleName(), connection);
            }
        }

        public void onHandshake(WebSocket.FrameConnection connection) {
            if (TestServer.this._verbose) {
                System.err.printf("%s#onHandshake %s %s\n", this.getClass().getSimpleName(), connection, connection.getClass().getSimpleName());
            }
            this._connection = connection;
        }

        public void onClose(int code, String message) {
            if (TestServer.this._verbose) {
                System.err.printf("%s#onDisonnect %d %s\n", this.getClass().getSimpleName(), code, message);
            }
        }

        public boolean onFrame(byte flags, byte opcode, byte[] data, int offset, int length) {
            if (TestServer.this._verbose) {
                System.err.printf("%s#onFrame %s|%s %s\n", this.getClass().getSimpleName(), TypeUtil.toHexString((byte)flags), TypeUtil.toHexString((byte)opcode), TypeUtil.toHexString((byte[])data, (int)offset, (int)length));
            }
            return false;
        }

        public boolean onControl(byte controlCode, byte[] data, int offset, int length) {
            if (TestServer.this._verbose) {
                System.err.printf("%s#onControl  %s %s\n", this.getClass().getSimpleName(), TypeUtil.toHexString((byte)controlCode), TypeUtil.toHexString((byte[])data, (int)offset, (int)length));
            }
            return false;
        }

        public void onMessage(String data) {
            if (TestServer.this._verbose) {
                System.err.printf("%s#onMessage     %s\n", this.getClass().getSimpleName(), data);
            }
        }

        public void onMessage(byte[] data, int offset, int length) {
            if (TestServer.this._verbose) {
                System.err.printf("%s#onMessage     %s\n", this.getClass().getSimpleName(), TypeUtil.toHexString((byte[])data, (int)offset, (int)length));
            }
        }
    }
}

