/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.policy.loader;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jetty.policy.PolicyBlock;
import org.eclipse.jetty.policy.PolicyContext;
import org.eclipse.jetty.policy.PolicyException;
import org.eclipse.jetty.policy.entry.GrantEntry;
import org.eclipse.jetty.policy.entry.KeystoreEntry;
import org.eclipse.jetty.policy.loader.PolicyFileScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPolicyLoader {
    public static Set<PolicyBlock> load(InputStream policyStream, PolicyContext context) throws PolicyException {
        HashSet<PolicyBlock> policies = new HashSet<PolicyBlock>();
        KeyStore keystore = null;
        try {
            PolicyFileScanner loader = new PolicyFileScanner();
            ArrayList<GrantEntry> grantEntries = new ArrayList<GrantEntry>();
            ArrayList<KeystoreEntry> keystoreEntries = new ArrayList<KeystoreEntry>();
            loader.scanStream(new InputStreamReader(policyStream), grantEntries, keystoreEntries);
            for (KeystoreEntry node : keystoreEntries) {
                node.expand(context);
                keystore = node.toKeyStore();
                if (keystore == null) continue;
                context.setKeystore(keystore);
                break;
            }
            for (GrantEntry grant : grantEntries) {
                grant.expand(context);
                PolicyBlock policy = new PolicyBlock();
                policy.setCodeSource(grant.getCodeSource());
                policy.setPrincipals(grant.getPrincipals());
                policy.setPermissions(grant.getPermissions());
                policies.add(policy);
            }
            return policies;
        }
        catch (Exception e) {
            throw new PolicyException(e);
        }
    }
}

