/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.nosql;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jetty.nosql.NoSqlSessionManager;
import org.eclipse.jetty.server.session.AbstractSession;
import org.eclipse.jetty.server.session.AbstractSessionManager;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class NoSqlSession
extends AbstractSession {
    private static final Logger __log = Log.getLogger((String)"org.eclipse.jetty.server.session");
    private final NoSqlSessionManager _manager;
    private Set<String> _dirty;
    private final AtomicInteger _active = new AtomicInteger();
    private Object _version;
    private long _lastSync;

    public NoSqlSession(NoSqlSessionManager manager, long created, long accessed, String clusterId) {
        super((AbstractSessionManager)manager, created, accessed, clusterId);
        this._manager = manager;
        this.save(true);
        this._active.incrementAndGet();
    }

    public NoSqlSession(NoSqlSessionManager manager, long created, long accessed, String clusterId, Object version) {
        super((AbstractSessionManager)manager, created, accessed, clusterId);
        this._manager = manager;
        this._version = version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object doPutOrRemove(String name, Object value) {
        NoSqlSession noSqlSession = this;
        synchronized (noSqlSession) {
            if (this._dirty == null) {
                this._dirty = new HashSet<String>();
            }
            this._dirty.add(name);
            Object old = super.doPutOrRemove(name, value);
            if (this._manager.getSavePeriod() == -2) {
                this.save(true);
            }
            return old;
        }
    }

    protected void checkValid() throws IllegalStateException {
        super.checkValid();
    }

    protected boolean access(long time) {
        __log.debug("NoSqlSession:access:active " + this._active, new Object[0]);
        if (this._active.incrementAndGet() == 1) {
            long period = (long)this._manager.getStalePeriod() * 1000L;
            if (period == 0L) {
                this.refresh();
            } else if (period > 0L) {
                long stale = time - this._lastSync;
                __log.debug("NoSqlSession:access:stale " + stale, new Object[0]);
                if (stale > period) {
                    this.refresh();
                }
            }
        }
        return super.access(time);
    }

    protected void complete() {
        super.complete();
        if (this._active.decrementAndGet() == 0) {
            switch (this._manager.getSavePeriod()) {
                case 0: {
                    this.save(this.isValid());
                    break;
                }
                case 1: {
                    if (!this.isDirty()) break;
                    this.save(this.isValid());
                }
            }
        }
    }

    protected void doInvalidate() throws IllegalStateException {
        super.doInvalidate();
        this.save(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void save(boolean activateAfterSave) {
        NoSqlSession noSqlSession = this;
        synchronized (noSqlSession) {
            this._version = this._manager.save(this, this._version, activateAfterSave);
            this._lastSync = this.getAccessed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refresh() {
        NoSqlSession noSqlSession = this;
        synchronized (noSqlSession) {
            this._version = this._manager.refresh(this, this._version);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDirty() {
        NoSqlSession noSqlSession = this;
        synchronized (noSqlSession) {
            return this._dirty != null && !this._dirty.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> takeDirty() {
        NoSqlSession noSqlSession = this;
        synchronized (noSqlSession) {
            Set<String> dirty = this._dirty;
            if (dirty == null) {
                dirty = new HashSet<String>();
            } else {
                this._dirty = null;
            }
            return dirty;
        }
    }

    public Object getVersion() {
        return this._version;
    }
}

