/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import org.eclipse.jetty.continuation.ContinuationThrowable;
import org.eclipse.jetty.http.EncodedHttpURI;
import org.eclipse.jetty.http.Generator;
import org.eclipse.jetty.http.HttpBuffers;
import org.eclipse.jetty.http.HttpContent;
import org.eclipse.jetty.http.HttpException;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpHeaderValues;
import org.eclipse.jetty.http.HttpHeaders;
import org.eclipse.jetty.http.HttpMethods;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersions;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.Parser;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.BufferCache;
import org.eclipse.jetty.io.Buffers;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.io.RuntimeIOException;
import org.eclipse.jetty.io.UncheckedPrintWriter;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.DispatcherType;
import org.eclipse.jetty.server.HttpInput;
import org.eclipse.jetty.server.HttpOutput;
import org.eclipse.jetty.server.HttpWriter;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.nio.NIOConnector;
import org.eclipse.jetty.server.ssl.SslConnector;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;

public abstract class AbstractHttpConnection
extends AbstractConnection {
    private static final Logger LOG = Log.getLogger(AbstractHttpConnection.class);
    private static final int UNKNOWN = -2;
    private static final ThreadLocal<AbstractHttpConnection> __currentConnection = new ThreadLocal();
    private int _requests;
    protected final Connector _connector;
    protected final Server _server;
    protected final HttpURI _uri;
    protected final Parser _parser;
    protected final HttpFields _requestFields;
    protected final Request _request;
    protected volatile ServletInputStream _in;
    protected final Generator _generator;
    protected final HttpFields _responseFields;
    protected final Response _response;
    protected volatile Output _out;
    protected volatile OutputWriter _writer;
    protected volatile PrintWriter _printWriter;
    int _include;
    private Object _associatedObject;
    private int _version = -2;
    private boolean _expect = false;
    private boolean _expect100Continue = false;
    private boolean _expect102Processing = false;
    private boolean _head = false;
    private boolean _host = false;
    private boolean _delayedHandling = false;

    public static AbstractHttpConnection getCurrentConnection() {
        return __currentConnection.get();
    }

    protected static void setCurrentConnection(AbstractHttpConnection connection) {
        __currentConnection.set(connection);
    }

    public AbstractHttpConnection(Connector connector, EndPoint endpoint, Server server) {
        super(endpoint);
        this._uri = "UTF-8".equals(URIUtil.__CHARSET) ? new HttpURI() : new EncodedHttpURI(URIUtil.__CHARSET);
        this._connector = connector;
        HttpBuffers ab = (HttpBuffers)this._connector;
        this._parser = this.newHttpParser(ab.getRequestBuffers(), endpoint, new RequestHandler());
        this._requestFields = new HttpFields();
        this._responseFields = new HttpFields(server.getMaxCookieVersion());
        this._request = new Request(this);
        this._response = new Response(this);
        this._generator = new HttpGenerator(ab.getResponseBuffers(), this._endp);
        this._generator.setSendServerVersion(server.getSendServerVersion());
        this._server = server;
    }

    protected AbstractHttpConnection(Connector connector, EndPoint endpoint, Server server, Parser parser, Generator generator, Request request) {
        super(endpoint);
        this._uri = URIUtil.__CHARSET.equals("UTF-8") ? new HttpURI() : new EncodedHttpURI(URIUtil.__CHARSET);
        this._connector = connector;
        this._parser = parser;
        this._requestFields = new HttpFields();
        this._responseFields = new HttpFields(server.getMaxCookieVersion());
        this._request = request;
        this._response = new Response(this);
        this._generator = generator;
        this._generator.setSendServerVersion(server.getSendServerVersion());
        this._server = server;
    }

    protected HttpParser newHttpParser(Buffers requestBuffers, EndPoint endpoint, HttpParser.EventHandler requestHandler) {
        return new HttpParser(requestBuffers, endpoint, requestHandler);
    }

    public Parser getParser() {
        return this._parser;
    }

    public int getRequests() {
        return this._requests;
    }

    public Server getServer() {
        return this._server;
    }

    public Object getAssociatedObject() {
        return this._associatedObject;
    }

    public void setAssociatedObject(Object associatedObject) {
        this._associatedObject = associatedObject;
    }

    public Connector getConnector() {
        return this._connector;
    }

    public HttpFields getRequestFields() {
        return this._requestFields;
    }

    public HttpFields getResponseFields() {
        return this._responseFields;
    }

    public boolean isConfidential(Request request) {
        if (this._connector != null) {
            return this._connector.isConfidential(request);
        }
        return false;
    }

    public boolean isIntegral(Request request) {
        if (this._connector != null) {
            return this._connector.isIntegral(request);
        }
        return false;
    }

    public boolean getResolveNames() {
        return this._connector.getResolveNames();
    }

    public Request getRequest() {
        return this._request;
    }

    public Response getResponse() {
        return this._response;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this._expect100Continue) {
            if (((HttpParser)this._parser).getHeaderBuffer() == null || ((HttpParser)this._parser).getHeaderBuffer().length() < 2) {
                if (this._generator.isCommitted()) {
                    throw new IllegalStateException("Committed before 100 Continues");
                }
                ((HttpGenerator)this._generator).send1xx(100);
            }
            this._expect100Continue = false;
        }
        if (this._in == null) {
            this._in = new HttpInput(this);
        }
        return this._in;
    }

    public ServletOutputStream getOutputStream() {
        if (this._out == null) {
            this._out = new Output();
        }
        return this._out;
    }

    public PrintWriter getPrintWriter(String encoding) {
        this.getOutputStream();
        if (this._writer == null) {
            this._writer = new OutputWriter();
            this._printWriter = this._server.isUncheckedPrintWriter() ? new UncheckedPrintWriter((Writer)this._writer) : new PrintWriter(this._writer){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void close() {
                    Object object = this.lock;
                    synchronized (object) {
                        try {
                            this.out.close();
                        }
                        catch (IOException e) {
                            this.setError();
                        }
                    }
                }
            };
        }
        this._writer.setCharacterEncoding(encoding);
        return this._printWriter;
    }

    public boolean isResponseCommitted() {
        return this._generator.isCommitted();
    }

    public void reset() {
        this._parser.reset();
        this._parser.returnBuffers();
        this._requestFields.clear();
        this._request.recycle();
        this._generator.reset();
        this._generator.returnBuffers();
        this._responseFields.clear();
        this._response.recycle();
        this._uri.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handleRequest() throws IOException {
        boolean error = false;
        String threadName = null;
        try {
            block33: {
                block32: {
                    boolean handling;
                    if (LOG.isDebugEnabled()) {
                        threadName = Thread.currentThread().getName();
                        Thread.currentThread().setName(threadName + " - " + this._uri);
                    }
                    Server server = this._server;
                    boolean bl = handling = this._request._async.handling() && server != null && server.isRunning();
                    while (handling) {
                        Object var8_12;
                        this._request.setHandled(false);
                        String info = null;
                        try {
                            block31: {
                                try {
                                    this._uri.getPort();
                                    info = URIUtil.canonicalPath((String)this._uri.getDecodedPath());
                                    if (info == null && !this._request.getMethod().equals("CONNECT")) {
                                        throw new HttpException(400);
                                    }
                                    this._request.setPathInfo(info);
                                    if (this._out != null) {
                                        this._out.reopen();
                                    }
                                    if (this._request._async.isInitial()) {
                                        this._request.setDispatcherType(DispatcherType.REQUEST);
                                        this._connector.customize(this._endp, this._request);
                                        server.handle(this);
                                        break block31;
                                    }
                                    this._request.setDispatcherType(DispatcherType.ASYNC);
                                    server.handleAsync(this);
                                }
                                catch (ContinuationThrowable e) {
                                    LOG.ignore((Throwable)e);
                                    var8_12 = null;
                                    handling = !this._request._async.unhandle() && server.isRunning() && this._server != null;
                                    continue;
                                }
                                catch (EofException e) {
                                    LOG.debug((Throwable)e);
                                    error = true;
                                    this._request.setHandled(true);
                                    var8_12 = null;
                                    handling = !this._request._async.unhandle() && server.isRunning() && this._server != null;
                                    continue;
                                }
                                catch (RuntimeIOException e) {
                                    LOG.debug((Throwable)e);
                                    error = true;
                                    this._request.setHandled(true);
                                    var8_12 = null;
                                    handling = !this._request._async.unhandle() && server.isRunning() && this._server != null;
                                    continue;
                                }
                                catch (HttpException e) {
                                    LOG.debug((Throwable)e);
                                    error = true;
                                    this._request.setHandled(true);
                                    this._response.sendError(e.getStatus(), e.getReason());
                                    var8_12 = null;
                                    handling = !this._request._async.unhandle() && server.isRunning() && this._server != null;
                                    continue;
                                }
                                catch (Throwable e) {
                                    LOG.warn(String.valueOf(this._uri), e);
                                    error = true;
                                    this._request.setHandled(true);
                                    this._generator.sendError(info == null ? 400 : 500, null, null, true);
                                    var8_12 = null;
                                    handling = !this._request._async.unhandle() && server.isRunning() && this._server != null;
                                    continue;
                                }
                            }
                            var8_12 = null;
                            handling = !this._request._async.unhandle() && server.isRunning() && this._server != null;
                        }
                        catch (Throwable throwable) {
                            var8_12 = null;
                            handling = !this._request._async.unhandle() && server.isRunning() && this._server != null;
                            throw throwable;
                        }
                    }
                    Object var10_14 = null;
                    if (threadName != null) {
                        Thread.currentThread().setName(threadName);
                    }
                    if (!this._request._async.isUncompleted()) return;
                    this._request._async.doComplete();
                    if (this._expect100Continue) {
                        LOG.debug("100 continues not sent", new Object[0]);
                        this._expect100Continue = false;
                        if (!this._response.isCommitted()) {
                            this._generator.setPersistent(false);
                        }
                    }
                    if (!this._endp.isOpen()) break block32;
                    if (error) {
                        this._endp.shutdownOutput();
                        this._generator.setPersistent(false);
                        if (!this._generator.isComplete()) {
                            this._response.complete();
                        }
                        break block33;
                    } else {
                        if (!this._response.isCommitted() && !this._request.isHandled()) {
                            this._response.sendError(404);
                        }
                        this._response.complete();
                        if (this._generator.isPersistent()) {
                            this._connector.persist(this._endp);
                        }
                    }
                    break block33;
                }
                this._response.complete();
            }
            this._request.setHandled(true);
            return;
        }
        catch (Throwable throwable) {
            block35: {
                block34: {
                    Object var10_15 = null;
                    if (threadName != null) {
                        Thread.currentThread().setName(threadName);
                    }
                    if (!this._request._async.isUncompleted()) throw throwable;
                    this._request._async.doComplete();
                    if (this._expect100Continue) {
                        LOG.debug("100 continues not sent", new Object[0]);
                        this._expect100Continue = false;
                        if (!this._response.isCommitted()) {
                            this._generator.setPersistent(false);
                        }
                    }
                    if (!this._endp.isOpen()) break block34;
                    if (error) {
                        this._endp.shutdownOutput();
                        this._generator.setPersistent(false);
                        if (!this._generator.isComplete()) {
                            this._response.complete();
                        }
                        break block35;
                    } else {
                        if (!this._response.isCommitted() && !this._request.isHandled()) {
                            this._response.sendError(404);
                        }
                        this._response.complete();
                        if (this._generator.isPersistent()) {
                            this._connector.persist(this._endp);
                        }
                    }
                    break block35;
                }
                this._response.complete();
            }
            this._request.setHandled(true);
            throw throwable;
        }
    }

    public abstract Connection handle() throws IOException;

    public void commitResponse(boolean last) throws IOException {
        if (!this._generator.isCommitted()) {
            this._generator.setResponse(this._response.getStatus(), this._response.getReason());
            try {
                if (this._expect100Continue && this._response.getStatus() != 100) {
                    this._generator.setPersistent(false);
                }
                this._generator.completeHeader(this._responseFields, last);
            }
            catch (IOException io) {
                throw io;
            }
            catch (RuntimeException e) {
                LOG.warn("header full: " + e, new Object[0]);
                this._response.reset();
                this._generator.reset();
                this._generator.setResponse(500, null);
                this._generator.completeHeader(this._responseFields, true);
                this._generator.complete();
                throw new HttpException(500);
            }
        }
        if (last) {
            this._generator.complete();
        }
    }

    public void completeResponse() throws IOException {
        if (!this._generator.isCommitted()) {
            this._generator.setResponse(this._response.getStatus(), this._response.getReason());
            try {
                this._generator.completeHeader(this._responseFields, true);
            }
            catch (IOException io) {
                throw io;
            }
            catch (RuntimeException e) {
                LOG.warn("header full: " + e, new Object[0]);
                LOG.debug((Throwable)e);
                this._response.reset();
                this._generator.reset();
                this._generator.setResponse(500, null);
                this._generator.completeHeader(this._responseFields, true);
                this._generator.complete();
                throw new HttpException(500);
            }
        }
        this._generator.complete();
    }

    public void flushResponse() throws IOException {
        try {
            this.commitResponse(false);
            this._generator.flushBuffer();
        }
        catch (IOException e) {
            throw e instanceof EofException ? e : new EofException((Throwable)e);
        }
    }

    public Generator getGenerator() {
        return this._generator;
    }

    public boolean isIncluding() {
        return this._include > 0;
    }

    public void include() {
        ++this._include;
    }

    public void included() {
        --this._include;
        if (this._out != null) {
            this._out.reopen();
        }
    }

    public boolean isIdle() {
        return this._generator.isIdle() && (this._parser.isIdle() || this._delayedHandling);
    }

    public boolean isSuspended() {
        return this._request.getAsyncContinuation().isSuspended();
    }

    public void onClose() {
        LOG.debug("closed {}", new Object[]{this});
    }

    public boolean isExpecting100Continues() {
        return this._expect100Continue;
    }

    public boolean isExpecting102Processing() {
        return this._expect102Processing;
    }

    public int getMaxIdleTime() {
        if (this._connector.isLowResources() && this._endp.getMaxIdleTime() == this._connector.getMaxIdleTime()) {
            return this._connector.getLowResourceMaxIdleTime();
        }
        if (this._endp.getMaxIdleTime() > 0) {
            return this._endp.getMaxIdleTime();
        }
        return this._connector.getMaxIdleTime();
    }

    public String toString() {
        return String.format("%s,g=%s,p=%s,r=%d", super.toString(), this._generator, this._parser, this._requests);
    }

    public class Output
    extends HttpOutput {
        Output() {
            super(AbstractHttpConnection.this);
        }

        public void close() throws IOException {
            if (this.isClosed()) {
                return;
            }
            if (!AbstractHttpConnection.this.isIncluding() && !this._generator.isCommitted()) {
                AbstractHttpConnection.this.commitResponse(true);
            } else {
                AbstractHttpConnection.this.flushResponse();
            }
            super.close();
        }

        public void flush() throws IOException {
            if (!this._generator.isCommitted()) {
                AbstractHttpConnection.this.commitResponse(false);
            }
            super.flush();
        }

        public void print(String s) throws IOException {
            if (this.isClosed()) {
                throw new IOException("Closed");
            }
            PrintWriter writer = AbstractHttpConnection.this.getPrintWriter(null);
            writer.print(s);
        }

        public void sendResponse(Buffer response) throws IOException {
            ((HttpGenerator)this._generator).sendResponse(response);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void sendContent(Object content) throws IOException {
            InputStream in;
            block23: {
                Resource resource = null;
                if (this.isClosed()) {
                    throw new IOException("Closed");
                }
                if (this._generator.isWritten()) {
                    throw new IllegalStateException("!empty");
                }
                if (content instanceof HttpContent) {
                    HttpContent httpContent = (HttpContent)content;
                    Buffer contentType = httpContent.getContentType();
                    if (contentType != null && !AbstractHttpConnection.this._responseFields.containsKey(HttpHeaders.CONTENT_TYPE_BUFFER)) {
                        String enc = AbstractHttpConnection.this._response.getSetCharacterEncoding();
                        if (enc == null) {
                            AbstractHttpConnection.this._responseFields.add(HttpHeaders.CONTENT_TYPE_BUFFER, contentType);
                        } else if (contentType instanceof BufferCache.CachedBuffer) {
                            BufferCache.CachedBuffer content_type = ((BufferCache.CachedBuffer)contentType).getAssociate((Object)enc);
                            if (content_type != null) {
                                AbstractHttpConnection.this._responseFields.put(HttpHeaders.CONTENT_TYPE_BUFFER, (Buffer)content_type);
                            } else {
                                AbstractHttpConnection.this._responseFields.put(HttpHeaders.CONTENT_TYPE_BUFFER, contentType + ";charset=" + QuotedStringTokenizer.quoteIfNeeded((String)enc, (String)";= "));
                            }
                        } else {
                            AbstractHttpConnection.this._responseFields.put(HttpHeaders.CONTENT_TYPE_BUFFER, contentType + ";charset=" + QuotedStringTokenizer.quoteIfNeeded((String)enc, (String)";= "));
                        }
                    }
                    if (httpContent.getContentLength() > 0L) {
                        AbstractHttpConnection.this._responseFields.putLongField(HttpHeaders.CONTENT_LENGTH_BUFFER, httpContent.getContentLength());
                    }
                    Buffer lm = httpContent.getLastModified();
                    long lml = httpContent.getResource().lastModified();
                    if (lm != null) {
                        AbstractHttpConnection.this._responseFields.put(HttpHeaders.LAST_MODIFIED_BUFFER, lm);
                    } else if (httpContent.getResource() != null && lml != -1L) {
                        AbstractHttpConnection.this._responseFields.putDateField(HttpHeaders.LAST_MODIFIED_BUFFER, lml);
                    }
                    boolean direct = AbstractHttpConnection.this._connector instanceof NIOConnector && ((NIOConnector)((Object)AbstractHttpConnection.this._connector)).getUseDirectBuffers() && !(AbstractHttpConnection.this._connector instanceof SslConnector);
                    Object object = content = direct ? httpContent.getDirectBuffer() : httpContent.getIndirectBuffer();
                    if (content == null) {
                        content = httpContent.getInputStream();
                    }
                } else if (content instanceof Resource) {
                    resource = (Resource)content;
                    AbstractHttpConnection.this._responseFields.putDateField(HttpHeaders.LAST_MODIFIED_BUFFER, resource.lastModified());
                    content = resource.getInputStream();
                }
                if (content instanceof Buffer) {
                    this._generator.addContent((Buffer)content, true);
                    AbstractHttpConnection.this.commitResponse(true);
                    return;
                }
                if (!(content instanceof InputStream)) throw new IllegalArgumentException("unknown content type?");
                in = (InputStream)content;
                try {
                    int max = this._generator.prepareUncheckedAddContent();
                    Buffer buffer = this._generator.getUncheckedBuffer();
                    int len = buffer.readFrom(in, max);
                    while (len >= 0) {
                        this._generator.completeUncheckedAddContent();
                        AbstractHttpConnection.this._out.flush();
                        max = this._generator.prepareUncheckedAddContent();
                        buffer = this._generator.getUncheckedBuffer();
                        len = buffer.readFrom(in, max);
                    }
                    this._generator.completeUncheckedAddContent();
                    AbstractHttpConnection.this._out.flush();
                    Object var10_11 = null;
                    if (resource == null) break block23;
                }
                catch (Throwable throwable) {
                    Object var10_12 = null;
                    if (resource != null) {
                        resource.release();
                        throw throwable;
                    }
                    in.close();
                    throw throwable;
                }
                resource.release();
                return;
            }
            in.close();
        }
    }

    public class OutputWriter
    extends HttpWriter {
        OutputWriter() {
            super(AbstractHttpConnection.this._out);
        }
    }

    private class RequestHandler
    extends HttpParser.EventHandler {
        private String _charset;

        private RequestHandler() {
        }

        public void startRequest(Buffer method, Buffer uri, Buffer version) throws IOException {
            uri = uri.asImmutableBuffer();
            AbstractHttpConnection.this._host = false;
            AbstractHttpConnection.this._expect = false;
            AbstractHttpConnection.this._expect100Continue = false;
            AbstractHttpConnection.this._expect102Processing = false;
            AbstractHttpConnection.this._delayedHandling = false;
            this._charset = null;
            if (AbstractHttpConnection.this._request.getTimeStamp() == 0L) {
                AbstractHttpConnection.this._request.setTimeStamp(System.currentTimeMillis());
            }
            AbstractHttpConnection.this._request.setMethod(method.toString());
            try {
                AbstractHttpConnection.this._head = false;
                switch (HttpMethods.CACHE.getOrdinal(method)) {
                    case 8: {
                        AbstractHttpConnection.this._uri.parseConnect(uri.array(), uri.getIndex(), uri.length());
                        break;
                    }
                    case 3: {
                        AbstractHttpConnection.this._head = true;
                        AbstractHttpConnection.this._uri.parse(uri.array(), uri.getIndex(), uri.length());
                        break;
                    }
                    default: {
                        AbstractHttpConnection.this._uri.parse(uri.array(), uri.getIndex(), uri.length());
                    }
                }
                AbstractHttpConnection.this._request.setUri(AbstractHttpConnection.this._uri);
                if (version == null) {
                    AbstractHttpConnection.this._request.setProtocol("");
                    AbstractHttpConnection.this._version = 9;
                } else {
                    if ((version = HttpVersions.CACHE.get(version)) == null) {
                        throw new HttpException(400, null);
                    }
                    AbstractHttpConnection.this._version = HttpVersions.CACHE.getOrdinal(version);
                    if (AbstractHttpConnection.this._version <= 0) {
                        AbstractHttpConnection.this._version = 10;
                    }
                    AbstractHttpConnection.this._request.setProtocol(version.toString());
                }
            }
            catch (Exception e) {
                LOG.debug((Throwable)e);
                if (e instanceof HttpException) {
                    throw (HttpException)((Object)e);
                }
                throw new HttpException(400, null, (Throwable)e);
            }
        }

        public void parsedHeader(Buffer name, Buffer value) {
            int ho = HttpHeaders.CACHE.getOrdinal(name);
            block0 : switch (ho) {
                case 27: {
                    AbstractHttpConnection.this._host = true;
                    break;
                }
                case 24: {
                    value = HttpHeaderValues.CACHE.lookup(value);
                    switch (HttpHeaderValues.CACHE.getOrdinal(value)) {
                        case 6: {
                            AbstractHttpConnection.this._expect100Continue = AbstractHttpConnection.this._generator instanceof HttpGenerator;
                            break block0;
                        }
                        case 7: {
                            AbstractHttpConnection.this._expect102Processing = AbstractHttpConnection.this._generator instanceof HttpGenerator;
                            break block0;
                        }
                    }
                    String[] values = value.toString().split(",");
                    block14: for (int i = 0; values != null && i < values.length; ++i) {
                        BufferCache.CachedBuffer cb = HttpHeaderValues.CACHE.get(values[i].trim());
                        if (cb == null) {
                            AbstractHttpConnection.this._expect = true;
                            continue;
                        }
                        switch (cb.getOrdinal()) {
                            case 6: {
                                AbstractHttpConnection.this._expect100Continue = AbstractHttpConnection.this._generator instanceof HttpGenerator;
                                continue block14;
                            }
                            case 7: {
                                AbstractHttpConnection.this._expect102Processing = AbstractHttpConnection.this._generator instanceof HttpGenerator;
                                continue block14;
                            }
                            default: {
                                AbstractHttpConnection.this._expect = true;
                            }
                        }
                    }
                    break;
                }
                case 21: 
                case 40: {
                    value = HttpHeaderValues.CACHE.lookup(value);
                    break;
                }
                case 16: {
                    value = MimeTypes.CACHE.lookup(value);
                    this._charset = MimeTypes.getCharsetFromContentType((Buffer)value);
                }
            }
            AbstractHttpConnection.this._requestFields.add(name, value);
        }

        public void headerComplete() throws IOException {
            AbstractHttpConnection.this._requests++;
            AbstractHttpConnection.this._generator.setVersion(AbstractHttpConnection.this._version);
            switch (AbstractHttpConnection.this._version) {
                case 9: {
                    break;
                }
                case 10: {
                    AbstractHttpConnection.this._generator.setHead(AbstractHttpConnection.this._head);
                    if (AbstractHttpConnection.this._parser.isPersistent()) {
                        AbstractHttpConnection.this._responseFields.add(HttpHeaders.CONNECTION_BUFFER, HttpHeaderValues.KEEP_ALIVE_BUFFER);
                        AbstractHttpConnection.this._generator.setPersistent(true);
                    } else if ("CONNECT".equals(AbstractHttpConnection.this._request.getMethod())) {
                        AbstractHttpConnection.this._generator.setPersistent(true);
                        AbstractHttpConnection.this._parser.setPersistent(true);
                    }
                    if (!AbstractHttpConnection.this._server.getSendDateHeader()) break;
                    AbstractHttpConnection.this._generator.setDate(AbstractHttpConnection.this._request.getTimeStampBuffer());
                    break;
                }
                case 11: {
                    AbstractHttpConnection.this._generator.setHead(AbstractHttpConnection.this._head);
                    if (!AbstractHttpConnection.this._parser.isPersistent()) {
                        AbstractHttpConnection.this._responseFields.add(HttpHeaders.CONNECTION_BUFFER, HttpHeaderValues.CLOSE_BUFFER);
                        AbstractHttpConnection.this._generator.setPersistent(false);
                    }
                    if (AbstractHttpConnection.this._server.getSendDateHeader()) {
                        AbstractHttpConnection.this._generator.setDate(AbstractHttpConnection.this._request.getTimeStampBuffer());
                    }
                    if (!AbstractHttpConnection.this._host) {
                        LOG.debug("!host {}", new Object[]{this});
                        AbstractHttpConnection.this._generator.setResponse(400, null);
                        AbstractHttpConnection.this._responseFields.put(HttpHeaders.CONNECTION_BUFFER, HttpHeaderValues.CLOSE_BUFFER);
                        AbstractHttpConnection.this._generator.completeHeader(AbstractHttpConnection.this._responseFields, true);
                        AbstractHttpConnection.this._generator.complete();
                        return;
                    }
                    if (!AbstractHttpConnection.this._expect) break;
                    LOG.debug("!expectation {}", new Object[]{this});
                    AbstractHttpConnection.this._generator.setResponse(417, null);
                    AbstractHttpConnection.this._responseFields.put(HttpHeaders.CONNECTION_BUFFER, HttpHeaderValues.CLOSE_BUFFER);
                    AbstractHttpConnection.this._generator.completeHeader(AbstractHttpConnection.this._responseFields, true);
                    AbstractHttpConnection.this._generator.complete();
                    return;
                }
            }
            if (this._charset != null) {
                AbstractHttpConnection.this._request.setCharacterEncodingUnchecked(this._charset);
            }
            if (((HttpParser)AbstractHttpConnection.this._parser).getContentLength() <= 0L && !((HttpParser)AbstractHttpConnection.this._parser).isChunking() || AbstractHttpConnection.this._expect100Continue) {
                AbstractHttpConnection.this.handleRequest();
            } else {
                AbstractHttpConnection.this._delayedHandling = true;
            }
        }

        public void content(Buffer ref) throws IOException {
            if (AbstractHttpConnection.this._delayedHandling) {
                AbstractHttpConnection.this._delayedHandling = false;
                AbstractHttpConnection.this.handleRequest();
            }
        }

        public void messageComplete(long contentLength) throws IOException {
            if (AbstractHttpConnection.this._delayedHandling) {
                AbstractHttpConnection.this._delayedHandling = false;
                AbstractHttpConnection.this.handleRequest();
            }
        }

        public void startResponse(Buffer version, int status, Buffer reason) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Bad request!: " + version + " " + status + " " + reason, new Object[0]);
            }
        }
    }
}

