/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.http.HttpHeaderValues;
import org.eclipse.jetty.http.HttpHeaders;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.BufferCache;
import org.eclipse.jetty.io.BufferDateCache;
import org.eclipse.jetty.io.BufferUtil;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.StringMap;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HttpFields {
    private static final Logger LOG = Log.getLogger(HttpFields.class);
    public static final String __COOKIE_DELIM = "\"\\\n\r\t\f\b%+ ;=";
    public static final TimeZone __GMT = TimeZone.getTimeZone("GMT");
    public static final BufferDateCache __dateCache = new BufferDateCache("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US);
    public static final String __separators = ", \t";
    private static final String[] DAYS;
    private static final String[] MONTHS;
    private static final ThreadLocal<DateGenerator> __dateGenerator;
    private static final String[] __dateReceiveFmt;
    private static final ThreadLocal<DateParser> __dateParser;
    public static final String __01Jan1970;
    public static final Buffer __01Jan1970_BUFFER;
    public static final String __01Jan1970_COOKIE;
    private final ArrayList<Field> _fields = new ArrayList(20);
    private final HashMap<Buffer, Field> _names = new HashMap(32);
    private final int _maxCookieVersion;
    private static ConcurrentMap<String, Buffer> __cache;
    private static int __cacheSize;
    private static final Float __one;
    private static final Float __zero;
    private static final StringMap __qualities;

    public static String formatDate(long date) {
        return __dateGenerator.get().formatDate(date);
    }

    public static void formatCookieDate(StringBuilder buf, long date) {
        __dateGenerator.get().formatCookieDate(buf, date);
    }

    public static String formatCookieDate(long date) {
        StringBuilder buf = new StringBuilder(28);
        HttpFields.formatCookieDate(buf, date);
        return buf.toString();
    }

    public static long parseDate(String date) {
        return __dateParser.get().parse(date);
    }

    public HttpFields() {
        this._maxCookieVersion = 1;
    }

    public HttpFields(int maxCookieVersion) {
        this._maxCookieVersion = maxCookieVersion;
    }

    private Buffer convertValue(String value) {
        Buffer buffer = (Buffer)__cache.get(value);
        if (buffer != null) {
            return buffer;
        }
        try {
            buffer = new ByteArrayBuffer(value, "ISO-8859-1");
            if (__cacheSize > 0) {
                if (__cache.size() > __cacheSize) {
                    __cache.clear();
                }
                __cache.putIfAbsent(value, buffer);
            }
            return buffer;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public Collection<String> getFieldNamesCollection() {
        ArrayList<String> list = new ArrayList<String>(this._fields.size());
        for (Field f : this._fields) {
            if (f == null) continue;
            list.add(BufferUtil.to8859_1_String((Buffer)f._name));
        }
        return list;
    }

    public Enumeration<String> getFieldNames() {
        final Enumeration<Buffer> buffers = Collections.enumeration(this._names.keySet());
        return new Enumeration<String>(){

            @Override
            public String nextElement() {
                return buffers.nextElement().toString();
            }

            @Override
            public boolean hasMoreElements() {
                return buffers.hasMoreElements();
            }
        };
    }

    public int size() {
        return this._fields.size();
    }

    public Field getField(int i) {
        return this._fields.get(i);
    }

    private Field getField(String name) {
        return this._names.get(HttpHeaders.CACHE.lookup(name));
    }

    private Field getField(Buffer name) {
        return this._names.get(HttpHeaders.CACHE.lookup(name));
    }

    public boolean containsKey(Buffer name) {
        return this._names.containsKey(HttpHeaders.CACHE.lookup(name));
    }

    public boolean containsKey(String name) {
        return this._names.containsKey(HttpHeaders.CACHE.lookup(name));
    }

    public String getStringField(String name) {
        Field field = this.getField(name);
        return field == null ? null : field.getValue();
    }

    public String getStringField(Buffer name) {
        Field field = this.getField(name);
        return field == null ? null : field.getValue();
    }

    public Buffer get(Buffer name) {
        Field field = this.getField(name);
        return field == null ? null : field._value;
    }

    public Collection<String> getValuesCollection(String name) {
        Field field = this.getField(name);
        if (field == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        while (field != null) {
            list.add(field.getValue());
            field = field._next;
        }
        return list;
    }

    public Enumeration<String> getValues(String name) {
        final Field field = this.getField(name);
        if (field == null) {
            List empty = Collections.emptyList();
            return Collections.enumeration(empty);
        }
        return new Enumeration<String>(){
            Field f;
            {
                this.f = field;
            }

            @Override
            public boolean hasMoreElements() {
                return this.f != null;
            }

            @Override
            public String nextElement() throws NoSuchElementException {
                if (this.f == null) {
                    throw new NoSuchElementException();
                }
                Field n = this.f;
                this.f = this.f._next;
                return n.getValue();
            }
        };
    }

    public Enumeration<String> getValues(Buffer name) {
        final Field field = this.getField(name);
        if (field == null) {
            List empty = Collections.emptyList();
            return Collections.enumeration(empty);
        }
        return new Enumeration<String>(){
            Field f;
            {
                this.f = field;
            }

            @Override
            public boolean hasMoreElements() {
                return this.f != null;
            }

            @Override
            public String nextElement() throws NoSuchElementException {
                if (this.f == null) {
                    throw new NoSuchElementException();
                }
                Field n = this.f;
                this.f = this.f._next;
                return n.getValue();
            }
        };
    }

    public Enumeration<String> getValues(String name, final String separators) {
        final Enumeration<String> e = this.getValues(name);
        if (e == null) {
            return null;
        }
        return new Enumeration<String>(){
            QuotedStringTokenizer tok = null;

            @Override
            public boolean hasMoreElements() {
                if (this.tok != null && this.tok.hasMoreElements()) {
                    return true;
                }
                while (e.hasMoreElements()) {
                    String value = (String)e.nextElement();
                    this.tok = new QuotedStringTokenizer(value, separators, false, false);
                    if (!this.tok.hasMoreElements()) continue;
                    return true;
                }
                this.tok = null;
                return false;
            }

            @Override
            public String nextElement() throws NoSuchElementException {
                if (!this.hasMoreElements()) {
                    throw new NoSuchElementException();
                }
                String next = (String)this.tok.nextElement();
                if (next != null) {
                    next = next.trim();
                }
                return next;
            }
        };
    }

    public void put(String name, String value) {
        if (value == null) {
            this.remove(name);
        } else {
            Buffer n = HttpHeaders.CACHE.lookup(name);
            Buffer v = this.convertValue(value);
            this.put(n, v);
        }
    }

    public void put(Buffer name, String value) {
        Buffer n = HttpHeaders.CACHE.lookup(name);
        Buffer v = this.convertValue(value);
        this.put(n, v);
    }

    public void put(Buffer name, Buffer value) {
        this.remove(name);
        if (value == null) {
            return;
        }
        if (!(name instanceof BufferCache.CachedBuffer)) {
            name = HttpHeaders.CACHE.lookup(name);
        }
        if (!(value instanceof BufferCache.CachedBuffer)) {
            value = HttpHeaderValues.CACHE.lookup(value).asImmutableBuffer();
        }
        Field field = new Field(name, value);
        this._fields.add(field);
        this._names.put(name, field);
    }

    public void put(String name, List<?> list) {
        if (list == null || list.size() == 0) {
            this.remove(name);
            return;
        }
        Buffer n = HttpHeaders.CACHE.lookup(name);
        Object v = list.get(0);
        if (v != null) {
            this.put(n, HttpHeaderValues.CACHE.lookup(v.toString()));
        } else {
            this.remove(n);
        }
        if (list.size() > 1) {
            Iterator<?> iter = list.iterator();
            iter.next();
            while (iter.hasNext()) {
                v = iter.next();
                if (v == null) continue;
                this.put(n, HttpHeaderValues.CACHE.lookup(v.toString()));
            }
        }
    }

    public void add(String name, String value) throws IllegalArgumentException {
        if (value == null) {
            return;
        }
        Buffer n = HttpHeaders.CACHE.lookup(name);
        Buffer v = this.convertValue(value);
        this.add(n, v);
    }

    public void add(Buffer name, Buffer value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException("null value");
        }
        if (!(name instanceof BufferCache.CachedBuffer)) {
            name = HttpHeaders.CACHE.lookup(name);
        }
        name = name.asImmutableBuffer();
        if (!(value instanceof BufferCache.CachedBuffer) && HttpHeaderValues.hasKnownValues(HttpHeaders.CACHE.getOrdinal(name))) {
            value = HttpHeaderValues.CACHE.lookup(value);
        }
        value = value.asImmutableBuffer();
        Field field = this._names.get(name);
        Field last = null;
        while (field != null) {
            last = field;
            field = field._next;
        }
        field = new Field(name, value);
        this._fields.add(field);
        if (last != null) {
            last._next = field;
        } else {
            this._names.put(name, field);
        }
    }

    public void remove(String name) {
        this.remove(HttpHeaders.CACHE.lookup(name));
    }

    public void remove(Buffer name) {
        if (!(name instanceof BufferCache.CachedBuffer)) {
            name = HttpHeaders.CACHE.lookup(name);
        }
        Field field = this._names.remove(name);
        while (field != null) {
            this._fields.remove(field);
            field = field._next;
        }
    }

    public long getLongField(String name) throws NumberFormatException {
        Field field = this.getField(name);
        return field == null ? -1L : field.getLongValue();
    }

    public long getLongField(Buffer name) throws NumberFormatException {
        Field field = this.getField(name);
        return field == null ? -1L : field.getLongValue();
    }

    public long getDateField(String name) {
        Field field = this.getField(name);
        if (field == null) {
            return -1L;
        }
        String val = HttpFields.valueParameters(BufferUtil.to8859_1_String((Buffer)field._value), null);
        if (val == null) {
            return -1L;
        }
        long date = __dateParser.get().parse(val);
        if (date == -1L) {
            throw new IllegalArgumentException("Cannot convert date: " + val);
        }
        return date;
    }

    public void putLongField(Buffer name, long value) {
        Buffer v = BufferUtil.toBuffer((long)value);
        this.put(name, v);
    }

    public void putLongField(String name, long value) {
        Buffer n = HttpHeaders.CACHE.lookup(name);
        Buffer v = BufferUtil.toBuffer((long)value);
        this.put(n, v);
    }

    public void addLongField(String name, long value) {
        Buffer n = HttpHeaders.CACHE.lookup(name);
        Buffer v = BufferUtil.toBuffer((long)value);
        this.add(n, v);
    }

    public void addLongField(Buffer name, long value) {
        Buffer v = BufferUtil.toBuffer((long)value);
        this.add(name, v);
    }

    public void putDateField(Buffer name, long date) {
        String d = HttpFields.formatDate(date);
        ByteArrayBuffer v = new ByteArrayBuffer(d);
        this.put(name, (Buffer)v);
    }

    public void putDateField(String name, long date) {
        Buffer n = HttpHeaders.CACHE.lookup(name);
        this.putDateField(n, date);
    }

    public void addDateField(String name, long date) {
        String d = HttpFields.formatDate(date);
        Buffer n = HttpHeaders.CACHE.lookup(name);
        ByteArrayBuffer v = new ByteArrayBuffer(d);
        this.add(n, (Buffer)v);
    }

    public void addSetCookie(HttpCookie cookie) {
        this.addSetCookie(cookie.getName(), cookie.getValue(), cookie.getDomain(), cookie.getPath(), cookie.getMaxAge(), cookie.getComment(), cookie.isSecure(), cookie.isHttpOnly(), cookie.getVersion());
    }

    public void addSetCookie(String name, String value, String domain, String path, long maxAge, String comment, boolean isSecure, boolean isHttpOnly, int version) {
        String delim;
        String string = delim = this._maxCookieVersion == 0 ? "" : __COOKIE_DELIM;
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Bad cookie name");
        }
        StringBuilder buf = new StringBuilder(128);
        boolean quoted = QuotedStringTokenizer.quoteIfNeeded((Appendable)buf, (String)name, (String)delim);
        buf.append('=');
        String start = buf.toString();
        if (value != null && value.length() > 0) {
            quoted |= QuotedStringTokenizer.quoteIfNeeded((Appendable)buf, (String)value, (String)delim);
        }
        if (quoted && version == 0 && this._maxCookieVersion >= 1) {
            version = 1;
        }
        if (version > this._maxCookieVersion) {
            version = this._maxCookieVersion;
        }
        if (version > 0) {
            buf.append(";Version=");
            buf.append(version);
            if (comment != null && comment.length() > 0) {
                buf.append(";Comment=");
                QuotedStringTokenizer.quoteIfNeeded((Appendable)buf, (String)comment, (String)delim);
            }
        }
        if (path != null && path.length() > 0) {
            buf.append(";Path=");
            if (path.trim().startsWith("\"")) {
                buf.append(path);
            } else {
                QuotedStringTokenizer.quoteIfNeeded((Appendable)buf, (String)path, (String)delim);
            }
        }
        if (domain != null && domain.length() > 0) {
            buf.append(";Domain=");
            QuotedStringTokenizer.quoteIfNeeded((Appendable)buf, (String)domain.toLowerCase(), (String)delim);
        }
        if (maxAge >= 0L) {
            buf.append(";Expires=");
            if (maxAge == 0L) {
                buf.append(__01Jan1970_COOKIE);
            } else {
                HttpFields.formatCookieDate(buf, System.currentTimeMillis() + 1000L * maxAge);
            }
            if (version > 0) {
                buf.append(";Max-Age=");
                buf.append(maxAge);
            }
        } else if (version > 0) {
            buf.append(";Discard");
        }
        if (isSecure) {
            buf.append(";Secure");
        }
        if (isHttpOnly) {
            buf.append(";HttpOnly");
        }
        String name_value_params = buf.toString();
        Field field = this.getField("Set-Cookie");
        Field last = null;
        while (field != null) {
            if (field._value != null && field._value.toString().startsWith(start)) {
                this._fields.remove(field);
                if (last == null) {
                    this._names.put(HttpHeaders.SET_COOKIE_BUFFER, field._next);
                    break;
                }
                last._next = field._next;
                break;
            }
            last = field;
            field = field._next;
        }
        this.add(HttpHeaders.SET_COOKIE_BUFFER, (Buffer)new ByteArrayBuffer(name_value_params));
        this.put(HttpHeaders.EXPIRES_BUFFER, __01Jan1970_BUFFER);
    }

    public void putTo(Buffer buffer) throws IOException {
        for (int i = 0; i < this._fields.size(); ++i) {
            Field field = this._fields.get(i);
            if (field == null) continue;
            field.putTo(buffer);
        }
        BufferUtil.putCRLF((Buffer)buffer);
    }

    public String toString() {
        try {
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < this._fields.size(); ++i) {
                Field field = this._fields.get(i);
                if (field == null) continue;
                String tmp = field.getName();
                if (tmp != null) {
                    buffer.append(tmp);
                }
                buffer.append(": ");
                tmp = field.getValue();
                if (tmp != null) {
                    buffer.append(tmp);
                }
                buffer.append("\r\n");
            }
            buffer.append("\r\n");
            return buffer.toString();
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            return e.toString();
        }
    }

    public void clear() {
        this._fields.clear();
        this._names.clear();
    }

    public void add(HttpFields fields) {
        if (fields == null) {
            return;
        }
        Enumeration<String> e = fields.getFieldNames();
        while (e.hasMoreElements()) {
            String name = e.nextElement();
            Enumeration<String> values = fields.getValues(name);
            while (values.hasMoreElements()) {
                this.add(name, values.nextElement());
            }
        }
    }

    public static String valueParameters(String value, Map<String, String> parameters) {
        if (value == null) {
            return null;
        }
        int i = value.indexOf(59);
        if (i < 0) {
            return value;
        }
        if (parameters == null) {
            return value.substring(0, i).trim();
        }
        QuotedStringTokenizer tok1 = new QuotedStringTokenizer(value.substring(i), ";", false, true);
        while (tok1.hasMoreTokens()) {
            String token = tok1.nextToken();
            QuotedStringTokenizer tok2 = new QuotedStringTokenizer(token, "= ");
            if (!tok2.hasMoreTokens()) continue;
            String paramName = tok2.nextToken();
            String paramVal = null;
            if (tok2.hasMoreTokens()) {
                paramVal = tok2.nextToken();
            }
            parameters.put(paramName, paramVal);
        }
        return value.substring(0, i).trim();
    }

    public static Float getQuality(String value) {
        Map.Entry entry;
        if (value == null) {
            return __zero;
        }
        int qe = value.indexOf(";");
        if (qe++ < 0 || qe == value.length()) {
            return __one;
        }
        if (value.charAt(qe++) == 'q' && (entry = __qualities.getEntry(value, ++qe, value.length() - qe)) != null) {
            return (Float)entry.getValue();
        }
        HashMap<String, String> params = new HashMap<String, String>(3);
        HttpFields.valueParameters(value, params);
        String qs = params.get("q");
        Float q = (Float)__qualities.get(qs);
        if (q == null) {
            try {
                q = new Float(qs);
            }
            catch (Exception e) {
                q = __one;
            }
        }
        return q;
    }

    public static List qualityList(Enumeration e) {
        if (e == null || !e.hasMoreElements()) {
            return Collections.EMPTY_LIST;
        }
        Object list = null;
        Object qual = null;
        while (e.hasMoreElements()) {
            String v = e.nextElement().toString();
            Float q = HttpFields.getQuality(v);
            if (!((double)q.floatValue() >= 0.001)) continue;
            list = LazyList.add(list, (Object)v);
            qual = LazyList.add(qual, (Object)q);
        }
        List vl = LazyList.getList(list, (boolean)false);
        if (vl.size() < 2) {
            return vl;
        }
        List ql = LazyList.getList(qual, (boolean)false);
        Float last = __zero;
        int i = vl.size();
        while (i-- > 0) {
            Float q = (Float)ql.get(i);
            if (last.compareTo(q) > 0) {
                Object tmp = vl.get(i);
                vl.set(i, vl.get(i + 1));
                vl.set(i + 1, tmp);
                ql.set(i, ql.get(i + 1));
                ql.set(i + 1, q);
                last = __zero;
                i = vl.size();
                continue;
            }
            last = q;
        }
        ql.clear();
        return vl;
    }

    static {
        __GMT.setID("GMT");
        __dateCache.setTimeZone(__GMT);
        DAYS = new String[]{"Sat", "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
        MONTHS = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec", "Jan"};
        __dateGenerator = new ThreadLocal<DateGenerator>(){

            @Override
            protected DateGenerator initialValue() {
                return new DateGenerator();
            }
        };
        __dateReceiveFmt = new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz", "EEE, dd-MMM-yy HH:mm:ss", "EEE MMM dd HH:mm:ss yyyy", "EEE, dd MMM yyyy HH:mm:ss", "EEE dd MMM yyyy HH:mm:ss zzz", "EEE dd MMM yyyy HH:mm:ss", "EEE MMM dd yyyy HH:mm:ss zzz", "EEE MMM dd yyyy HH:mm:ss", "EEE MMM-dd-yyyy HH:mm:ss zzz", "EEE MMM-dd-yyyy HH:mm:ss", "dd MMM yyyy HH:mm:ss zzz", "dd MMM yyyy HH:mm:ss", "dd-MMM-yy HH:mm:ss zzz", "dd-MMM-yy HH:mm:ss", "MMM dd HH:mm:ss yyyy zzz", "MMM dd HH:mm:ss yyyy", "EEE MMM dd HH:mm:ss yyyy zzz", "EEE, MMM dd HH:mm:ss yyyy zzz", "EEE, MMM dd HH:mm:ss yyyy", "EEE, dd-MMM-yy HH:mm:ss zzz", "EEE dd-MMM-yy HH:mm:ss zzz", "EEE dd-MMM-yy HH:mm:ss"};
        __dateParser = new ThreadLocal<DateParser>(){

            @Override
            protected DateParser initialValue() {
                return new DateParser();
            }
        };
        __01Jan1970 = HttpFields.formatDate(0L);
        __01Jan1970_BUFFER = new ByteArrayBuffer(__01Jan1970);
        __01Jan1970_COOKIE = HttpFields.formatCookieDate(0L).trim();
        __cache = new ConcurrentHashMap<String, Buffer>();
        __cacheSize = Integer.getInteger("org.eclipse.jetty.http.HttpFields.CACHE", 2000);
        __one = new Float("1.0");
        __zero = new Float("0.0");
        __qualities = new StringMap();
        __qualities.put(null, (Object)__one);
        __qualities.put("1.0", (Object)__one);
        __qualities.put("1", (Object)__one);
        __qualities.put("0.9", (Object)new Float("0.9"));
        __qualities.put("0.8", (Object)new Float("0.8"));
        __qualities.put("0.7", (Object)new Float("0.7"));
        __qualities.put("0.66", (Object)new Float("0.66"));
        __qualities.put("0.6", (Object)new Float("0.6"));
        __qualities.put("0.5", (Object)new Float("0.5"));
        __qualities.put("0.4", (Object)new Float("0.4"));
        __qualities.put("0.33", (Object)new Float("0.33"));
        __qualities.put("0.3", (Object)new Float("0.3"));
        __qualities.put("0.2", (Object)new Float("0.2"));
        __qualities.put("0.1", (Object)new Float("0.1"));
        __qualities.put("0", (Object)__zero);
        __qualities.put("0.0", (Object)__zero);
    }

    private static class DateGenerator {
        private final StringBuilder buf = new StringBuilder(32);
        private final GregorianCalendar gc = new GregorianCalendar(__GMT);

        private DateGenerator() {
        }

        public String formatDate(long date) {
            this.buf.setLength(0);
            this.gc.setTimeInMillis(date);
            int day_of_week = this.gc.get(7);
            int day_of_month = this.gc.get(5);
            int month = this.gc.get(2);
            int year = this.gc.get(1);
            int century = year / 100;
            year %= 100;
            int hours = this.gc.get(11);
            int minutes = this.gc.get(12);
            int seconds = this.gc.get(13);
            this.buf.append(DAYS[day_of_week]);
            this.buf.append(',');
            this.buf.append(' ');
            StringUtil.append2digits((StringBuilder)this.buf, (int)day_of_month);
            this.buf.append(' ');
            this.buf.append(MONTHS[month]);
            this.buf.append(' ');
            StringUtil.append2digits((StringBuilder)this.buf, (int)century);
            StringUtil.append2digits((StringBuilder)this.buf, (int)year);
            this.buf.append(' ');
            StringUtil.append2digits((StringBuilder)this.buf, (int)hours);
            this.buf.append(':');
            StringUtil.append2digits((StringBuilder)this.buf, (int)minutes);
            this.buf.append(':');
            StringUtil.append2digits((StringBuilder)this.buf, (int)seconds);
            this.buf.append(" GMT");
            return this.buf.toString();
        }

        public void formatCookieDate(StringBuilder buf, long date) {
            this.gc.setTimeInMillis(date);
            int day_of_week = this.gc.get(7);
            int day_of_month = this.gc.get(5);
            int month = this.gc.get(2);
            int year = this.gc.get(1);
            year %= 10000;
            int epoch = (int)(date / 1000L % 86400L);
            int seconds = epoch % 60;
            int minutes = (epoch /= 60) % 60;
            int hours = epoch / 60;
            buf.append(DAYS[day_of_week]);
            buf.append(',');
            buf.append(' ');
            StringUtil.append2digits((StringBuilder)buf, (int)day_of_month);
            buf.append('-');
            buf.append(MONTHS[month]);
            buf.append('-');
            StringUtil.append2digits((StringBuilder)buf, (int)(year / 100));
            StringUtil.append2digits((StringBuilder)buf, (int)(year % 100));
            buf.append(' ');
            StringUtil.append2digits((StringBuilder)buf, (int)hours);
            buf.append(':');
            StringUtil.append2digits((StringBuilder)buf, (int)minutes);
            buf.append(':');
            StringUtil.append2digits((StringBuilder)buf, (int)seconds);
            buf.append(" GMT");
        }
    }

    private static class DateParser {
        final SimpleDateFormat[] _dateReceive = new SimpleDateFormat[HttpFields.access$300().length];

        private DateParser() {
        }

        long parse(String dateVal) {
            for (int i = 0; i < this._dateReceive.length; ++i) {
                if (this._dateReceive[i] == null) {
                    this._dateReceive[i] = new SimpleDateFormat(__dateReceiveFmt[i], Locale.US);
                    this._dateReceive[i].setTimeZone(__GMT);
                }
                try {
                    Date date = (Date)this._dateReceive[i].parseObject(dateVal);
                    return date.getTime();
                }
                catch (Exception e) {
                    continue;
                }
            }
            if (dateVal.endsWith(" GMT")) {
                String val = dateVal.substring(0, dateVal.length() - 4);
                for (int i = 0; i < this._dateReceive.length; ++i) {
                    try {
                        Date date = (Date)this._dateReceive[i].parseObject(val);
                        return date.getTime();
                    }
                    catch (Exception e) {
                        continue;
                    }
                }
            }
            return -1L;
        }
    }

    public static final class Field {
        private Buffer _name;
        private Buffer _value;
        private Field _next;

        private Field(Buffer name, Buffer value) {
            this._name = name;
            this._value = value;
            this._next = null;
        }

        public void putTo(Buffer buffer) throws IOException {
            byte b;
            int e;
            int s;
            int o;
            int n = o = this._name instanceof BufferCache.CachedBuffer ? ((BufferCache.CachedBuffer)this._name).getOrdinal() : -1;
            if (o >= 0) {
                buffer.put(this._name);
            } else {
                s = this._name.getIndex();
                e = this._name.putIndex();
                block6: while (s < e) {
                    b = this._name.peek(s++);
                    switch (b) {
                        case 10: 
                        case 13: 
                        case 58: {
                            continue block6;
                        }
                    }
                    buffer.put(b);
                }
            }
            buffer.put((byte)58);
            buffer.put((byte)32);
            int n2 = o = this._value instanceof BufferCache.CachedBuffer ? ((BufferCache.CachedBuffer)this._value).getOrdinal() : -1;
            if (o >= 0) {
                buffer.put(this._value);
            } else {
                s = this._value.getIndex();
                e = this._value.putIndex();
                block7: while (s < e) {
                    b = this._value.peek(s++);
                    switch (b) {
                        case 10: 
                        case 13: {
                            continue block7;
                        }
                    }
                    buffer.put(b);
                }
            }
            BufferUtil.putCRLF((Buffer)buffer);
        }

        public String getName() {
            return BufferUtil.to8859_1_String((Buffer)this._name);
        }

        Buffer getNameBuffer() {
            return this._name;
        }

        public int getNameOrdinal() {
            return HttpHeaders.CACHE.getOrdinal(this._name);
        }

        public String getValue() {
            return BufferUtil.to8859_1_String((Buffer)this._value);
        }

        public Buffer getValueBuffer() {
            return this._value;
        }

        public int getValueOrdinal() {
            return HttpHeaderValues.CACHE.getOrdinal(this._value);
        }

        public int getIntValue() {
            return (int)this.getLongValue();
        }

        public long getLongValue() {
            return BufferUtil.toLong((Buffer)this._value);
        }

        public String toString() {
            return "[" + this.getName() + "=" + this._value + (this._next == null ? "" : "->") + "]";
        }
    }
}

