/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.monitor.jmx;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class EventState<TYPE> {
    protected Map<String, TriggerState<TYPE>> _states = new ConcurrentHashMap<String, TriggerState<TYPE>>();

    public EventState() {
    }

    public EventState(String id, String desc, TYPE value) {
        this();
        this.add(new TriggerState<TYPE>(id, desc, value));
    }

    public void add(TriggerState<TYPE> state) {
        this._states.put(state.getID(), state);
    }

    public void addAll(Collection<TriggerState<TYPE>> entries) {
        for (TriggerState<TYPE> entry : entries) {
            this.add(entry);
        }
    }

    public TriggerState<TYPE> get(String id) {
        return this._states.get(id);
    }

    public Collection<TriggerState<TYPE>> values() {
        return Collections.unmodifiableCollection(this._states.values());
    }

    public String toString() {
        int cnt = 0;
        StringBuilder result = new StringBuilder();
        for (TriggerState<TYPE> value : this._states.values()) {
            result.append(cnt++ > 0 ? "#" : "");
            result.append(value.toString());
        }
        return result.toString();
    }

    public static class TriggerState<TYPE> {
        private final String _id;
        private final String _desc;
        private final TYPE _value;

        public TriggerState(String id, String desc, TYPE value) {
            this._id = id;
            this._desc = desc;
            this._value = value;
        }

        public String getID() {
            return this._id;
        }

        public String getDescription() {
            return this._desc;
        }

        public TYPE getValue() {
            return this._value;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append(this._desc);
            result.append('=');
            result.append(this._value);
            return result.toString();
        }
    }
}

