/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.policy.loader;

import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jetty.policy.entry.GrantEntry;
import org.eclipse.jetty.policy.entry.KeystoreEntry;
import org.eclipse.jetty.policy.entry.PermissionEntry;
import org.eclipse.jetty.policy.entry.PrincipalEntry;

public class PolicyFileScanner {
    protected StreamTokenizer configure(StreamTokenizer st) {
        st.slashSlashComments(true);
        st.slashStarComments(true);
        st.wordChars(95, 95);
        st.wordChars(36, 36);
        return st;
    }

    public void scanStream(Reader r, Collection<GrantEntry> grantEntries, List<KeystoreEntry> keystoreEntries) throws IOException, InvalidFormatException {
        StreamTokenizer st = this.configure(new StreamTokenizer(r));
        block5: while (true) {
            switch (st.nextToken()) {
                case -1: {
                    break block5;
                }
                case -3: {
                    if (Util.equalsIgnoreCase("keystore", st.sval)) {
                        keystoreEntries.add(this.readKeystoreNode(st));
                        continue block5;
                    }
                    if (Util.equalsIgnoreCase("grant", st.sval)) {
                        grantEntries.add(this.readGrantNode(st));
                        continue block5;
                    }
                    this.handleUnexpectedToken(st, "Expected entries are : \"grant\" or \"keystore\"");
                    continue block5;
                }
                case 59: {
                    continue block5;
                }
                default: {
                    this.handleUnexpectedToken(st);
                    continue block5;
                }
            }
            break;
        }
    }

    protected KeystoreEntry readKeystoreNode(StreamTokenizer st) throws IOException, InvalidFormatException {
        KeystoreEntry ke = new KeystoreEntry();
        if (st.nextToken() == 34) {
            ke.setUrl(st.sval);
            if (st.nextToken() == 34 || st.ttype == 44 && st.nextToken() == 34) {
                ke.setType(st.sval);
            } else {
                st.pushBack();
            }
        } else {
            this.handleUnexpectedToken(st, "Expected syntax is : keystore \"url\"[, \"type\"]");
        }
        return ke;
    }

    protected GrantEntry readGrantNode(StreamTokenizer st) throws IOException, InvalidFormatException {
        GrantEntry ge = new GrantEntry();
        block5: while (true) {
            switch (st.nextToken()) {
                case -3: {
                    if (Util.equalsIgnoreCase("signedby", st.sval)) {
                        if (st.nextToken() == 34) {
                            ge.setSigners(st.sval);
                            continue block5;
                        }
                        this.handleUnexpectedToken(st, "Expected syntax is : signedby \"name1,...,nameN\"");
                        continue block5;
                    }
                    if (Util.equalsIgnoreCase("codebase", st.sval)) {
                        if (st.nextToken() == 34) {
                            ge.setCodebase(st.sval);
                            continue block5;
                        }
                        this.handleUnexpectedToken(st, "Expected syntax is : codebase \"url\"");
                        continue block5;
                    }
                    if (Util.equalsIgnoreCase("principal", st.sval)) {
                        ge.addPrincipal(this.readPrincipalNode(st));
                        continue block5;
                    }
                    this.handleUnexpectedToken(st);
                    continue block5;
                }
                case 44: {
                    continue block5;
                }
                case 123: {
                    ge.setPermissions(this.readPermissionEntries(st));
                    break block5;
                }
                default: {
                    st.pushBack();
                    break block5;
                }
            }
            break;
        }
        return ge;
    }

    protected PrincipalEntry readPrincipalNode(StreamTokenizer st) throws IOException, InvalidFormatException {
        PrincipalEntry pe = new PrincipalEntry();
        if (st.nextToken() == -3) {
            pe.setKlass(st.sval);
            st.nextToken();
        } else if (st.ttype == 42) {
            pe.setKlass("*");
            st.nextToken();
        }
        if (st.ttype == 34) {
            pe.setName(st.sval);
        } else if (st.ttype == 42) {
            pe.setName("*");
        } else {
            this.handleUnexpectedToken(st, "Expected syntax is : principal [class_name] \"principal_name\"");
        }
        return pe;
    }

    protected Collection<PermissionEntry> readPermissionEntries(StreamTokenizer st) throws IOException, InvalidFormatException {
        HashSet<PermissionEntry> permissions = new HashSet<PermissionEntry>();
        block5: while (true) {
            switch (st.nextToken()) {
                case -3: {
                    if (Util.equalsIgnoreCase("permission", st.sval)) {
                        PermissionEntry pe = new PermissionEntry();
                        if (st.nextToken() == -3) {
                            pe.setKlass(st.sval);
                            if (st.nextToken() == 34) {
                                pe.setName(st.sval);
                                st.nextToken();
                            }
                            if (st.ttype == 44) {
                                st.nextToken();
                            }
                            if (st.ttype == 34) {
                                pe.setActions(st.sval);
                                if (st.nextToken() == 44) {
                                    st.nextToken();
                                }
                            }
                            if (st.ttype == -3 && Util.equalsIgnoreCase("signedby", st.sval)) {
                                if (st.nextToken() == 34) {
                                    pe.setSigners(st.sval);
                                } else {
                                    this.handleUnexpectedToken(st);
                                }
                            } else {
                                st.pushBack();
                            }
                            permissions.add(pe);
                            continue block5;
                        }
                    }
                    this.handleUnexpectedToken(st, "Expected syntax is : permission permission_class_name [\"target_name\"] [, \"action_list\"] [, signedby \"name1,...,nameN\"]");
                    continue block5;
                }
                case 59: {
                    continue block5;
                }
                case 125: {
                    break block5;
                }
                default: {
                    this.handleUnexpectedToken(st);
                    continue block5;
                }
            }
            break;
        }
        return permissions;
    }

    protected String composeStatus(StreamTokenizer st) {
        return st.toString();
    }

    protected final void handleUnexpectedToken(StreamTokenizer st, String message) throws InvalidFormatException {
        throw new InvalidFormatException("Unexpected token encountered: " + this.composeStatus(st) + ". " + message);
    }

    protected final void handleUnexpectedToken(StreamTokenizer st) throws InvalidFormatException {
        throw new InvalidFormatException("Unexpected token encountered: " + this.composeStatus(st));
    }

    public static class InvalidFormatException
    extends Exception {
        private static final long serialVersionUID = 5789786270390222184L;

        public InvalidFormatException(String arg0) {
            super(arg0);
        }
    }

    private static class Util {
        private Util() {
        }

        public static String toUpperCase(String s) {
            int len = s.length();
            StringBuilder buffer = new StringBuilder(len);
            for (int i = 0; i < len; ++i) {
                char c = s.charAt(i);
                if ('a' <= c && c <= 'z') {
                    buffer.append((char)(c - 32));
                    continue;
                }
                buffer.append(c);
            }
            return buffer.toString();
        }

        public static boolean equalsIgnoreCase(String s1, String s2) {
            s1 = Util.toUpperCase(s1);
            s2 = Util.toUpperCase(s2);
            return s1.equals(s2);
        }
    }
}

