/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.nosql.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jetty.nosql.NoSqlSession;
import org.eclipse.jetty.nosql.NoSqlSessionManager;
import org.eclipse.jetty.nosql.mongodb.MongoSessionIdManager;
import org.eclipse.jetty.server.SessionIdManager;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class MongoSessionManager
extends NoSqlSessionManager {
    private static final Logger LOG = Log.getLogger(MongoSessionManager.class);
    private static final Logger __log = Log.getLogger((String)"org.eclipse.jetty.server.session");
    private static final String __METADATA = "__metadata__";
    public static final String __ID = "id";
    private static final String __CREATED = "created";
    public static final String __VALID = "valid";
    public static final String __INVALIDATED = "invalidated";
    public static final String __ACCESSED = "accessed";
    private static final String __CONTEXT = "context";
    public static final String __VERSION = "__metadata__.version";
    private String _contextId = null;
    private DBCollection _sessions;
    private DBObject __version_1;

    @Override
    public void doStart() throws Exception {
        String contextPath;
        super.doStart();
        String[] hosts = this.getContextHandler().getVirtualHosts();
        if (hosts == null || hosts.length == 0) {
            hosts = this.getContextHandler().getConnectorNames();
        }
        if (hosts == null || hosts.length == 0) {
            hosts = new String[]{"::"};
        }
        if ((contextPath = this.getContext().getContextPath()) == null || "".equals(contextPath)) {
            contextPath = "*";
        }
        this._contextId = this.createContextId(hosts, contextPath);
        this.__version_1 = new BasicDBObject(this.getContextKey(__VERSION), (Object)1);
    }

    public void setSessionIdManager(SessionIdManager metaManager) {
        MongoSessionIdManager msim = (MongoSessionIdManager)metaManager;
        this._sessions = msim.getSessions();
        super.setSessionIdManager(metaManager);
    }

    @Override
    protected synchronized Object save(NoSqlSession session, Object version, boolean activateAfterSave) {
        try {
            __log.debug("MongoSessionManager:save:" + (Object)((Object)session), new Object[0]);
            session.willPassivate();
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bout);
            BasicDBObject key = new BasicDBObject(__ID, (Object)session.getClusterId());
            key.put(__VALID, (Object)true);
            BasicDBObject update = new BasicDBObject();
            boolean upsert = false;
            BasicDBObject sets = new BasicDBObject();
            BasicDBObject unsets = new BasicDBObject();
            if (version == null) {
                upsert = true;
                version = new Long(1L);
                sets.put(__CREATED, (Object)session.getCreationTime());
                sets.put(this.getContextKey(__VERSION), version);
            } else {
                version = new Long(((Long)version).intValue() + 1);
                update.put("$inc", (Object)this.__version_1);
            }
            if (session.isValid()) {
                sets.put(__ACCESSED, (Object)session.getAccessed());
                Set<String> names = session.takeDirty();
                if (this.isSaveAllAttributes() || upsert) {
                    names.addAll(session.getNames());
                }
                for (String name : names) {
                    Object value = session.getAttribute(name);
                    if (value == null) {
                        unsets.put(this.getContextKey() + "." + this.encodeName(name), (Object)1);
                        continue;
                    }
                    sets.put(this.getContextKey() + "." + this.encodeName(name), this.encodeName(out, bout, value));
                }
            } else {
                sets.put(__VALID, (Object)false);
                sets.put(__INVALIDATED, (Object)System.currentTimeMillis());
                unsets.put(this.getContextKey(), (Object)1);
            }
            if (!sets.isEmpty()) {
                update.put("$set", (Object)sets);
            }
            if (!unsets.isEmpty()) {
                update.put("$unset", (Object)unsets);
            }
            this._sessions.update((DBObject)key, (DBObject)update, upsert, false);
            __log.debug("MongoSessionManager:save:db.sessions.update(" + key + "," + update + ",true)", new Object[0]);
            if (activateAfterSave) {
                session.didActivate();
            }
            return version;
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    @Override
    protected Object refresh(NoSqlSession session, Object version) {
        DBObject o;
        __log.debug("MongoSessionManager:refresh " + (Object)((Object)session), new Object[0]);
        if (version != null && (o = this._sessions.findOne((DBObject)new BasicDBObject(__ID, (Object)session.getClusterId()), this.__version_1)) != null) {
            Object saved = this.getNestedValue(o, this.getContextKey(__VERSION));
            if (saved != null && saved.equals(version)) {
                __log.debug("MongoSessionManager:refresh not needed", new Object[0]);
                return version;
            }
            version = saved;
        }
        if ((o = this._sessions.findOne((DBObject)new BasicDBObject(__ID, (Object)session.getClusterId()))) == null) {
            __log.debug("MongoSessionManager:refresh:marking invalid, no object", new Object[0]);
            session.invalidate();
            return null;
        }
        Boolean valid = (Boolean)o.get(__VALID);
        if (valid == null || !valid.booleanValue()) {
            __log.debug("MongoSessionManager:refresh:marking invalid, valid flag " + valid, new Object[0]);
            session.invalidate();
            return null;
        }
        session.willPassivate();
        try {
            session.clearAttributes();
            DBObject attrs = (DBObject)this.getNestedValue(o, this.getContextKey());
            if (attrs != null) {
                for (String name : attrs.keySet()) {
                    if (__METADATA.equals(name)) continue;
                    String attr = this.decodeName(name);
                    Object value = this.decodeValue(attrs.get(name));
                    session.doPutOrRemove(attr, value);
                    session.bindValue(attr, value);
                }
            }
            session.didActivate();
            return version;
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    @Override
    protected synchronized NoSqlSession loadSession(String clusterId) {
        DBObject o = this._sessions.findOne((DBObject)new BasicDBObject(__ID, (Object)clusterId));
        __log.debug("MongoSessionManager:loaded " + o, new Object[0]);
        if (o == null) {
            return null;
        }
        Boolean valid = (Boolean)o.get(__VALID);
        if (valid == null || !valid.booleanValue()) {
            return null;
        }
        try {
            Object version = o.get(this.getContextKey(__VERSION));
            Long created = (Long)o.get(__CREATED);
            Long accessed = (Long)o.get(__ACCESSED);
            NoSqlSession session = new NoSqlSession(this, created, accessed, clusterId, version);
            DBObject attrs = (DBObject)this.getNestedValue(o, this.getContextKey());
            __log.debug("MongoSessionManager:attrs: " + attrs, new Object[0]);
            if (attrs != null) {
                for (String name : attrs.keySet()) {
                    if (__METADATA.equals(name)) continue;
                    String attr = this.decodeName(name);
                    Object value = this.decodeValue(attrs.get(name));
                    session.doPutOrRemove(attr, value);
                    session.bindValue(attr, value);
                }
            }
            session.didActivate();
            return session;
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    @Override
    protected boolean remove(NoSqlSession session) {
        __log.debug("MongoSessionManager:remove:session " + session.getClusterId(), new Object[0]);
        BasicDBObject key = new BasicDBObject(__ID, (Object)session.getClusterId());
        DBObject o = this._sessions.findOne((DBObject)key, this.__version_1);
        if (o != null) {
            BasicDBObject remove = new BasicDBObject();
            BasicDBObject unsets = new BasicDBObject();
            unsets.put(this.getContextKey(), (Object)1);
            remove.put("$unsets", (Object)unsets);
            this._sessions.update((DBObject)key, (DBObject)remove);
            return true;
        }
        return false;
    }

    @Override
    protected void invalidateSession(String idInCluster) {
        __log.debug("MongoSessionManager:invalidateSession:invalidating " + idInCluster, new Object[0]);
        super.invalidateSession(idInCluster);
        BasicDBObject validKey = new BasicDBObject(__VALID, (Object)true);
        DBObject o = this._sessions.findOne((DBObject)new BasicDBObject(__ID, (Object)idInCluster), (DBObject)validKey);
        if (o != null && ((Boolean)o.get(__VALID)).booleanValue()) {
            BasicDBObject update = new BasicDBObject();
            BasicDBObject sets = new BasicDBObject();
            sets.put(__VALID, (Object)false);
            sets.put(__INVALIDATED, (Object)System.currentTimeMillis());
            update.put("$set", (Object)sets);
            BasicDBObject key = new BasicDBObject(__ID, (Object)idInCluster);
            this._sessions.update((DBObject)key, (DBObject)update);
        }
    }

    protected String encodeName(String name) {
        return name.replace("%", "%25").replace(".", "%2E");
    }

    protected String decodeName(String name) {
        return name.replace("%2E", ".").replace("%25", "%");
    }

    protected Object encodeName(ObjectOutputStream out, ByteArrayOutputStream bout, Object value) throws IOException {
        if (value instanceof Number || value instanceof String || value instanceof Boolean || value instanceof Date) {
            return value;
        }
        if (value.getClass().equals(HashMap.class)) {
            BasicDBObject o = new BasicDBObject();
            for (Map.Entry entry : ((Map)value).entrySet()) {
                if (!(entry.getKey() instanceof String)) {
                    o = null;
                    break;
                }
                o.append(this.encodeName(entry.getKey().toString()), this.encodeName(out, bout, value));
            }
            if (o != null) {
                return o;
            }
        }
        out.reset();
        out.writeUnshared(value);
        out.flush();
        return bout.toByteArray();
    }

    protected Object decodeValue(Object value) throws IOException, ClassNotFoundException {
        if (value == null || value instanceof Number || value instanceof String || value instanceof Boolean || value instanceof Date) {
            return value;
        }
        if (value instanceof byte[]) {
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream((byte[])value));
            return in.readObject();
        }
        if (value instanceof DBObject) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (String name : ((DBObject)value).keySet()) {
                String attr = this.decodeName(name);
                map.put(attr, this.decodeValue(((DBObject)value).get(name)));
            }
            return map;
        }
        throw new IllegalStateException(value.getClass().toString());
    }

    private String getContextKey() {
        return "context." + this._contextId;
    }

    private String getContextKey(String keybit) {
        return "context." + this._contextId + "." + keybit;
    }

    public void purge() {
        ((MongoSessionIdManager)this._sessionIdManager).purge();
    }

    public void purgeFully() {
        ((MongoSessionIdManager)this._sessionIdManager).purgeFully();
    }

    public void scavenge() {
        ((MongoSessionIdManager)this._sessionIdManager).scavenge();
    }

    public void scavengeFully() {
        ((MongoSessionIdManager)this._sessionIdManager).scavengeFully();
    }

    public long getSessionStoreCount() {
        return this._sessions.find().count();
    }

    private String createContextId(String[] virtualHosts, String contextPath) {
        String contextId = virtualHosts[0] + contextPath;
        contextId.replace('/', '_');
        contextId.replace('.', '_');
        contextId.replace('\\', '_');
        return contextId;
    }

    private Object getNestedValue(DBObject dbObject, String nestedKey) {
        String[] keyChain = nestedKey.split("\\.");
        DBObject temp = dbObject;
        for (int i = 0; i < keyChain.length - 1; ++i) {
            if ((temp = (DBObject)temp.get(keyChain[i])) != null) continue;
            return null;
        }
        return temp.get(keyChain[keyChain.length - 1]);
    }
}

