/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.AsyncEndPoint;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.nio.SelectChannelEndPoint;
import org.eclipse.jetty.util.B64Code;
import org.eclipse.jetty.util.Utf8Appendable;
import org.eclipse.jetty.util.Utf8StringBuilder;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.Extension;
import org.eclipse.jetty.websocket.MaskGen;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketBuffers;
import org.eclipse.jetty.websocket.WebSocketConnection;
import org.eclipse.jetty.websocket.WebSocketGenerator;
import org.eclipse.jetty.websocket.WebSocketGeneratorD13;
import org.eclipse.jetty.websocket.WebSocketParser;
import org.eclipse.jetty.websocket.WebSocketParserD13;

public class WebSocketConnectionD13
extends AbstractConnection
implements WebSocketConnection {
    private static final Logger LOG = Log.getLogger(WebSocketConnectionD13.class);
    static final byte OP_CONTINUATION = 0;
    static final byte OP_TEXT = 1;
    static final byte OP_BINARY = 2;
    static final byte OP_EXT_DATA = 3;
    static final byte OP_CONTROL = 8;
    static final byte OP_CLOSE = 8;
    static final byte OP_PING = 9;
    static final byte OP_PONG = 10;
    static final byte OP_EXT_CTRL = 11;
    static final int CLOSE_NORMAL = 1000;
    static final int CLOSE_SHUTDOWN = 1001;
    static final int CLOSE_PROTOCOL = 1002;
    static final int CLOSE_BAD_DATA = 1003;
    static final int CLOSE_UNDEFINED = 1004;
    static final int CLOSE_NO_CODE = 1005;
    static final int CLOSE_NO_CLOSE = 1006;
    static final int CLOSE_BAD_PAYLOAD = 1007;
    static final int CLOSE_POLICY_VIOLATION = 1008;
    static final int CLOSE_MESSAGE_TOO_LARGE = 1009;
    static final int CLOSE_REQUIRED_EXTENSION = 1010;
    static final int FLAG_FIN = 8;
    static final int VERSION = 13;
    private static final byte[] MAGIC;
    private final List<Extension> _extensions;
    private final WebSocketParserD13 _parser;
    private final WebSocketGeneratorD13 _generator;
    private final WebSocketGenerator _outbound;
    private final WebSocket _webSocket;
    private final WebSocket.OnFrame _onFrame;
    private final WebSocket.OnBinaryMessage _onBinaryMessage;
    private final WebSocket.OnTextMessage _onTextMessage;
    private final WebSocket.OnControl _onControl;
    private final String _protocol;
    private final int _draft;
    private final ClassLoader _context;
    private volatile int _closeCode;
    private volatile String _closeMessage;
    private volatile boolean _closedIn;
    private volatile boolean _closedOut;
    private int _maxTextMessageSize = -1;
    private int _maxBinaryMessageSize = -1;
    private final WebSocket.FrameConnection _connection = new WSFrameConnection();

    static boolean isLastFrame(byte flags) {
        return (flags & 8) != 0;
    }

    static boolean isControlFrame(byte opcode) {
        return (opcode & 8) != 0;
    }

    public WebSocketConnectionD13(WebSocket websocket, EndPoint endpoint, WebSocketBuffers buffers, long timestamp, int maxIdleTime, String protocol, List<Extension> extensions, int draft) throws IOException {
        this(websocket, endpoint, buffers, timestamp, maxIdleTime, protocol, extensions, draft, null);
    }

    public WebSocketConnectionD13(WebSocket websocket, EndPoint endpoint, WebSocketBuffers buffers, long timestamp, int maxIdleTime, String protocol, List<Extension> extensions, int draft, MaskGen maskgen) throws IOException {
        super(endpoint, timestamp);
        this._context = Thread.currentThread().getContextClassLoader();
        this._draft = draft;
        this._endp.setMaxIdleTime(maxIdleTime);
        this._webSocket = websocket;
        this._onFrame = this._webSocket instanceof WebSocket.OnFrame ? (WebSocket.OnFrame)this._webSocket : null;
        this._onTextMessage = this._webSocket instanceof WebSocket.OnTextMessage ? (WebSocket.OnTextMessage)this._webSocket : null;
        this._onBinaryMessage = this._webSocket instanceof WebSocket.OnBinaryMessage ? (WebSocket.OnBinaryMessage)this._webSocket : null;
        this._onControl = this._webSocket instanceof WebSocket.OnControl ? (WebSocket.OnControl)this._webSocket : null;
        this._generator = new WebSocketGeneratorD13(buffers, this._endp, maskgen);
        this._extensions = extensions;
        WSFrameHandler frameHandler = new WSFrameHandler();
        if (this._extensions != null) {
            int e = 0;
            for (Extension extension : this._extensions) {
                extension.bind(this._connection, e == extensions.size() - 1 ? frameHandler : (WebSocketParser.FrameHandler)extensions.get(e + 1), e == 0 ? this._generator : (WebSocketGenerator)extensions.get(e - 1));
                ++e;
            }
        }
        this._outbound = this._extensions == null || this._extensions.size() == 0 ? this._generator : (WebSocketGenerator)extensions.get(extensions.size() - 1);
        WSFrameHandler inbound = this._extensions == null || this._extensions.size() == 0 ? frameHandler : (WebSocketParser.FrameHandler)extensions.get(0);
        this._parser = new WebSocketParserD13(buffers, endpoint, inbound, maskgen == null);
        this._protocol = protocol;
    }

    @Override
    public WebSocket.Connection getConnection() {
        return this._connection;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this._extensions == null) {
            return Collections.emptyList();
        }
        return this._extensions;
    }

    public Connection handle() throws IOException {
        Thread current = Thread.currentThread();
        ClassLoader oldcontext = current.getContextClassLoader();
        current.setContextClassLoader(this._context);
        try {
            boolean progress = true;
            while (progress) {
                int flushed = this._generator.flushBuffer();
                int filled = this._parser.parseNext();
                progress = flushed > 0 || filled > 0;
                this._endp.flush();
                if (!(this._endp instanceof AsyncEndPoint) || !((AsyncEndPoint)this._endp).hasProgressed()) continue;
                progress = true;
            }
        }
        catch (IOException e) {
            try {
                if (this._endp.isOpen()) {
                    this._endp.close();
                }
            }
            catch (IOException e2) {
                LOG.ignore((Throwable)e2);
            }
            throw e;
        }
        finally {
            current.setContextClassLoader(oldcontext);
            this._parser.returnBuffer();
            this._generator.returnBuffer();
            if (this._endp.isOpen()) {
                if (this._closedIn && this._closedOut && this._outbound.isBufferEmpty()) {
                    this._endp.close();
                } else if (this._endp.isInputShutdown() && !this._closedIn) {
                    this.closeIn(1006, null);
                } else {
                    this.checkWriteable();
                }
            }
        }
        return this;
    }

    public void onInputShutdown() throws IOException {
        if (!this._closedIn) {
            this._endp.close();
        }
    }

    public boolean isIdle() {
        return this._parser.isBufferEmpty() && this._outbound.isBufferEmpty();
    }

    public void onIdleExpired() {
        long idle = System.currentTimeMillis() - ((SelectChannelEndPoint)this._endp).getIdleTimestamp();
        this.closeOut(1000, "Idle for " + idle + "ms > " + this._endp.getMaxIdleTime() + "ms");
    }

    public boolean isSuspended() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClose() {
        boolean closed;
        WebSocketConnectionD13 webSocketConnectionD13 = this;
        synchronized (webSocketConnectionD13) {
            boolean bl = closed = this._closeCode == 0;
            if (closed) {
                this._closeCode = 1006;
            }
        }
        if (closed) {
            this._webSocket.onClose(1006, "closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeIn(int code, String message) {
        boolean tell_app;
        boolean closed_out;
        LOG.debug("ClosedIn {} {} {}", new Object[]{this, code, message});
        WebSocketConnectionD13 webSocketConnectionD13 = this;
        synchronized (webSocketConnectionD13) {
            closed_out = this._closedOut;
            this._closedIn = true;
            boolean bl = tell_app = this._closeCode == 0;
            if (tell_app) {
                this._closeCode = code;
                this._closeMessage = message;
            }
        }
        try {
            if (tell_app) {
                this._webSocket.onClose(code, message);
            }
        }
        finally {
            if (!closed_out) {
                this.closeOut(code, message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeOut(int code, String message) {
        boolean closed_out;
        block18: {
            boolean tell_app;
            LOG.debug("ClosedOut {} {} {}", new Object[]{this, code, message});
            WebSocketConnectionD13 webSocketConnectionD13 = this;
            synchronized (webSocketConnectionD13) {
                closed_out = this._closedOut;
                this._closedOut = true;
                boolean bl = tell_app = this._closeCode == 0;
                if (tell_app) {
                    this._closeCode = code;
                    this._closeMessage = message;
                }
            }
            try {
                if (!tell_app) break block18;
                this._webSocket.onClose(code, message);
            }
            catch (Throwable throwable) {
                try {
                    if (!closed_out) {
                        if (code < 0 || code == 1005 || code == 1006) {
                            code = -1;
                        } else if (code == 0) {
                            code = 1000;
                        }
                        byte[] bytes = ("xx" + (message == null ? "" : message)).getBytes("ISO-8859-1");
                        bytes[0] = (byte)(code / 256);
                        bytes[1] = (byte)(code % 256);
                        this._outbound.addFrame((byte)8, (byte)8, bytes, 0, code > 0 ? bytes.length : 0);
                        this._outbound.flush();
                    }
                }
                catch (IOException e) {
                    LOG.ignore((Throwable)e);
                }
                throw throwable;
            }
        }
        try {
            if (!closed_out) {
                if (code < 0 || code == 1005 || code == 1006) {
                    code = -1;
                } else if (code == 0) {
                    code = 1000;
                }
                byte[] bytes = ("xx" + (message == null ? "" : message)).getBytes("ISO-8859-1");
                bytes[0] = (byte)(code / 256);
                bytes[1] = (byte)(code % 256);
                this._outbound.addFrame((byte)8, (byte)8, bytes, 0, code > 0 ? bytes.length : 0);
                this._outbound.flush();
            }
        }
        catch (IOException e) {
            LOG.ignore((Throwable)e);
        }
    }

    @Override
    public void fillBuffersFrom(Buffer buffer) {
        this._parser.fill(buffer);
    }

    private void checkWriteable() {
        if (!this._outbound.isBufferEmpty() && this._endp instanceof AsyncEndPoint) {
            ((AsyncEndPoint)this._endp).scheduleWrite();
        }
    }

    @Override
    public void handshake(HttpServletRequest request, HttpServletResponse response, String subprotocol) throws IOException {
        String key = request.getHeader("Sec-WebSocket-Key");
        response.setHeader("Upgrade", "WebSocket");
        response.addHeader("Connection", "Upgrade");
        response.addHeader("Sec-WebSocket-Accept", WebSocketConnectionD13.hashKey(key));
        if (subprotocol != null) {
            response.addHeader("Sec-WebSocket-Protocol", subprotocol);
        }
        for (Extension ext : this._extensions) {
            response.addHeader("Sec-WebSocket-Extensions", ext.getParameterizedName());
        }
        response.sendError(101);
        if (this._onFrame != null) {
            this._onFrame.onHandshake(this._connection);
        }
        this._webSocket.onOpen(this._connection);
    }

    public static String hashKey(String key) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            md.update(key.getBytes("UTF-8"));
            md.update(MAGIC);
            return new String(B64Code.encode((byte[])md.digest()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return "WS/D" + this._draft + "-" + this._endp;
    }

    static {
        try {
            MAGIC = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11".getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private class WSFrameConnection
    implements WebSocket.FrameConnection {
        volatile boolean _disconnecting;

        private WSFrameConnection() {
        }

        @Override
        public void sendMessage(String content) throws IOException {
            if (WebSocketConnectionD13.this._closedOut) {
                throw new IOException("closedOut " + WebSocketConnectionD13.this._closeCode + ":" + WebSocketConnectionD13.this._closeMessage);
            }
            byte[] data = content.getBytes("UTF-8");
            WebSocketConnectionD13.this._outbound.addFrame((byte)8, (byte)1, data, 0, data.length);
            WebSocketConnectionD13.this.checkWriteable();
        }

        @Override
        public void sendMessage(byte[] content, int offset, int length) throws IOException {
            if (WebSocketConnectionD13.this._closedOut) {
                throw new IOException("closedOut " + WebSocketConnectionD13.this._closeCode + ":" + WebSocketConnectionD13.this._closeMessage);
            }
            WebSocketConnectionD13.this._outbound.addFrame((byte)8, (byte)2, content, offset, length);
            WebSocketConnectionD13.this.checkWriteable();
        }

        @Override
        public void sendFrame(byte flags, byte opcode, byte[] content, int offset, int length) throws IOException {
            if (WebSocketConnectionD13.this._closedOut) {
                throw new IOException("closedOut " + WebSocketConnectionD13.this._closeCode + ":" + WebSocketConnectionD13.this._closeMessage);
            }
            WebSocketConnectionD13.this._outbound.addFrame(flags, opcode, content, offset, length);
            WebSocketConnectionD13.this.checkWriteable();
        }

        @Override
        public void sendControl(byte ctrl, byte[] data, int offset, int length) throws IOException {
            if (WebSocketConnectionD13.this._closedOut) {
                throw new IOException("closedOut " + WebSocketConnectionD13.this._closeCode + ":" + WebSocketConnectionD13.this._closeMessage);
            }
            WebSocketConnectionD13.this._outbound.addFrame((byte)8, ctrl, data, offset, length);
            WebSocketConnectionD13.this.checkWriteable();
        }

        @Override
        public boolean isMessageComplete(byte flags) {
            return WebSocketConnectionD13.isLastFrame(flags);
        }

        @Override
        public boolean isOpen() {
            return WebSocketConnectionD13.this._endp != null && WebSocketConnectionD13.this._endp.isOpen();
        }

        @Override
        public void close(int code, String message) {
            if (this._disconnecting) {
                return;
            }
            this._disconnecting = true;
            WebSocketConnectionD13.this.closeOut(code, message);
        }

        @Override
        public void setMaxIdleTime(int ms) {
            try {
                WebSocketConnectionD13.this._endp.setMaxIdleTime(ms);
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
        }

        @Override
        public void setMaxTextMessageSize(int size) {
            WebSocketConnectionD13.this._maxTextMessageSize = size;
        }

        @Override
        public void setMaxBinaryMessageSize(int size) {
            WebSocketConnectionD13.this._maxBinaryMessageSize = size;
        }

        @Override
        public int getMaxIdleTime() {
            return WebSocketConnectionD13.this._endp.getMaxIdleTime();
        }

        @Override
        public int getMaxTextMessageSize() {
            return WebSocketConnectionD13.this._maxTextMessageSize;
        }

        @Override
        public int getMaxBinaryMessageSize() {
            return WebSocketConnectionD13.this._maxBinaryMessageSize;
        }

        @Override
        public String getProtocol() {
            return WebSocketConnectionD13.this._protocol;
        }

        @Override
        public byte binaryOpcode() {
            return 2;
        }

        @Override
        public byte textOpcode() {
            return 1;
        }

        @Override
        public byte continuationOpcode() {
            return 0;
        }

        @Override
        public byte finMask() {
            return 8;
        }

        @Override
        public boolean isControl(byte opcode) {
            return WebSocketConnectionD13.isControlFrame(opcode);
        }

        @Override
        public boolean isText(byte opcode) {
            return opcode == 1;
        }

        @Override
        public boolean isBinary(byte opcode) {
            return opcode == 2;
        }

        @Override
        public boolean isContinuation(byte opcode) {
            return opcode == 0;
        }

        @Override
        public boolean isClose(byte opcode) {
            return opcode == 8;
        }

        @Override
        public boolean isPing(byte opcode) {
            return opcode == 9;
        }

        @Override
        public boolean isPong(byte opcode) {
            return opcode == 10;
        }

        @Override
        public void disconnect() {
            this.close(1000, null);
        }

        @Override
        public void close() {
            this.close(1000, null);
        }

        @Override
        public void setAllowFrameFragmentation(boolean allowFragmentation) {
            WebSocketConnectionD13.this._parser.setFakeFragments(allowFragmentation);
        }

        @Override
        public boolean isAllowFrameFragmentation() {
            return WebSocketConnectionD13.this._parser.isFakeFragments();
        }

        public String toString() {
            return this.getClass().getSimpleName() + "D13@" + WebSocketConnectionD13.this._endp.getLocalAddr() + ":" + WebSocketConnectionD13.this._endp.getLocalPort() + "<->" + WebSocketConnectionD13.this._endp.getRemoteAddr() + ":" + WebSocketConnectionD13.this._endp.getRemotePort();
        }
    }

    private class WSFrameHandler
    implements WebSocketParser.FrameHandler {
        private static final int MAX_CONTROL_FRAME_PAYLOAD = 125;
        private final Utf8StringBuilder _utf8 = new Utf8StringBuilder(512);
        private ByteArrayBuffer _aggregate;
        private byte _opcode = (byte)-1;

        private WSFrameHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFrame(byte flags, byte opcode, Buffer buffer) {
            boolean lastFrame = WebSocketConnectionD13.isLastFrame(flags);
            WebSocketConnectionD13 webSocketConnectionD13 = WebSocketConnectionD13.this;
            synchronized (webSocketConnectionD13) {
                if (WebSocketConnectionD13.this._closedIn) {
                    return;
                }
            }
            try {
                byte[] array = buffer.array();
                if (WebSocketConnectionD13.isControlFrame(opcode) && buffer.length() > 125) {
                    this.errorClose(1002, "Control frame too large: " + buffer.length() + " > " + 125);
                    return;
                }
                if ((flags & 7) != 0) {
                    this.errorClose(1002, "RSV bits set 0x" + Integer.toHexString(flags));
                    return;
                }
                if (WebSocketConnectionD13.this._closeCode != 0 && WebSocketConnectionD13.this._closeCode != 1000 && opcode != 8) {
                    return;
                }
                if (WebSocketConnectionD13.this._onFrame != null && WebSocketConnectionD13.this._onFrame.onFrame(flags, opcode, array, buffer.getIndex(), buffer.length())) {
                    return;
                }
                if (WebSocketConnectionD13.this._onControl != null && WebSocketConnectionD13.isControlFrame(opcode) && WebSocketConnectionD13.this._onControl.onControl(opcode, array, buffer.getIndex(), buffer.length())) {
                    return;
                }
                switch (opcode) {
                    case 0: {
                        if (this._opcode == -1) {
                            this.errorClose(1002, "Bad Continuation");
                            return;
                        }
                        if (WebSocketConnectionD13.this._onTextMessage != null && this._opcode == 1) {
                            if (this._utf8.append(buffer.array(), buffer.getIndex(), buffer.length(), WebSocketConnectionD13.this._connection.getMaxTextMessageSize())) {
                                if (lastFrame) {
                                    this._opcode = (byte)-1;
                                    String msg = this._utf8.toString();
                                    this._utf8.reset();
                                    WebSocketConnectionD13.this._onTextMessage.onMessage(msg);
                                }
                            } else {
                                this.textMessageTooLarge();
                            }
                        }
                        if (this._opcode < 0 || WebSocketConnectionD13.this._connection.getMaxBinaryMessageSize() < 0 || this._aggregate == null || !this.checkBinaryMessageSize(this._aggregate.length(), buffer.length())) break;
                        this._aggregate.put(buffer);
                        if (!lastFrame || WebSocketConnectionD13.this._onBinaryMessage == null) break;
                        try {
                            WebSocketConnectionD13.this._onBinaryMessage.onMessage(this._aggregate.array(), this._aggregate.getIndex(), this._aggregate.length());
                            break;
                        }
                        finally {
                            this._opcode = (byte)-1;
                            this._aggregate.clear();
                        }
                    }
                    case 9: {
                        LOG.debug("PING {}", new Object[]{this});
                        if (!WebSocketConnectionD13.this._closedOut) {
                            WebSocketConnectionD13.this._connection.sendControl((byte)10, buffer.array(), buffer.getIndex(), buffer.length());
                        }
                        break;
                    }
                    case 10: {
                        LOG.debug("PONG {}", new Object[]{this});
                        break;
                    }
                    case 8: {
                        int code = 1005;
                        String message = null;
                        if (buffer.length() >= 2) {
                            code = (0xFF & buffer.array()[buffer.getIndex()]) * 256 + (0xFF & buffer.array()[buffer.getIndex() + 1]);
                            if (code < 1000 || code == 1004 || code == 1006 || code == 1005 || code > 1010 && code <= 2999 || code >= 5000) {
                                this.errorClose(1002, "Invalid close code " + code);
                                return;
                            }
                            if (buffer.length() > 2 && this._utf8.append(buffer.array(), buffer.getIndex() + 2, buffer.length() - 2, WebSocketConnectionD13.this._connection.getMaxTextMessageSize())) {
                                message = this._utf8.toString();
                                this._utf8.reset();
                            }
                        } else if (buffer.length() == 1) {
                            this.errorClose(1002, "Invalid payload length of 1");
                            return;
                        }
                        WebSocketConnectionD13.this.closeIn(code, message);
                        break;
                    }
                    case 1: {
                        if (this._opcode != -1) {
                            this.errorClose(1002, "Expected Continuation" + Integer.toHexString(opcode));
                            return;
                        }
                        if (WebSocketConnectionD13.this._onTextMessage != null) {
                            if (WebSocketConnectionD13.this._connection.getMaxTextMessageSize() <= 0) {
                                if (lastFrame) {
                                    WebSocketConnectionD13.this._onTextMessage.onMessage(buffer.toString("UTF-8"));
                                    break;
                                }
                                LOG.warn("Frame discarded. Text aggregation disabled for {}", new Object[]{WebSocketConnectionD13.this._endp});
                                this.errorClose(1008, "Text frame aggregation disabled");
                                break;
                            }
                            if (this._utf8.append(buffer.array(), buffer.getIndex(), buffer.length(), WebSocketConnectionD13.this._connection.getMaxTextMessageSize())) {
                                if (lastFrame) {
                                    String msg = this._utf8.toString();
                                    this._utf8.reset();
                                    WebSocketConnectionD13.this._onTextMessage.onMessage(msg);
                                    break;
                                }
                                this._opcode = 1;
                                break;
                            }
                            this.textMessageTooLarge();
                        }
                        break;
                    }
                    case 2: {
                        if (this._opcode != -1) {
                            this.errorClose(1002, "Expected Continuation" + Integer.toHexString(opcode));
                            return;
                        }
                        if (WebSocketConnectionD13.this._onBinaryMessage != null && this.checkBinaryMessageSize(0, buffer.length())) {
                            if (lastFrame) {
                                WebSocketConnectionD13.this._onBinaryMessage.onMessage(array, buffer.getIndex(), buffer.length());
                                break;
                            }
                            if (WebSocketConnectionD13.this._connection.getMaxBinaryMessageSize() >= 0) {
                                this._opcode = opcode;
                                if (this._aggregate == null) {
                                    this._aggregate = new ByteArrayBuffer(WebSocketConnectionD13.this._connection.getMaxBinaryMessageSize());
                                }
                                this._aggregate.put(buffer);
                                break;
                            }
                            LOG.warn("Frame discarded. Binary aggregation disabed for {}", new Object[]{WebSocketConnectionD13.this._endp});
                            this.errorClose(1008, "Binary frame aggregation disabled");
                        }
                        break;
                    }
                    default: {
                        this.errorClose(1002, "Bad opcode 0x" + Integer.toHexString(opcode));
                    }
                }
            }
            catch (Utf8Appendable.NotUtf8Exception notUtf8) {
                LOG.warn("{} for {}", new Object[]{notUtf8, WebSocketConnectionD13.this._endp});
                LOG.debug((Throwable)notUtf8);
                this.errorClose(1007, "Invalid UTF-8");
            }
            catch (Throwable probablyNotUtf8) {
                LOG.warn("{} for {}", new Object[]{probablyNotUtf8, WebSocketConnectionD13.this._endp});
                LOG.debug(probablyNotUtf8);
                this.errorClose(1007, "Invalid Payload: " + probablyNotUtf8);
            }
        }

        private void errorClose(int code, String message) {
            WebSocketConnectionD13.this._connection.close(code, message);
            try {
                WebSocketConnectionD13.this._endp.close();
            }
            catch (IOException e) {
                LOG.warn(e.toString(), new Object[0]);
                LOG.debug((Throwable)e);
            }
        }

        private boolean checkBinaryMessageSize(int bufferLen, int length) {
            int max = WebSocketConnectionD13.this._connection.getMaxBinaryMessageSize();
            if (max > 0 && bufferLen + length > max) {
                LOG.warn("Binary message too large > {}B for {}", new Object[]{WebSocketConnectionD13.this._connection.getMaxBinaryMessageSize(), WebSocketConnectionD13.this._endp});
                WebSocketConnectionD13.this._connection.close(1009, "Message size > " + WebSocketConnectionD13.this._connection.getMaxBinaryMessageSize());
                this._opcode = (byte)-1;
                if (this._aggregate != null) {
                    this._aggregate.clear();
                }
                return false;
            }
            return true;
        }

        private void textMessageTooLarge() {
            LOG.warn("Text message too large > {} chars for {}", new Object[]{WebSocketConnectionD13.this._connection.getMaxTextMessageSize(), WebSocketConnectionD13.this._endp});
            WebSocketConnectionD13.this._connection.close(1009, "Text message size > " + WebSocketConnectionD13.this._connection.getMaxTextMessageSize() + " chars");
            this._opcode = (byte)-1;
            this._utf8.reset();
        }

        @Override
        public void close(int code, String message) {
            if (code != 1000) {
                LOG.warn("Close: " + code + " " + message, new Object[0]);
            }
            WebSocketConnectionD13.this._connection.close(code, message);
        }

        public String toString() {
            return WebSocketConnectionD13.this.toString() + "FH";
        }
    }
}

