/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.nested;

import java.lang.reflect.Method;
import javax.servlet.http.HttpServlet;
import org.eclipse.jetty.nested.NestedConnector;
import org.eclipse.jetty.osgi.nested.NestedConnectorServletDelegate;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.osgi.framework.FrameworkUtil;

public class NestedConnectorListener
extends AbstractLifeCycle.AbstractLifeCycleListener {
    private String bridgeServletClassName = "org.eclipse.equinox.servletbridge.BridgeServlet";
    private String registerServletDelegateMethodName = "registerServletDelegate";
    private String unregisterServletDelegateMethodName = "unregisterServletDelegate";
    private NestedConnectorServletDelegate _servletDelegate;
    private NestedConnector nestedConnector;

    public void setBridgeServletClassName(String bridgeServletClassName) {
        this.bridgeServletClassName = bridgeServletClassName;
    }

    public String getBridgeServletClassName() {
        return this.bridgeServletClassName;
    }

    public String getRegisterServletDelegateMethodName() {
        return this.registerServletDelegateMethodName;
    }

    public String getUnregisterServletDelegateMethodName() {
        return this.unregisterServletDelegateMethodName;
    }

    public void setRegisterServletDelegateMethodName(String registerServletDelegateMethodName) {
        this.registerServletDelegateMethodName = registerServletDelegateMethodName;
    }

    public void setUnregisterServletDelegateMethodName(String unregisterServletDelegateMethodName) {
        this.unregisterServletDelegateMethodName = unregisterServletDelegateMethodName;
    }

    public void setNestedConnector(NestedConnector nestedConnector) {
        this.nestedConnector = nestedConnector;
    }

    public NestedConnector getNestedConnector() {
        return this.nestedConnector;
    }

    public void lifeCycleStarted(LifeCycle event) {
        try {
            this.registerWithBridgeServlet();
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException("Unable to register the servlet delegate into the BridgeServlet.", e);
        }
    }

    public void lifeCycleStopping(LifeCycle event) {
        try {
            this.unregisterWithBridgeServlet();
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException("Unable to unregister the servlet delegate into the BridgeServlet.", e);
        }
    }

    protected void registerWithBridgeServlet() throws Exception {
        this._servletDelegate = new NestedConnectorServletDelegate(this.getNestedConnector());
        try {
            NestedConnectorListener.invokeStaticMethod(this.getBridgeServletClassName(), this.getRegisterServletDelegateMethodName(), new Class[]{HttpServlet.class}, new Object[]{this._servletDelegate});
        }
        catch (Throwable t) {
            this._servletDelegate.destroy();
            this._servletDelegate = null;
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw new RuntimeException("Unable to register the servlet delegate into the BridgeServlet.", t);
        }
    }

    protected void unregisterWithBridgeServlet() throws Exception {
        if (this._servletDelegate != null) {
            try {
                NestedConnectorListener.invokeStaticMethod(this.getBridgeServletClassName(), this.getUnregisterServletDelegateMethodName(), new Class[]{HttpServlet.class}, new Object[]{this._servletDelegate});
            }
            catch (Throwable t) {
                if (t instanceof Exception) {
                    throw (Exception)t;
                }
                throw new RuntimeException("Unable to unregister the servlet delegate from the BridgeServlet.", t);
            }
            finally {
                this._servletDelegate.destroy();
                this._servletDelegate = null;
            }
        }
    }

    private static void invokeStaticMethod(String clName, String methName, Class[] argType, Object ... args) throws Exception {
        Method m = NestedConnectorListener.getMethod(clName, methName, argType);
        m.invoke(null, args);
    }

    private static Method getMethod(String clName, String methName, Class ... argType) throws Exception {
        Class<?> bridgeServletClass = FrameworkUtil.class.getClassLoader().loadClass(clName);
        return NestedConnectorListener.getMethod(bridgeServletClass, methName, argType);
    }

    private static Method getMethod(Class cl, String methName, Class ... argType) throws Exception {
        Method meth = null;
        try {
            meth = cl.getMethod(methName, argType);
            return meth;
        }
        catch (Exception e) {
            for (Method m : cl.getMethods()) {
                if (!m.getName().equals(methName) || m.getParameterTypes().length != argType.length) continue;
                int i = 0;
                for (Class<?> p : m.getParameterTypes()) {
                    Class ap = argType[i];
                    if (!p.getName().equals(ap.getName()) || p.equals(ap)) continue;
                    throw new IllegalStateException("The method \"" + m.toGenericString() + "\" was found. but the parameter class " + p.getName() + " is not the same " + " inside OSGi classloader (" + ap.getClassLoader() + ") and inside the " + cl.getName() + " classloader (" + p.getClassLoader() + ")." + " Are the ExtensionBundles correctly defined?");
                }
            }
            throw e;
        }
    }
}

