/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.policy.entry;

import java.security.KeyStoreException;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import org.eclipse.jetty.policy.PolicyContext;
import org.eclipse.jetty.policy.PolicyException;
import org.eclipse.jetty.policy.entry.AbstractEntry;

public class PrincipalEntry
extends AbstractEntry {
    public static final String WILDCARD = "*";
    private String klass;
    private String name;
    private Principal principal;

    public Principal toPrincipal(PolicyContext context) throws PolicyException {
        if (this.principal != null && !this.isDirty()) {
            return this.principal;
        }
        if (context.getKeystore() == null) {
            return null;
        }
        try {
            Certificate certificate = context.getKeystore().getCertificate(this.name);
            if (certificate instanceof X509Certificate) {
                this.principal = ((X509Certificate)certificate).getSubjectX500Principal();
                return this.principal;
            }
            throw new PolicyException("Unknown Certificate, unable to obtain Principal: " + certificate.getType());
        }
        catch (KeyStoreException kse) {
            throw new PolicyException(kse);
        }
    }

    @Override
    public void expand(PolicyContext context) throws PolicyException {
        this.name = context.evaluate(this.name);
        this.setExpanded(true);
    }

    public String getKlass() {
        return this.klass;
    }

    public void setKlass(String klass) {
        this.klass = klass;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

