/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.boot.internal.serverfactory;

import java.net.URL;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.jetty.osgi.boot.internal.serverfactory.IManagedJettyServerRegistry;
import org.eclipse.jetty.osgi.boot.internal.serverfactory.ServerInstanceWrapper;
import org.eclipse.jetty.server.Server;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;

public class JettyServersManagedFactory
implements ManagedServiceFactory,
IManagedJettyServerRegistry {
    public static final String JETTY_HOME = "jettyhome";
    public static final String JETTY_CONFIG_XML = "jettyxml";
    public static final String JETTY_FACTORY = "jettyfactory";
    public static final String JETTY_HTTP_PORT = "jetty.http.port";
    public static final String JETTY_HTTPS_PORT = "jetty.http.port";
    private Map<String, ServerInstanceWrapper> _serversIndexedByPID = new HashMap<String, ServerInstanceWrapper>();
    private Map<String, String> _serversNameIndexedByPID = new HashMap<String, String>();
    private Map<String, String> _serversPIDIndexedByName = new HashMap<String, String>();

    public String getName() {
        return this.getClass().getName();
    }

    public void updated(String pid, Dictionary properties) throws ConfigurationException {
        ServerInstanceWrapper serverInstanceWrapper = this.getServerByPID(pid);
        this.deleted(pid);
        String name = (String)properties.get("managedServerName");
        if (name == null) {
            throw new ConfigurationException("managedServerName", "The name of the server is mandatory");
        }
        serverInstanceWrapper = new ServerInstanceWrapper(name);
        this._serversIndexedByPID.put(pid, serverInstanceWrapper);
        this._serversNameIndexedByPID.put(pid, name);
        this._serversPIDIndexedByName.put(name, pid);
        try {
            serverInstanceWrapper.start(new Server(), properties);
        }
        catch (Exception e) {
            throw new ConfigurationException(null, "Error starting jetty server instance", (Throwable)e);
        }
    }

    public synchronized void deleted(String pid) {
        ServerInstanceWrapper server = this._serversIndexedByPID.remove(pid);
        String name = this._serversNameIndexedByPID.remove(pid);
        if (name != null) {
            this._serversPIDIndexedByName.remove(name);
        }
        if (server != null) {
            try {
                server.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized ServerInstanceWrapper getServerByPID(String pid) {
        return this._serversIndexedByPID.get(pid);
    }

    @Override
    public ServerInstanceWrapper getServerInstanceWrapper(String managedServerName) {
        String pid = this._serversPIDIndexedByName.get(managedServerName);
        return pid != null ? this._serversIndexedByPID.get(pid) : null;
    }

    public static void createNewServer(Bundle contributor, String serverName, String urlsToJettyXml) throws Exception {
        ServiceReference configurationAdminReference = contributor.getBundleContext().getServiceReference(ConfigurationAdmin.class.getName());
        ConfigurationAdmin confAdmin = (ConfigurationAdmin)contributor.getBundleContext().getService(configurationAdminReference);
        Configuration configuration = confAdmin.createFactoryConfiguration("org.eclipse.jetty.osgi.boot.managedserverfactory", contributor.getLocation());
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("managedServerName", serverName);
        StringBuilder actualBundleUrls = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(urlsToJettyXml, ",", false);
        while (tokenizer.hasMoreTokens()) {
            String token;
            if (actualBundleUrls.length() != 0) {
                actualBundleUrls.append(",");
            }
            if ((token = tokenizer.nextToken()).indexOf(58) != -1) {
                actualBundleUrls.append(token);
                continue;
            }
            if (!token.startsWith("/")) continue;
            URL url = contributor.getEntry(token);
            if (url == null) {
                actualBundleUrls.append(token);
                continue;
            }
            actualBundleUrls.append(url.toString());
        }
        ((Dictionary)properties).put("jetty.etc.config.urls", actualBundleUrls.toString());
        configuration.update(properties);
    }
}

