/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.util.Collections;
import java.util.List;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.AsyncEndPoint;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.B64Code;
import org.eclipse.jetty.util.Utf8StringBuilder;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.Extension;
import org.eclipse.jetty.websocket.MaskGen;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketBuffers;
import org.eclipse.jetty.websocket.WebSocketConnection;
import org.eclipse.jetty.websocket.WebSocketGenerator;
import org.eclipse.jetty.websocket.WebSocketGeneratorD08;
import org.eclipse.jetty.websocket.WebSocketParser;
import org.eclipse.jetty.websocket.WebSocketParserD08;

public class WebSocketConnectionD08
extends AbstractConnection
implements WebSocketConnection {
    private static final Logger LOG = Log.getLogger(WebSocketConnectionD08.class);
    static final byte OP_CONTINUATION = 0;
    static final byte OP_TEXT = 1;
    static final byte OP_BINARY = 2;
    static final byte OP_EXT_DATA = 3;
    static final byte OP_CONTROL = 8;
    static final byte OP_CLOSE = 8;
    static final byte OP_PING = 9;
    static final byte OP_PONG = 10;
    static final byte OP_EXT_CTRL = 11;
    static final int CLOSE_NORMAL = 1000;
    static final int CLOSE_SHUTDOWN = 1001;
    static final int CLOSE_PROTOCOL = 1002;
    static final int CLOSE_BADDATA = 1003;
    static final int CLOSE_NOCODE = 1005;
    static final int CLOSE_NOCLOSE = 1006;
    static final int CLOSE_NOTUTF8 = 1007;
    static final int FLAG_FIN = 8;
    static final int VERSION = 8;
    private static final byte[] MAGIC;
    private final List<Extension> _extensions;
    private final WebSocketParserD08 _parser;
    private final WebSocketParser.FrameHandler _inbound;
    private final WebSocketGeneratorD08 _generator;
    private final WebSocketGenerator _outbound;
    private final WebSocket _webSocket;
    private final WebSocket.OnFrame _onFrame;
    private final WebSocket.OnBinaryMessage _onBinaryMessage;
    private final WebSocket.OnTextMessage _onTextMessage;
    private final WebSocket.OnControl _onControl;
    private final String _protocol;
    private final int _draft;
    private final ClassLoader _context;
    private volatile int _closeCode;
    private volatile String _closeMessage;
    private volatile boolean _closedIn;
    private volatile boolean _closedOut;
    private int _maxTextMessageSize = -1;
    private int _maxBinaryMessageSize = -1;
    private final WebSocketParser.FrameHandler _frameHandler = new WSFrameHandler();
    private final WebSocket.FrameConnection _connection = new WSFrameConnection();

    static boolean isLastFrame(byte flags) {
        return (flags & 8) != 0;
    }

    static boolean isControlFrame(byte opcode) {
        return (opcode & 8) != 0;
    }

    public WebSocketConnectionD08(WebSocket websocket, EndPoint endpoint, WebSocketBuffers buffers, long timestamp, int maxIdleTime, String protocol, List<Extension> extensions, int draft) throws IOException {
        this(websocket, endpoint, buffers, timestamp, maxIdleTime, protocol, extensions, draft, null);
    }

    public WebSocketConnectionD08(WebSocket websocket, EndPoint endpoint, WebSocketBuffers buffers, long timestamp, int maxIdleTime, String protocol, List<Extension> extensions, int draft, MaskGen maskgen) throws IOException {
        super(endpoint, timestamp);
        this._context = Thread.currentThread().getContextClassLoader();
        this._draft = draft;
        this._endp.setMaxIdleTime(maxIdleTime);
        this._webSocket = websocket;
        this._onFrame = this._webSocket instanceof WebSocket.OnFrame ? (WebSocket.OnFrame)this._webSocket : null;
        this._onTextMessage = this._webSocket instanceof WebSocket.OnTextMessage ? (WebSocket.OnTextMessage)this._webSocket : null;
        this._onBinaryMessage = this._webSocket instanceof WebSocket.OnBinaryMessage ? (WebSocket.OnBinaryMessage)this._webSocket : null;
        this._onControl = this._webSocket instanceof WebSocket.OnControl ? (WebSocket.OnControl)this._webSocket : null;
        this._generator = new WebSocketGeneratorD08(buffers, this._endp, maskgen);
        this._extensions = extensions;
        if (this._extensions != null) {
            int e = 0;
            for (Extension extension : this._extensions) {
                extension.bind(this._connection, e == extensions.size() - 1 ? this._frameHandler : (WebSocketParser.FrameHandler)extensions.get(e + 1), e == 0 ? this._generator : (WebSocketGenerator)extensions.get(e - 1));
                ++e;
            }
        }
        this._outbound = this._extensions == null || this._extensions.size() == 0 ? this._generator : (WebSocketGenerator)extensions.get(extensions.size() - 1);
        this._inbound = this._extensions == null || this._extensions.size() == 0 ? this._frameHandler : (WebSocketParser.FrameHandler)extensions.get(0);
        this._parser = new WebSocketParserD08(buffers, endpoint, this._inbound, maskgen == null);
        this._protocol = protocol;
    }

    @Override
    public WebSocket.Connection getConnection() {
        return this._connection;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this._extensions == null) {
            return Collections.emptyList();
        }
        return this._extensions;
    }

    public Connection handle() throws IOException {
        Thread current = Thread.currentThread();
        ClassLoader oldcontext = current.getContextClassLoader();
        current.setContextClassLoader(this._context);
        try {
            boolean progress = true;
            while (progress) {
                int flushed = this._generator.flushBuffer();
                int filled = this._parser.parseNext();
                boolean bl = progress = flushed > 0 || filled > 0;
                if (filled >= 0 && flushed >= 0) continue;
                this._endp.close();
                break;
            }
        }
        catch (IOException e) {
            try {
                this._endp.close();
            }
            catch (IOException e2) {
                LOG.ignore((Throwable)e2);
            }
            throw e;
        }
        finally {
            current.setContextClassLoader(oldcontext);
            this._parser.returnBuffer();
            this._generator.returnBuffer();
            if (this._endp.isOpen()) {
                if (this._closedIn && this._closedOut && this._outbound.isBufferEmpty()) {
                    this._endp.close();
                } else if (this._endp.isInputShutdown() && !this._closedIn) {
                    this.closeIn(1006, null);
                } else {
                    this.checkWriteable();
                }
            }
        }
        return this;
    }

    public void onInputShutdown() throws IOException {
    }

    public boolean isIdle() {
        return this._parser.isBufferEmpty() && this._outbound.isBufferEmpty();
    }

    public void onIdleExpired(long idleForMs) {
        this.closeOut(1000, "Idle for " + idleForMs + "ms > " + this._endp.getMaxIdleTime() + "ms");
    }

    public boolean isSuspended() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClose() {
        boolean closed;
        WebSocketConnectionD08 webSocketConnectionD08 = this;
        synchronized (webSocketConnectionD08) {
            boolean bl = closed = this._closeCode == 0;
            if (closed) {
                this._closeCode = 1006;
            }
        }
        if (closed) {
            this._webSocket.onClose(1006, "closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeIn(int code, String message) {
        boolean closed;
        boolean closedOut;
        LOG.debug("ClosedIn {} {}", new Object[]{this, message});
        WebSocketConnectionD08 webSocketConnectionD08 = this;
        synchronized (webSocketConnectionD08) {
            closedOut = this._closedOut;
            this._closedIn = true;
            boolean bl = closed = this._closeCode == 0;
            if (closed) {
                this._closeCode = code;
                this._closeMessage = message;
            }
        }
        try {
            if (closed) {
                this._webSocket.onClose(code, message);
            }
        }
        finally {
            try {
                if (closedOut) {
                    this._endp.close();
                } else {
                    this.closeOut(code, message);
                }
            }
            catch (IOException e) {
                LOG.ignore((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeOut(int code, String message) {
        boolean close;
        block16: {
            boolean closed;
            LOG.debug("ClosedOut {} {}", new Object[]{this, message});
            WebSocketConnectionD08 webSocketConnectionD08 = this;
            synchronized (webSocketConnectionD08) {
                close = this._closedIn || this._closedOut;
                this._closedOut = true;
                boolean bl = closed = this._closeCode == 0;
                if (closed) {
                    this._closeCode = code;
                    this._closeMessage = message;
                }
            }
            try {
                if (!closed) break block16;
                this._webSocket.onClose(code, message);
            }
            catch (Throwable throwable) {
                try {
                    if (close) {
                        this._endp.close();
                    } else {
                        if (code <= 0) {
                            code = 1000;
                        }
                        byte[] bytes = ("xx" + (message == null ? "" : message)).getBytes("ISO-8859-1");
                        bytes[0] = (byte)(code / 256);
                        bytes[1] = (byte)(code % 256);
                        this._outbound.addFrame((byte)8, (byte)8, bytes, 0, bytes.length);
                    }
                    this._outbound.flush();
                }
                catch (IOException e) {
                    LOG.ignore((Throwable)e);
                }
                throw throwable;
            }
        }
        try {
            if (close) {
                this._endp.close();
            } else {
                if (code <= 0) {
                    code = 1000;
                }
                byte[] bytes = ("xx" + (message == null ? "" : message)).getBytes("ISO-8859-1");
                bytes[0] = (byte)(code / 256);
                bytes[1] = (byte)(code % 256);
                this._outbound.addFrame((byte)8, (byte)8, bytes, 0, bytes.length);
            }
            this._outbound.flush();
        }
        catch (IOException e) {
            LOG.ignore((Throwable)e);
        }
    }

    @Override
    public void shutdown() {
        WebSocket.FrameConnection connection = this._connection;
        if (connection != null) {
            connection.close(1001, null);
        }
    }

    @Override
    public void fillBuffersFrom(Buffer buffer) {
        this._parser.fill(buffer);
    }

    private void checkWriteable() {
        if (!this._outbound.isBufferEmpty() && this._endp instanceof AsyncEndPoint) {
            ((AsyncEndPoint)this._endp).scheduleWrite();
        }
    }

    protected void onFrameHandshake() {
        if (this._onFrame != null) {
            this._onFrame.onHandshake(this._connection);
        }
    }

    protected void onWebSocketOpen() {
        this._webSocket.onOpen(this._connection);
    }

    public static String hashKey(String key) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            md.update(key.getBytes("UTF-8"));
            md.update(MAGIC);
            return new String(B64Code.encode((byte[])md.digest()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return String.format("WS/D%d p=%s g=%s", this._draft, this._parser, this._generator);
    }

    static {
        try {
            MAGIC = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11".getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private class WSFrameConnection
    implements WebSocket.FrameConnection {
        volatile boolean _disconnecting;

        private WSFrameConnection() {
        }

        @Override
        public void sendMessage(String content) throws IOException {
            if (WebSocketConnectionD08.this._closedOut) {
                throw new IOException("closedOut " + WebSocketConnectionD08.this._closeCode + ":" + WebSocketConnectionD08.this._closeMessage);
            }
            byte[] data = content.getBytes("UTF-8");
            WebSocketConnectionD08.this._outbound.addFrame((byte)8, (byte)1, data, 0, data.length);
            WebSocketConnectionD08.this.checkWriteable();
        }

        @Override
        public void sendMessage(byte[] content, int offset, int length) throws IOException {
            if (WebSocketConnectionD08.this._closedOut) {
                throw new IOException("closedOut " + WebSocketConnectionD08.this._closeCode + ":" + WebSocketConnectionD08.this._closeMessage);
            }
            WebSocketConnectionD08.this._outbound.addFrame((byte)8, (byte)2, content, offset, length);
            WebSocketConnectionD08.this.checkWriteable();
        }

        @Override
        public void sendFrame(byte flags, byte opcode, byte[] content, int offset, int length) throws IOException {
            if (WebSocketConnectionD08.this._closedOut) {
                throw new IOException("closedOut " + WebSocketConnectionD08.this._closeCode + ":" + WebSocketConnectionD08.this._closeMessage);
            }
            WebSocketConnectionD08.this._outbound.addFrame(flags, opcode, content, offset, length);
            WebSocketConnectionD08.this.checkWriteable();
        }

        @Override
        public void sendControl(byte ctrl, byte[] data, int offset, int length) throws IOException {
            if (WebSocketConnectionD08.this._closedOut) {
                throw new IOException("closedOut " + WebSocketConnectionD08.this._closeCode + ":" + WebSocketConnectionD08.this._closeMessage);
            }
            WebSocketConnectionD08.this._outbound.addFrame((byte)8, ctrl, data, offset, length);
            WebSocketConnectionD08.this.checkWriteable();
        }

        @Override
        public boolean isMessageComplete(byte flags) {
            return WebSocketConnectionD08.isLastFrame(flags);
        }

        @Override
        public boolean isOpen() {
            return WebSocketConnectionD08.this._endp != null && WebSocketConnectionD08.this._endp.isOpen();
        }

        @Override
        public void close(int code, String message) {
            if (this._disconnecting) {
                return;
            }
            this._disconnecting = true;
            WebSocketConnectionD08.this.closeOut(code, message);
        }

        @Override
        public void setMaxIdleTime(int ms) {
            try {
                WebSocketConnectionD08.this._endp.setMaxIdleTime(ms);
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
        }

        @Override
        public void setMaxTextMessageSize(int size) {
            WebSocketConnectionD08.this._maxTextMessageSize = size;
        }

        @Override
        public void setMaxBinaryMessageSize(int size) {
            WebSocketConnectionD08.this._maxBinaryMessageSize = size;
        }

        @Override
        public int getMaxIdleTime() {
            return WebSocketConnectionD08.this._endp.getMaxIdleTime();
        }

        @Override
        public int getMaxTextMessageSize() {
            return WebSocketConnectionD08.this._maxTextMessageSize;
        }

        @Override
        public int getMaxBinaryMessageSize() {
            return WebSocketConnectionD08.this._maxBinaryMessageSize;
        }

        @Override
        public String getProtocol() {
            return WebSocketConnectionD08.this._protocol;
        }

        @Override
        public byte binaryOpcode() {
            return 2;
        }

        @Override
        public byte textOpcode() {
            return 1;
        }

        @Override
        public byte continuationOpcode() {
            return 0;
        }

        @Override
        public byte finMask() {
            return 8;
        }

        @Override
        public boolean isControl(byte opcode) {
            return WebSocketConnectionD08.isControlFrame(opcode);
        }

        @Override
        public boolean isText(byte opcode) {
            return opcode == 1;
        }

        @Override
        public boolean isBinary(byte opcode) {
            return opcode == 2;
        }

        @Override
        public boolean isContinuation(byte opcode) {
            return opcode == 0;
        }

        @Override
        public boolean isClose(byte opcode) {
            return opcode == 8;
        }

        @Override
        public boolean isPing(byte opcode) {
            return opcode == 9;
        }

        @Override
        public boolean isPong(byte opcode) {
            return opcode == 10;
        }

        @Override
        public void disconnect() {
            this.close();
        }

        @Override
        public void close() {
            this.close(1000, null);
        }

        @Override
        public void setAllowFrameFragmentation(boolean allowFragmentation) {
            WebSocketConnectionD08.this._parser.setFakeFragments(allowFragmentation);
        }

        @Override
        public boolean isAllowFrameFragmentation() {
            return WebSocketConnectionD08.this._parser.isFakeFragments();
        }

        public String toString() {
            return this.getClass().getSimpleName() + "D08@" + WebSocketConnectionD08.this._endp.getLocalAddr() + ":" + WebSocketConnectionD08.this._endp.getLocalPort() + "<->" + WebSocketConnectionD08.this._endp.getRemoteAddr() + ":" + WebSocketConnectionD08.this._endp.getRemotePort();
        }
    }

    private class WSFrameHandler
    implements WebSocketParser.FrameHandler {
        private final Utf8StringBuilder _utf8 = new Utf8StringBuilder();
        private ByteArrayBuffer _aggregate;
        private byte _opcode = (byte)-1;

        private WSFrameHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void onFrame(byte flags, byte opcode, Buffer buffer) {
            boolean lastFrame = WebSocketConnectionD08.isLastFrame(flags);
            WebSocketConnectionD08 webSocketConnectionD08 = WebSocketConnectionD08.this;
            synchronized (webSocketConnectionD08) {
                if (WebSocketConnectionD08.this._closedIn) {
                    return;
                }
            }
            try {
                byte[] array = buffer.array();
                if (WebSocketConnectionD08.this._onFrame != null && WebSocketConnectionD08.this._onFrame.onFrame(flags, opcode, array, buffer.getIndex(), buffer.length())) {
                    return;
                }
                if (WebSocketConnectionD08.this._onControl != null && WebSocketConnectionD08.isControlFrame(opcode) && WebSocketConnectionD08.this._onControl.onControl(opcode, array, buffer.getIndex(), buffer.length())) {
                    return;
                }
                switch (opcode) {
                    case 0: {
                        if (WebSocketConnectionD08.this._onTextMessage != null && this._opcode == 1) {
                            if (this._utf8.append(buffer.array(), buffer.getIndex(), buffer.length(), WebSocketConnectionD08.this._connection.getMaxTextMessageSize())) {
                                if (lastFrame) {
                                    this._opcode = (byte)-1;
                                    String msg = this._utf8.toString();
                                    this._utf8.reset();
                                    WebSocketConnectionD08.this._onTextMessage.onMessage(msg);
                                }
                            } else {
                                this.textMessageTooLarge();
                            }
                        }
                        if (this._opcode < 0 || WebSocketConnectionD08.this._connection.getMaxBinaryMessageSize() < 0 || !this.checkBinaryMessageSize(this._aggregate.length(), buffer.length())) return;
                        this._aggregate.put(buffer);
                        if (!lastFrame || WebSocketConnectionD08.this._onBinaryMessage == null) return;
                        try {
                            WebSocketConnectionD08.this._onBinaryMessage.onMessage(this._aggregate.array(), this._aggregate.getIndex(), this._aggregate.length());
                            return;
                        }
                        finally {
                            this._opcode = (byte)-1;
                            this._aggregate.clear();
                        }
                    }
                    case 9: {
                        LOG.debug("PING {}", new Object[]{this});
                        if (WebSocketConnectionD08.this._closedOut) return;
                        WebSocketConnectionD08.this._connection.sendControl((byte)10, buffer.array(), buffer.getIndex(), buffer.length());
                        return;
                    }
                    case 10: {
                        LOG.debug("PONG {}", new Object[]{this});
                        return;
                    }
                    case 8: {
                        int code = 1005;
                        String message = null;
                        if (buffer.length() >= 2) {
                            code = buffer.array()[buffer.getIndex()] * 256 + buffer.array()[buffer.getIndex() + 1];
                            if (buffer.length() > 2) {
                                message = new String(buffer.array(), buffer.getIndex() + 2, buffer.length() - 2, "UTF-8");
                            }
                        }
                        WebSocketConnectionD08.this.closeIn(code, message);
                        return;
                    }
                    case 1: {
                        if (WebSocketConnectionD08.this._onTextMessage == null) return;
                        if (WebSocketConnectionD08.this._connection.getMaxTextMessageSize() <= 0) {
                            if (lastFrame) {
                                WebSocketConnectionD08.this._onTextMessage.onMessage(buffer.toString("UTF-8"));
                                return;
                            }
                            LOG.warn("Frame discarded. Text aggregation disabled for {}", new Object[]{WebSocketConnectionD08.this._endp});
                            WebSocketConnectionD08.this._connection.close(1003, "Text frame aggregation disabled");
                            return;
                        }
                        if (this._utf8.append(buffer.array(), buffer.getIndex(), buffer.length(), WebSocketConnectionD08.this._connection.getMaxTextMessageSize())) {
                            if (lastFrame) {
                                String msg = this._utf8.toString();
                                this._utf8.reset();
                                WebSocketConnectionD08.this._onTextMessage.onMessage(msg);
                                return;
                            }
                            this._opcode = 1;
                            return;
                        }
                        this.textMessageTooLarge();
                        return;
                    }
                    default: {
                        if (WebSocketConnectionD08.this._onBinaryMessage == null || !this.checkBinaryMessageSize(0, buffer.length())) return;
                        if (lastFrame) {
                            WebSocketConnectionD08.this._onBinaryMessage.onMessage(array, buffer.getIndex(), buffer.length());
                            return;
                        }
                        if (WebSocketConnectionD08.this._connection.getMaxBinaryMessageSize() >= 0) {
                            this._opcode = opcode;
                            if (this._aggregate == null) {
                                this._aggregate = new ByteArrayBuffer(WebSocketConnectionD08.this._connection.getMaxBinaryMessageSize());
                            }
                            this._aggregate.put(buffer);
                            return;
                        }
                        LOG.warn("Frame discarded. Binary aggregation disabed for {}", new Object[]{WebSocketConnectionD08.this._endp});
                        WebSocketConnectionD08.this._connection.close(1003, "Binary frame aggregation disabled");
                    }
                }
                return;
            }
            catch (Throwable th) {
                LOG.warn(th);
            }
        }

        private boolean checkBinaryMessageSize(int bufferLen, int length) {
            int max = WebSocketConnectionD08.this._connection.getMaxBinaryMessageSize();
            if (max > 0 && bufferLen + length > max) {
                LOG.warn("Binary message too large > {}B for {}", new Object[]{WebSocketConnectionD08.this._connection.getMaxBinaryMessageSize(), WebSocketConnectionD08.this._endp});
                WebSocketConnectionD08.this._connection.close(1003, "Message size > " + WebSocketConnectionD08.this._connection.getMaxBinaryMessageSize());
                this._opcode = (byte)-1;
                if (this._aggregate != null) {
                    this._aggregate.clear();
                }
                return false;
            }
            return true;
        }

        private void textMessageTooLarge() {
            LOG.warn("Text message too large > {} chars for {}", new Object[]{WebSocketConnectionD08.this._connection.getMaxTextMessageSize(), WebSocketConnectionD08.this._endp});
            WebSocketConnectionD08.this._connection.close(1003, "Text message size > " + WebSocketConnectionD08.this._connection.getMaxTextMessageSize() + " chars");
            this._opcode = (byte)-1;
            this._utf8.reset();
        }

        @Override
        public void close(int code, String message) {
            if (code != 1000) {
                LOG.warn("Close: " + code + " " + message, new Object[0]);
            }
            WebSocketConnectionD08.this._connection.close(code, message);
        }

        public String toString() {
            return WebSocketConnectionD08.this.toString() + "FH";
        }
    }
}

